/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite;

import jakarta.transaction.Transaction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.GuardedBy;
import org.infinispan.Cache;
import org.infinispan.commands.AbstractVisitor;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.functional.ReadWriteKeyValueCommand;
import org.infinispan.commands.functional.ReadWriteManyCommand;
import org.infinispan.commands.functional.ReadWriteManyEntriesCommand;
import org.infinispan.commands.functional.WriteOnlyKeyCommand;
import org.infinispan.commands.functional.WriteOnlyKeyValueCommand;
import org.infinispan.commands.functional.WriteOnlyManyCommand;
import org.infinispan.commands.functional.WriteOnlyManyEntriesCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.AbstractDataWriteCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.ComputeCommand;
import org.infinispan.commands.write.ComputeIfAbsentCommand;
import org.infinispan.commands.write.IracPutKeyValueCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.CustomFailurePolicy;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.interceptors.InvocationStage;
import org.infinispan.interceptors.SyncInvocationStage;
import org.infinispan.interceptors.impl.SimpleAsyncInvocationStage;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.XSiteResponse;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.util.logging.events.EventLogManager;
import org.infinispan.xsite.BackupFailureException;
import org.infinispan.xsite.BackupSender;
import org.infinispan.xsite.SingleXSiteRpcCommand;
import org.infinispan.xsite.XSiteBackup;
import org.infinispan.xsite.commands.remote.XSiteCacheRequest;
import org.infinispan.xsite.status.SiteState;
import org.infinispan.xsite.status.TakeOfflineManager;

@Scope(value=Scopes.NAMED_CACHE)
public class BackupSenderImpl
implements BackupSender {
    private static final Log log = LogFactory.getLog(BackupSenderImpl.class);
    @Inject
    ComponentRef<Cache<Object, Object>> cache;
    @Inject
    RpcManager rpcManager;
    @Inject
    Configuration config;
    @Inject
    TransactionTable txTable;
    @Inject
    TimeService timeService;
    @Inject
    CommandsFactory commandsFactory;
    @Inject
    EventLogManager eventLogManager;
    @Inject
    GlobalConfiguration globalConfig;
    @Inject
    KeyPartitioner keyPartitioner;
    @Inject
    TakeOfflineManager takeOfflineManager;
    private final Map<String, CustomFailurePolicy<Object, Object>> siteFailurePolicy = new HashMap<String, CustomFailurePolicy<Object, Object>>();
    private String localSiteName;
    private String cacheName;

    @Start
    public void start() {
        Transport transport = this.rpcManager.getTransport();
        transport.checkCrossSiteAvailable();
        this.cacheName = this.cache.wired().getName();
        this.localSiteName = transport.localSiteName();
        this.config.sites().syncBackupsStream().filter(bc -> bc.backupFailurePolicy() == BackupFailurePolicy.CUSTOM).forEach(bc -> {
            String backupPolicy = bc.failurePolicyClass();
            if (backupPolicy == null) {
                throw new IllegalStateException("Backup policy class missing for custom failure policy!");
            }
            CustomFailurePolicy instance = (CustomFailurePolicy)Util.getInstance((String)backupPolicy, (ClassLoader)this.globalConfig.classLoader());
            instance.init(this.cache.wired());
            this.siteFailurePolicy.put(bc.site(), instance);
        });
    }

    @Override
    public InvocationStage backupPrepare(PrepareCommand command, AbstractCacheTransaction cacheTransaction, Transaction transaction) {
        List<WriteCommand> modifications = this.filterModifications(command.getModifications(), cacheTransaction.getLookedUpEntries());
        if (modifications.isEmpty()) {
            return SyncInvocationStage.completedNullStage();
        }
        PrepareCommand prepare = this.commandsFactory.buildPrepareCommand(command.getGlobalTransaction(), modifications, command.isOnePhaseCommit());
        BackupFilter filter = !prepare.isOnePhaseCommit() ? BackupFilter.KEEP_2PC_ONLY : BackupFilter.KEEP_ALL;
        List<XSiteBackup> backups = this.calculateBackupInfo(filter);
        if (backups.isEmpty()) {
            return SyncInvocationStage.completedNullStage();
        }
        return this.backupCommand(prepare, command, backups, transaction);
    }

    @Override
    public InvocationStage backupWrite(WriteCommand command, WriteCommand originalCommand) {
        List<XSiteBackup> xSiteBackups = this.calculateBackupInfo(BackupFilter.KEEP_ALL);
        return this.backupCommand(command, originalCommand, xSiteBackups, null);
    }

    @Override
    public InvocationStage backupClear(ClearCommand command) {
        List<XSiteBackup> xSiteBackups = this.calculateBackupInfo(BackupFilter.KEEP_ALL);
        return this.backupCommand(command, command, xSiteBackups, null);
    }

    @Override
    public InvocationStage backupCommit(CommitCommand command, Transaction transaction) {
        ResponseAggregator aggregator = new ResponseAggregator(command, transaction);
        this.sendTo1PCBackups(command, aggregator);
        this.sendTo2PCBackups(command, aggregator);
        return aggregator.freeze();
    }

    @Override
    public InvocationStage backupRollback(RollbackCommand command, Transaction transaction) {
        List<XSiteBackup> xSiteBackups = this.calculateBackupInfo(BackupFilter.KEEP_2PC_ONLY);
        return this.backupCommand(command, command, xSiteBackups, transaction);
    }

    public CustomFailurePolicy<Object, Object> getCustomFailurePolicy(String site) {
        return this.siteFailurePolicy.get(site);
    }

    private InvocationStage backupCommand(VisitableCommand command, VisitableCommand originalCommand, List<XSiteBackup> xSiteBackups, Transaction transaction) {
        SingleXSiteRpcCommand xsiteCommand = this.commandsFactory.buildSingleXSiteRpcCommand(command);
        ResponseAggregator aggregator = new ResponseAggregator(originalCommand, transaction);
        this.sendTo(xsiteCommand, xSiteBackups, aggregator);
        return aggregator.freeze();
    }

    private void sendTo(XSiteCacheRequest<Object> command, Collection<XSiteBackup> xSiteBackups, ResponseAggregator aggregator) {
        for (XSiteBackup backup : xSiteBackups) {
            XSiteResponse<Object> cs = this.rpcManager.invokeXSite(backup, command);
            this.takeOfflineManager.registerRequest(cs);
            aggregator.addResponse(backup, cs);
        }
    }

    private void sendTo1PCBackups(CommitCommand command, ResponseAggregator aggregator) {
        LocalTransaction localTx = this.txTable.getLocalTransaction(command.getGlobalTransaction());
        List<WriteCommand> modifications = this.filterModifications(localTx.getModifications(), localTx.getLookedUpEntries());
        if (modifications.isEmpty()) {
            return;
        }
        List<XSiteBackup> xSiteBackups = this.calculateBackupInfo(BackupFilter.KEEP_1PC_ONLY);
        if (xSiteBackups.isEmpty()) {
            return;
        }
        PrepareCommand prepare = this.commandsFactory.buildPrepareCommand(command.getGlobalTransaction(), modifications, true);
        SingleXSiteRpcCommand xsiteCommand = this.commandsFactory.buildSingleXSiteRpcCommand(prepare);
        this.sendTo(xsiteCommand, xSiteBackups, aggregator);
    }

    private void sendTo2PCBackups(CommitCommand command, ResponseAggregator aggregator) {
        List<XSiteBackup> xSiteBackups = this.calculateBackupInfo(BackupFilter.KEEP_2PC_ONLY);
        if (xSiteBackups.isEmpty()) {
            return;
        }
        SingleXSiteRpcCommand xsiteCommand = this.commandsFactory.buildSingleXSiteRpcCommand(command);
        this.sendTo(xsiteCommand, xSiteBackups, aggregator);
    }

    private List<XSiteBackup> calculateBackupInfo(BackupFilter backupFilter) {
        ArrayList<XSiteBackup> backupInfo = new ArrayList<XSiteBackup>(2);
        Iterator iterator = this.config.sites().syncBackupsStream().iterator();
        while (iterator.hasNext()) {
            BackupConfiguration bc = (BackupConfiguration)((Object)iterator.next());
            if (bc.site().equals(this.localSiteName)) {
                log.cacheBackupsDataToSameSite(this.localSiteName);
                continue;
            }
            boolean is2PC = bc.isTwoPhaseCommit();
            if (backupFilter == BackupFilter.KEEP_1PC_ONLY && is2PC || backupFilter == BackupFilter.KEEP_2PC_ONLY && !is2PC) continue;
            if (this.takeOfflineManager.getSiteState(bc.site()) == SiteState.OFFLINE) {
                log.tracef("The site '%s' is offline, not backing up information to it", bc.site());
                continue;
            }
            XSiteBackup bi = new XSiteBackup(bc.site(), true, bc.replicationTimeout());
            backupInfo.add(bi);
        }
        return backupInfo;
    }

    private List<WriteCommand> filterModifications(List<WriteCommand> modifications, Map<Object, CacheEntry> lookedUpEntries) {
        if (modifications == null || modifications.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<WriteCommand> filtered = new ArrayList<WriteCommand>(modifications.size());
        HashSet filteredKeys = new HashSet(modifications.size());
        ListIterator<WriteCommand> it = modifications.listIterator(modifications.size());
        while (it.hasPrevious()) {
            WriteCommand writeCommand = it.previous();
            if (!writeCommand.shouldReplicate(null, true) || writeCommand.hasAnyFlag(FlagBitSets.SKIP_XSITE_BACKUP)) continue;
            for (Object key : writeCommand.getAffectedKeys()) {
                AbstractDataWriteCommand replicatedCommand;
                if (filteredKeys.contains(key)) continue;
                CacheEntry entry = lookedUpEntries.get(key);
                if (entry == null) {
                    throw new IllegalStateException();
                }
                if (entry.isRemoved()) {
                    replicatedCommand = this.commandsFactory.buildRemoveCommand(key, null, this.keyPartitioner.getSegment(key), writeCommand.getFlagsBitSet());
                } else {
                    if (!entry.isChanged()) continue;
                    replicatedCommand = this.commandsFactory.buildPutKeyValueCommand(key, entry.getValue(), this.keyPartitioner.getSegment(key), entry.getMetadata(), writeCommand.getFlagsBitSet());
                }
                filtered.add(replicatedCommand);
                filteredKeys.add(key);
            }
        }
        return filtered;
    }

    private static enum BackupFilter {
        KEEP_1PC_ONLY,
        KEEP_2PC_ONLY,
        KEEP_ALL;

    }

    private class ResponseAggregator
    extends CompletableFuture<Void>
    implements XSiteResponse.XSiteResponseCompleted {
        private final VisitableCommand command;
        private final Transaction transaction;
        private final AtomicInteger counter;
        @GuardedBy(value="this")
        private BackupFailureException exception;
        private volatile boolean frozen;

        private ResponseAggregator(VisitableCommand command, Transaction transaction) {
            this.command = command;
            this.transaction = transaction;
            this.counter = new AtomicInteger();
        }

        @Override
        public void onCompleted(XSiteBackup backup, long sendTimeNanos, long durationNanos, Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.tracef("Backup response from site %s completed for command %s. throwable=%s", this.command, backup, throwable);
            }
            if (backup.isSync()) {
                if (throwable != null) {
                    this.handleException(backup.getSiteName(), throwable);
                }
                if (this.counter.decrementAndGet() == 0 && this.frozen) {
                    this.onRequestCompleted();
                }
            }
        }

        void addResponse(XSiteBackup backup, XSiteResponse<Object> response) {
            assert (!this.frozen);
            response.whenCompleted(this);
            if (backup.isSync()) {
                this.counter.incrementAndGet();
            }
        }

        InvocationStage freeze() {
            this.frozen = true;
            if (this.counter.get() == 0) {
                this.onRequestCompleted();
            }
            return new SimpleAsyncInvocationStage(this);
        }

        void handleException(String siteName, Throwable throwable) {
            switch (BackupSenderImpl.this.config.sites().getFailurePolicy(siteName)) {
                case FAIL: {
                    this.addException(siteName, throwable);
                    break;
                }
                case CUSTOM: {
                    try {
                        this.command.acceptVisitor(null, new CustomBackupPolicyInvoker(siteName, BackupSenderImpl.this.getCustomFailurePolicy(siteName), this.transaction));
                    }
                    catch (Throwable t) {
                        this.addException(siteName, t);
                    }
                    break;
                }
                case WARN: {
                    log.warnXsiteBackupFailed(BackupSenderImpl.this.cacheName, siteName, throwable);
                }
            }
        }

        synchronized void addException(String siteName, Throwable throwable) {
            if (this.exception == null) {
                this.exception = new BackupFailureException(BackupSenderImpl.this.cacheName);
            }
            this.exception.addSuppressed((Throwable)((Object)new BackupFailureException(siteName, throwable)));
        }

        private synchronized void onRequestCompleted() {
            if (this.exception != null) {
                this.completeExceptionally((Throwable)((Object)this.exception));
            } else {
                this.complete(null);
            }
        }
    }

    private static final class CustomBackupPolicyInvoker
    extends AbstractVisitor {
        private final String site;
        private final CustomFailurePolicy<Object, Object> failurePolicy;
        private final Transaction tx;

        public CustomBackupPolicyInvoker(String site, CustomFailurePolicy<Object, Object> failurePolicy, Transaction tx) {
            this.site = site;
            this.failurePolicy = failurePolicy;
            this.tx = tx;
        }

        @Override
        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) {
            this.failurePolicy.handlePutFailure(this.site, command.getKey(), command.getValue(), command.isPutIfAbsent());
            return null;
        }

        @Override
        public Object visitIracPutKeyValueCommand(InvocationContext ctx, IracPutKeyValueCommand command) {
            return null;
        }

        @Override
        public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) {
            this.failurePolicy.handleRemoveFailure(this.site, command.getKey(), command.getValue());
            return null;
        }

        @Override
        public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) {
            this.failurePolicy.handleReplaceFailure(this.site, command.getKey(), command.getOldValue(), command.getNewValue());
            return null;
        }

        @Override
        public Object visitComputeCommand(InvocationContext ctx, ComputeCommand command) {
            this.failurePolicy.handleComputeFailure(this.site, command.getKey(), command.getRemappingBiFunction(), command.isComputeIfPresent());
            return null;
        }

        @Override
        public Object visitComputeIfAbsentCommand(InvocationContext ctx, ComputeIfAbsentCommand command) {
            this.failurePolicy.handleComputeIfAbsentFailure(this.site, command.getKey(), command.getMappingFunction());
            return null;
        }

        @Override
        public Object visitWriteOnlyKeyCommand(InvocationContext ctx, WriteOnlyKeyCommand command) {
            this.failurePolicy.handleWriteOnlyKeyFailure(this.site, command.getKey());
            return null;
        }

        @Override
        public Object visitReadWriteKeyValueCommand(InvocationContext ctx, ReadWriteKeyValueCommand command) {
            this.failurePolicy.handleReadWriteKeyValueFailure(this.site, command.getKey());
            return null;
        }

        @Override
        public Object visitReadWriteKeyCommand(InvocationContext ctx, ReadWriteKeyCommand command) {
            this.failurePolicy.handleReadWriteKeyFailure(this.site, command.getKey());
            return null;
        }

        @Override
        public Object visitWriteOnlyManyEntriesCommand(InvocationContext ctx, WriteOnlyManyEntriesCommand command) {
            this.failurePolicy.handleWriteOnlyManyEntriesFailure(this.site, command.getArguments());
            return null;
        }

        @Override
        public Object visitWriteOnlyKeyValueCommand(InvocationContext ctx, WriteOnlyKeyValueCommand command) {
            this.failurePolicy.handleWriteOnlyKeyValueFailure(this.site, command.getKey());
            return null;
        }

        @Override
        public Object visitWriteOnlyManyCommand(InvocationContext ctx, WriteOnlyManyCommand command) {
            this.failurePolicy.handleWriteOnlyManyFailure(this.site, command.getAffectedKeys());
            return null;
        }

        @Override
        public Object visitReadWriteManyCommand(InvocationContext ctx, ReadWriteManyCommand command) {
            this.failurePolicy.handleReadWriteManyFailure(this.site, command.getAffectedKeys());
            return null;
        }

        @Override
        public Object visitReadWriteManyEntriesCommand(InvocationContext ctx, ReadWriteManyEntriesCommand command) {
            this.failurePolicy.handleReadWriteManyEntriesFailure(this.site, command.getArguments());
            return null;
        }

        @Override
        public Object visitClearCommand(InvocationContext ctx, ClearCommand command) {
            this.failurePolicy.handleClearFailure(this.site);
            return null;
        }

        @Override
        public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) {
            this.failurePolicy.handlePutAllFailure(this.site, command.getMap());
            return null;
        }

        @Override
        public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) {
            this.failurePolicy.handlePrepareFailure(this.site, this.tx);
            return null;
        }

        @Override
        public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) {
            this.failurePolicy.handleRollbackFailure(this.site, this.tx);
            return null;
        }

        @Override
        public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) {
            this.failurePolicy.handleCommitFailure(this.site, this.tx);
            return null;
        }

        @Override
        protected Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
            super.handleDefault(ctx, command);
            throw new IllegalStateException("Unknown command: " + String.valueOf(command));
        }
    }
}

