/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.NodeVersion;
import org.infinispan.remoting.transport.jgroups.AddressCache;
import org.jgroups.util.ExtendedUUID;

public class ClusterView {
    static final int INITIAL_VIEW_ID = -1;
    static final int FINAL_VIEW_ID = Integer.MAX_VALUE;
    private final int viewId;
    private final Map<Address, ExtendedUUID> view;
    private final boolean isCoordinator;
    private final Address coordinator;
    private final NodeVersion oldestMember;
    private final boolean mixedVersionCluster;

    ClusterView(int viewId, List<ExtendedUUID> members, ExtendedUUID self, NodeVersion version) {
        this.viewId = viewId;
        NodeVersion oldestVersion = version;
        boolean mixedVersionCluster = false;
        if (members.isEmpty()) {
            this.view = Map.of();
            this.isCoordinator = false;
            this.coordinator = null;
        } else {
            this.view = new LinkedHashMap<Address, ExtendedUUID>();
            this.isCoordinator = Objects.equals(self, members.get(0));
            this.coordinator = AddressCache.fromExtendedUUID(members.get(0));
            for (ExtendedUUID member : members) {
                Address address = AddressCache.fromExtendedUUID(member);
                this.view.put(address, member);
                NodeVersion v = address.getVersion();
                if (v.equals(version)) continue;
                mixedVersionCluster = true;
                if (!v.lessThan(oldestVersion)) continue;
                oldestVersion = v;
            }
        }
        this.oldestMember = oldestVersion;
        this.mixedVersionCluster = mixedVersionCluster;
    }

    public int getViewId() {
        return this.viewId;
    }

    public boolean isViewIdAtLeast(int expectedViewId) {
        return expectedViewId <= this.viewId;
    }

    public boolean isStopped() {
        return this.viewId == Integer.MAX_VALUE;
    }

    public List<Address> getMembers() {
        return List.copyOf(this.view.keySet());
    }

    public Set<Address> getMembersSet() {
        return Collections.unmodifiableSet(this.view.keySet());
    }

    public Address getCoordinator() {
        return this.coordinator;
    }

    public boolean isCoordinator() {
        return this.isCoordinator;
    }

    public NodeVersion getOldestMember() {
        return this.oldestMember;
    }

    public boolean isMixedVersionCluster() {
        return this.mixedVersionCluster;
    }

    public String toString() {
        return String.valueOf(this.coordinator) + "|" + this.viewId + String.valueOf(this.view.keySet());
    }

    public ExtendedUUID getAddressFromView(Address address) {
        return this.view.get(address);
    }
}

