/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.manager.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.infinispan.manager.ClusterExecutionPolicy;
import org.infinispan.manager.ClusterExecutor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.impl.LocalClusterExecutor;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.util.concurrent.BlockingManager;
import org.infinispan.util.logging.Log;

abstract class AbstractClusterExecutor<T extends ClusterExecutor>
extends LocalClusterExecutor {
    protected final Transport transport;
    protected final Address me;

    AbstractClusterExecutor(Predicate<? super Address> predicate, EmbeddedCacheManager manager, Transport transport, long time, TimeUnit unit, BlockingManager blockingManager, ScheduledExecutorService timeoutExecutor) {
        super(predicate, manager, blockingManager, time, unit, timeoutExecutor);
        this.transport = transport;
        this.me = Objects.requireNonNull(transport.getAddress(), "Transport was not started before retrieving a ClusterExecutor!");
    }

    protected abstract T sameClusterExecutor(Predicate<? super Address> var1, long var2, TimeUnit var4);

    protected abstract Log getLog();

    @Override
    Address getMyAddress() {
        return this.me;
    }

    void consumeResponse(Response resp, Address target, Consumer<? super Throwable> throwableEater) {
        this.consumeResponse(resp, target, o -> {}, throwableEater);
    }

    void consumeResponse(Response resp, Address target, Consumer<Object> resultsEater, Consumer<? super Throwable> throwableEater) {
        if (resp != null) {
            if (resp instanceof ExceptionResponse) {
                Exception exception = ((ExceptionResponse)resp).getException();
                throwableEater.accept(exception);
            } else if (resp instanceof SuccessfulResponse) {
                resultsEater.accept(((SuccessfulResponse)resp).getResponseValue());
            } else if (resp instanceof CacheNotFoundResponse) {
                throwableEater.accept((Throwable)((Object)this.getLog().remoteNodeSuspected(target)));
            } else {
                throwableEater.accept(new IllegalStateException("Response was neither successful or an exception!"));
            }
        } else {
            resultsEater.accept(null);
        }
    }

    List<Address> getRealTargets(boolean includeMe) {
        List<Address> list;
        List<Address> ispnMembers = this.transport.getMembers();
        int size = ispnMembers.size();
        if (size == 0) {
            list = Collections.emptyList();
        } else if (this.predicate == null) {
            if (size == 1) {
                Address member = ispnMembers.get(0);
                list = !includeMe && member.equals(this.me) ? Collections.emptyList() : Collections.singletonList(member);
            } else {
                list = (includeMe ? ispnMembers.stream() : ispnMembers.stream().filter(a -> !a.equals(this.me))).collect(Collectors.toList());
            }
        } else {
            list = (includeMe ? ispnMembers.stream() : ispnMembers.stream().filter(a -> !a.equals(this.me))).filter(this.predicate).collect(Collectors.toList());
        }
        return list;
    }

    public T filterTargets(Predicate<? super Address> predicate) {
        return this.sameClusterExecutor(predicate, this.time, this.unit);
    }

    public T filterTargets(ClusterExecutionPolicy policy) throws IllegalStateException {
        if (!this.manager.getCacheManagerConfiguration().transport().hasTopologyInfo()) {
            throw new IllegalStateException("Topology information is not available!");
        }
        return this.sameClusterExecutor(a -> policy.include(this.me, (Address)a), this.time, this.unit);
    }

    public T filterTargets(ClusterExecutionPolicy policy, Predicate<? super Address> predicate) throws IllegalStateException {
        if (!this.manager.getCacheManagerConfiguration().transport().hasTopologyInfo()) {
            throw new IllegalStateException();
        }
        return this.sameClusterExecutor(a -> policy.include(this.me, (Address)a) && predicate.test((Address)a), this.time, this.unit);
    }

    public T filterTargets(Collection<Address> addresses) {
        return this.filterTargets(addresses::contains);
    }

    public T noFilter() {
        if (this.predicate == null) {
            return (T)this;
        }
        return this.sameClusterExecutor(null, this.time, this.unit);
    }
}

