/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories.impl;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.infinispan.commons.time.TimeService;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.factories.impl.BasicComponentRegistryImpl;
import org.infinispan.factories.impl.ComponentRegistryTracker;
import org.jgroups.util.Util;

final class ComponentRegistryTimeTracker
implements ComponentRegistryTracker {
    private final Map<String, Initialization> components = new ConcurrentHashMap<String, Initialization>(8);
    private final BasicComponentRegistry registry;
    private volatile TimeService timeService;

    ComponentRegistryTimeTracker(BasicComponentRegistry registry, boolean global) {
        this.registry = registry;
        this.timeService = global ? null : registry.getComponent(TimeService.class).wired();
    }

    static ComponentRegistryTracker tracker(BasicComponentRegistry registry, boolean global) {
        return new ComponentRegistryTimeTracker(registry, global);
    }

    private boolean isTimeServiceAvailable() {
        return this.timeService != null;
    }

    @Override
    public void instantiating(String componentName) {
        if (!this.isTimeServiceAvailable()) {
            return;
        }
        Initialization initialization = this.componentInitialization(componentName);
        initialization.instantiating(this.timeService.wallClockTime());
    }

    @Override
    public void instantiated(String componentName) {
        if (!this.isTimeServiceAvailable()) {
            return;
        }
        Initialization initialization = this.componentInitialization(componentName);
        initialization.instantiated(this.timeService.wallClockTime());
    }

    @Override
    public void wiring(String componentName) {
        if (!this.isTimeServiceAvailable()) {
            return;
        }
        Initialization initialization = this.componentInitialization(componentName);
        initialization.wiring(this.timeService.wallClockTime());
    }

    @Override
    public void wired(String componentName) {
        if (!this.isTimeServiceAvailable()) {
            if (componentName.equals(GlobalConfiguration.class.getName())) {
                this.timeService = this.registry.getComponent(TimeService.class).wired();
            }
            return;
        }
        Initialization initialization = this.componentInitialization(componentName);
        initialization.wired(this.timeService.wallClockTime());
    }

    @Override
    public void starting(String componentName) {
        if (!this.isTimeServiceAvailable()) {
            return;
        }
        Initialization initialization = this.componentInitialization(componentName);
        initialization.starting(this.timeService.wallClockTime());
    }

    @Override
    public void started(String componentName) {
        if (!this.isTimeServiceAvailable()) {
            return;
        }
        Initialization initialization = this.componentInitialization(componentName);
        initialization.started(this.timeService.wallClockTime());
    }

    @Override
    public String dump() {
        StringBuilder sb = new StringBuilder();
        List<Initialization> c = this.components.values().stream().sorted(Comparator.reverseOrder()).toList();
        for (Initialization initialization : c) {
            if (!initialization.isValid()) continue;
            sb.append(initialization.name()).append(":").append(System.lineSeparator());
            sb.append(initialization);
            sb.append(System.lineSeparator());
        }
        return sb.toString();
    }

    @Override
    public void clear() {
        this.components.clear();
    }

    @Override
    public void removeComponent(String componentName) {
        this.components.remove(componentName);
    }

    private Initialization componentInitialization(String componentName) {
        return this.components.computeIfAbsent(componentName, Initialization::new);
    }

    private static final class Initialization
    implements Comparable<Initialization> {
        private static final long NOT_INITIALIZED = -1L;
        private final String name;
        private static final AtomicLongFieldUpdater<Initialization> INSTANTIATING = AtomicLongFieldUpdater.newUpdater(Initialization.class, "instantiating");
        private static final AtomicLongFieldUpdater<Initialization> INSTANTIATED = AtomicLongFieldUpdater.newUpdater(Initialization.class, "instantiated");
        private static final AtomicLongFieldUpdater<Initialization> WIRING = AtomicLongFieldUpdater.newUpdater(Initialization.class, "wiring");
        private static final AtomicLongFieldUpdater<Initialization> WIRED = AtomicLongFieldUpdater.newUpdater(Initialization.class, "wired");
        private static final AtomicLongFieldUpdater<Initialization> STARTING = AtomicLongFieldUpdater.newUpdater(Initialization.class, "starting");
        private static final AtomicLongFieldUpdater<Initialization> STARTED = AtomicLongFieldUpdater.newUpdater(Initialization.class, "started");
        private volatile long instantiating = -1L;
        private volatile long instantiated = -1L;
        private volatile long wiring = -1L;
        private volatile long wired = -1L;
        private volatile long starting = -1L;
        private volatile long started = -1L;

        private Initialization(String name) {
            this.name = name;
        }

        public String name() {
            return this.name;
        }

        public boolean isValid() {
            return INSTANTIATING.get(this) != -1L && STARTED.get(this) != -1L;
        }

        public void instantiating(long value) {
            if (!INSTANTIATING.compareAndSet(this, -1L, value)) {
                throw new IllegalStateException("Field already initialized: " + INSTANTIATING.get(this));
            }
        }

        public long instantiatingTime() {
            return this.getInitializedValue(BasicComponentRegistryImpl.WrapperState.INSTANTIATED) - INSTANTIATING.get(this);
        }

        public void instantiated(long value) {
            if (!INSTANTIATED.compareAndSet(this, -1L, value)) {
                throw new IllegalStateException("Field already initialized: " + INSTANTIATED.get(this));
            }
        }

        public long instantiatedTime() {
            return this.getInitializedValue(BasicComponentRegistryImpl.WrapperState.WIRING) - this.getInitializedValue(BasicComponentRegistryImpl.WrapperState.INSTANTIATED);
        }

        public void wiring(long value) {
            if (!WIRING.compareAndSet(this, -1L, value)) {
                throw new IllegalStateException("Field already initialized: " + WIRING.get(this));
            }
        }

        public long wiringTime() {
            return this.getInitializedValue(BasicComponentRegistryImpl.WrapperState.WIRED) - this.getInitializedValue(BasicComponentRegistryImpl.WrapperState.WIRING);
        }

        public void wired(long value) {
            if (!WIRED.compareAndSet(this, -1L, value)) {
                throw new IllegalStateException("Field already initialized: " + WIRED.get(this));
            }
        }

        public long wiredTime() {
            return this.getInitializedValue(BasicComponentRegistryImpl.WrapperState.STARTING) - this.getInitializedValue(BasicComponentRegistryImpl.WrapperState.WIRED);
        }

        public void starting(long value) {
            if (!STARTING.compareAndSet(this, -1L, value)) {
                throw new IllegalStateException("Field already initialized: " + STARTING.get(this));
            }
        }

        public long startingTime() {
            return this.getInitializedValue(BasicComponentRegistryImpl.WrapperState.STARTED) - this.getInitializedValue(BasicComponentRegistryImpl.WrapperState.STARTING);
        }

        public void started(long value) {
            if (!STARTED.compareAndSet(this, -1L, value)) {
                throw new IllegalStateException("Field already initialized: " + STARTED.get(this));
            }
        }

        private long totalTime() {
            return this.getInitializedValue(BasicComponentRegistryImpl.WrapperState.STARTED) - INSTANTIATING.get(this);
        }

        private long getInitializedValue(BasicComponentRegistryImpl.WrapperState state) {
            return switch (state) {
                case BasicComponentRegistryImpl.WrapperState.INSTANTIATING -> INSTANTIATING.get(this);
                case BasicComponentRegistryImpl.WrapperState.INSTANTIATED -> {
                    long value = INSTANTIATED.get(this);
                    if (value == -1L) {
                        yield this.getInitializedValue(BasicComponentRegistryImpl.WrapperState.INSTANTIATING);
                    }
                    yield value;
                }
                case BasicComponentRegistryImpl.WrapperState.WIRING -> {
                    long value = WIRING.get(this);
                    if (value == -1L) {
                        yield this.getInitializedValue(BasicComponentRegistryImpl.WrapperState.INSTANTIATED);
                    }
                    yield value;
                }
                case BasicComponentRegistryImpl.WrapperState.WIRED -> {
                    long value = WIRED.get(this);
                    if (value == -1L) {
                        yield this.getInitializedValue(BasicComponentRegistryImpl.WrapperState.WIRING);
                    }
                    yield value;
                }
                case BasicComponentRegistryImpl.WrapperState.STARTING -> {
                    long value = STARTING.get(this);
                    if (value == -1L) {
                        yield this.getInitializedValue(BasicComponentRegistryImpl.WrapperState.WIRED);
                    }
                    yield value;
                }
                case BasicComponentRegistryImpl.WrapperState.STARTED -> {
                    long value = STARTED.get(this);
                    if (value == -1L) {
                        yield this.getInitializedValue(BasicComponentRegistryImpl.WrapperState.STARTING);
                    }
                    yield value;
                }
                default -> -1L;
            };
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.append(sb, "\t-> instantiating", this.instantiatingTime());
            this.append(sb, "\t->  instantiated", this.instantiatedTime());
            this.append(sb, "\t->        wiring", this.wiringTime());
            this.append(sb, "\t->         wired", this.wiredTime());
            this.append(sb, "\t->      starting", this.startingTime());
            sb.append('\t').append("->         total: ").append(Util.printTime((double)this.totalTime(), (TimeUnit)TimeUnit.MILLISECONDS));
            return sb.toString();
        }

        private void append(StringBuilder sb, String field, long value) {
            if (value > 0L) {
                sb.append(field).append(": ").append(Util.printTime((double)value, (TimeUnit)TimeUnit.MILLISECONDS)).append(System.lineSeparator());
            }
        }

        @Override
        public int compareTo(Initialization initialization) {
            int time = Long.compare(this.totalTime(), initialization.totalTime());
            return time == 0 ? this.name.compareTo(initialization.name()) : time;
        }
    }
}

