/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import org.infinispan.container.entries.ExpiryHelper;
import org.infinispan.container.entries.ImmortalCacheValue;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.TransientCacheEntry;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.metadata.impl.PrivateMetadata;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=1240)
public class TransientCacheValue
extends ImmortalCacheValue {
    protected long maxIdle;
    protected long lastUsed;

    public TransientCacheValue(Object value, long maxIdle, long lastUsed) {
        this(value, null, maxIdle, lastUsed);
    }

    protected TransientCacheValue(Object value, PrivateMetadata internalMetadata, long maxIdle, long lastUsed) {
        super(value, internalMetadata);
        this.maxIdle = maxIdle;
        this.lastUsed = lastUsed;
    }

    @ProtoFactory
    TransientCacheValue(MarshallableObject<?> wrappedValue, PrivateMetadata internalMetadata, long maxIdle, long lastUsed) {
        super(wrappedValue, internalMetadata);
        this.maxIdle = maxIdle;
        this.lastUsed = lastUsed;
    }

    @Override
    @ProtoField(value=3)
    public long getMaxIdle() {
        return this.maxIdle;
    }

    public void setMaxIdle(long maxIdle) {
        this.maxIdle = maxIdle;
    }

    @Override
    @ProtoField(value=4)
    public long getLastUsed() {
        return this.lastUsed;
    }

    public void setLastUsed(long lastUsed) {
        this.lastUsed = lastUsed;
    }

    @Override
    public final boolean isExpired(long now) {
        return ExpiryHelper.isExpiredTransient(this.maxIdle, this.lastUsed, now);
    }

    @Override
    public boolean canExpire() {
        return true;
    }

    @Override
    public boolean isMaxIdleExpirable() {
        return true;
    }

    @Override
    public InternalCacheEntry<?, ?> toInternalCacheEntry(Object key) {
        return new TransientCacheEntry(key, this.value, this.internalMetadata, this.maxIdle, this.lastUsed);
    }

    @Override
    public long getExpiryTime() {
        return this.maxIdle > -1L ? this.lastUsed + this.maxIdle : -1L;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TransientCacheValue)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TransientCacheValue that = (TransientCacheValue)o;
        return this.lastUsed == that.lastUsed && this.maxIdle == that.maxIdle;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (int)(this.maxIdle ^ this.maxIdle >>> 32);
        result = 31 * result + (int)(this.lastUsed ^ this.lastUsed >>> 32);
        return result;
    }

    @Override
    public TransientCacheValue clone() {
        return (TransientCacheValue)super.clone();
    }

    @Override
    protected void appendFieldsToString(StringBuilder builder) {
        super.appendFieldsToString(builder);
        builder.append(", maxIdle=").append(this.maxIdle);
        builder.append(", lastUsed=").append(this.lastUsed);
    }
}

