/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.topology;

import java.util.concurrent.CompletionStage;
import org.infinispan.commands.topology.AbstractCacheControlCommand;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.NodeVersion;
import org.infinispan.topology.CacheJoinInfo;

@ProtoTypeId(value=1040)
public class CacheJoinCommand
extends AbstractCacheControlCommand {
    @ProtoField(value=1)
    final String cacheName;
    @ProtoField(value=2)
    final CacheJoinInfo joinInfo;
    @ProtoField(value=3)
    final int viewId;

    @ProtoFactory
    CacheJoinCommand(String cacheName, CacheJoinInfo joinInfo, int viewId) {
        this(cacheName, null, joinInfo, viewId);
    }

    public CacheJoinCommand(String cacheName, Address origin, CacheJoinInfo joinInfo, int viewId) {
        super(origin);
        this.cacheName = cacheName;
        this.joinInfo = joinInfo;
        this.viewId = viewId;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    @Override
    public CompletionStage<?> invokeAsync(GlobalComponentRegistry gcr) throws Throwable {
        return gcr.getClusterTopologyManager().handleJoin(this.cacheName, this.origin, this.joinInfo, this.viewId);
    }

    @Override
    public NodeVersion supportedSince() {
        return NodeVersion.SIXTEEN;
    }

    public String toString() {
        return "TopologyJoinCommand{cacheName='" + this.cacheName + "', origin=" + String.valueOf(this.origin) + ", joinInfo=" + String.valueOf(this.joinInfo) + ", viewId=" + this.viewId + "}";
    }
}

