/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.remote;

import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.context.Flag;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.util.ByteString;

public abstract class BaseClusteredReadCommand
extends BaseRpcCommand
implements TopologyAffectedCommand {
    protected int topologyId;
    protected long flags;

    protected BaseClusteredReadCommand(ByteString cacheName, int topologyId, long flagBitSet) {
        super(cacheName);
        this.topologyId = topologyId;
        this.flags = flagBitSet;
    }

    public long getFlagsBitSet() {
        return this.flags;
    }

    public void setFlagsBitSet(long bitSet) {
        this.flags = bitSet;
    }

    protected final String printFlags() {
        return EnumUtil.prettyPrintBitSet((long)this.flags, Flag.class);
    }

    public boolean hasAnyFlag(long flagBitSet) {
        return EnumUtil.containsAny((long)this.getFlagsBitSet(), (long)flagBitSet);
    }

    @Override
    @ProtoField(value=2)
    public int getTopologyId() {
        return this.topologyId;
    }

    @Override
    public void setTopologyId(int topologyId) {
        this.topologyId = topologyId;
    }

    @ProtoField(number=3, name="flags")
    long getFlagsWithoutRemote() {
        return FlagBitSets.copyWithoutRemotableFlags(this.flags);
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }
}

