/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.functional;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.functional.FunctionalCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.encoding.DataConversion;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.functional.impl.Params;
import org.infinispan.marshall.protostream.impl.MarshallableMap;
import org.infinispan.metadata.impl.PrivateMetadata;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.locks.RemoteLockCommand;

public abstract class AbstractWriteManyCommand<K, V>
implements CacheRpcCommand,
WriteCommand,
FunctionalCommand<K, V>,
RemoteLockCommand {
    @ProtoField(value=1)
    ByteString cacheName;
    @ProtoField(value=2)
    final CommandInvocationId commandInvocationId;
    @ProtoField(value=3)
    boolean forwarded = false;
    @ProtoField(value=4)
    int topologyId = -1;
    @ProtoField(value=5)
    Params params;
    @ProtoField(value=6)
    long flags;
    @ProtoField(value=7)
    DataConversion keyDataConversion;
    @ProtoField(value=8)
    DataConversion valueDataConversion;
    Map<Object, PrivateMetadata> internalMetadataMap;
    Address origin;

    @ProtoField(value=9)
    MarshallableMap<Object, PrivateMetadata> getInternalMetadata() {
        return MarshallableMap.create(this.internalMetadataMap);
    }

    protected AbstractWriteManyCommand(ByteString cacheName, CommandInvocationId commandInvocationId, boolean forwarded, int topologyId, Params params, long flags, DataConversion keyDataConversion, DataConversion valueDataConversion, MarshallableMap<Object, PrivateMetadata> internalMetadataMap) {
        this(cacheName, commandInvocationId, forwarded, topologyId, params, flags, keyDataConversion, valueDataConversion, MarshallableMap.unwrap(internalMetadataMap));
    }

    private AbstractWriteManyCommand(ByteString cacheName, CommandInvocationId commandInvocationId, boolean forwarded, int topologyId, Params params, long flags, DataConversion keyDataConversion, DataConversion valueDataConversion, Map<Object, PrivateMetadata> internalMetadataMap) {
        this.cacheName = cacheName;
        this.commandInvocationId = commandInvocationId;
        this.forwarded = forwarded;
        this.topologyId = topologyId;
        this.params = params;
        this.flags = flags;
        this.keyDataConversion = keyDataConversion;
        this.valueDataConversion = valueDataConversion;
        this.internalMetadataMap = internalMetadataMap;
    }

    protected AbstractWriteManyCommand(ByteString cacheName, CommandInvocationId commandInvocationId, Params params, DataConversion keyDataConversion, DataConversion valueDataConversion) {
        this(cacheName, commandInvocationId, false, -1, params, params.toFlagsBitSet(), keyDataConversion, valueDataConversion, new ConcurrentHashMap<Object, PrivateMetadata>());
    }

    protected AbstractWriteManyCommand(AbstractWriteManyCommand<K, V> c) {
        this(c.cacheName, c.commandInvocationId, false, c.topologyId, c.params, c.flags, c.keyDataConversion, c.valueDataConversion, new ConcurrentHashMap<Object, PrivateMetadata>(c.internalMetadataMap));
    }

    @Override
    public void init(ComponentRegistry componentRegistry) {
        componentRegistry.wireDependencies(this.keyDataConversion);
        componentRegistry.wireDependencies(this.valueDataConversion);
    }

    @Override
    public ByteString getCacheName() {
        return this.cacheName;
    }

    @Override
    public Address getOrigin() {
        return this.origin;
    }

    @Override
    public void setOrigin(Address origin) {
        this.origin = origin;
    }

    @Override
    public int getTopologyId() {
        return this.topologyId;
    }

    @Override
    public void setTopologyId(int topologyId) {
        this.topologyId = topologyId;
    }

    public boolean isForwarded() {
        return this.forwarded;
    }

    public void setForwarded(boolean forwarded) {
        this.forwarded = forwarded;
    }

    @Override
    public ValueMatcher getValueMatcher() {
        return ValueMatcher.MATCH_ALWAYS;
    }

    @Override
    public void setValueMatcher(ValueMatcher valueMatcher) {
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public boolean isSuccessful() {
        return true;
    }

    @Override
    public boolean isConditional() {
        return false;
    }

    @Override
    public void fail() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getFlagsBitSet() {
        return this.flags;
    }

    @Override
    public void setFlagsBitSet(long bitSet) {
        this.flags = bitSet;
    }

    @Override
    public Params getParams() {
        return this.params;
    }

    public void setParams(Params params) {
        this.params = params;
    }

    @Override
    public Object getKeyLockOwner() {
        return this.commandInvocationId;
    }

    @Override
    public CommandInvocationId getCommandInvocationId() {
        return this.commandInvocationId;
    }

    @Override
    public boolean hasZeroLockAcquisition() {
        return this.hasAnyFlag(FlagBitSets.ZERO_LOCK_ACQUISITION_TIMEOUT);
    }

    @Override
    public boolean hasSkipLocking() {
        return this.hasAnyFlag(FlagBitSets.SKIP_LOCKING);
    }

    @Override
    public DataConversion getKeyDataConversion() {
        return this.keyDataConversion;
    }

    @Override
    public DataConversion getValueDataConversion() {
        return this.valueDataConversion;
    }

    @Override
    public PrivateMetadata getInternalMetadata(Object key) {
        return this.internalMetadataMap.get(key);
    }

    @Override
    public void setInternalMetadata(Object key, PrivateMetadata internalMetadata) {
        this.internalMetadataMap.put(key, internalMetadata);
    }
}

