/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.impl;

import jakarta.transaction.Synchronization;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import jakarta.transaction.TransactionSynchronizationRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.jcip.annotations.GuardedBy;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commands.remote.CheckTransactionRpcCommand;
import org.infinispan.commands.remote.recovery.TxCompletionNotificationCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.ByRef;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachelistener.annotation.TopologyChanged;
import org.infinispan.notifications.cachelistener.annotation.TransactionRegistered;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.partitionhandling.impl.PartitionHandlingManager;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.transaction.impl.RemoteTransaction;
import org.infinispan.transaction.impl.TransactionCoordinator;
import org.infinispan.transaction.impl.TransactionOriginatorChecker;
import org.infinispan.transaction.synchronization.SyncLocalTransaction;
import org.infinispan.transaction.synchronization.SynchronizationAdapter;
import org.infinispan.transaction.xa.CacheTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.TransactionFactory;
import org.infinispan.util.ByteString;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Listener
@Scope(value=Scopes.NAMED_CACHE)
public class TransactionTable
implements org.infinispan.transaction.TransactionTable {
    private static final Log log = LogFactory.getLog(TransactionTable.class);
    public static final int CACHE_STOPPED_TOPOLOGY_ID = -1;
    @ComponentName(value="cacheName")
    @Inject
    String cacheName;
    @Inject
    protected Configuration configuration;
    @Inject
    protected TransactionCoordinator txCoordinator;
    @Inject
    TransactionFactory txFactory;
    @Inject
    protected RpcManager rpcManager;
    @Inject
    protected CommandsFactory commandsFactory;
    @Inject
    ClusteringDependentLogic clusteringLogic;
    @Inject
    CacheNotifier<?, ?> notifier;
    @Inject
    TransactionSynchronizationRegistry transactionSynchronizationRegistry;
    @Inject
    TimeService timeService;
    @Inject
    CacheManagerNotifier cacheManagerNotifier;
    @Inject
    protected PartitionHandlingManager partitionHandlingManager;
    @Inject
    @ComponentName(value="org.infinispan.executors.timeout")
    ScheduledExecutorService timeoutExecutor;
    @Inject
    protected TransactionOriginatorChecker transactionOriginatorChecker;
    @Inject
    TransactionManager transactionManager;
    @Inject
    ComponentRegistry componentRegistry;
    private volatile int minTxTopologyId = -1;
    private volatile int currentTopologyId = -1;
    private CompletedTransactionsInfo completedTransactionsInfo;
    private boolean isPessimisticLocking;
    private ConcurrentMap<Transaction, LocalTransaction> localTransactions;
    private ConcurrentMap<GlobalTransaction, LocalTransaction> globalToLocalTransactions;
    private ConcurrentMap<GlobalTransaction, RemoteTransaction> remoteTransactions;
    private Lock minTopologyRecalculationLock;
    protected boolean clustered = false;
    protected volatile boolean running = false;

    @Start
    public void start() {
        this.clustered = this.configuration.clustering().cacheMode().isClustered();
        this.isPessimisticLocking = this.configuration.transaction().lockingMode() == LockingMode.PESSIMISTIC;
        int concurrencyLevel = this.configuration.locking().concurrencyLevel();
        this.localTransactions = new ConcurrentHashMap<Transaction, LocalTransaction>(concurrencyLevel, 0.75f, concurrencyLevel);
        this.globalToLocalTransactions = new ConcurrentHashMap<GlobalTransaction, LocalTransaction>(concurrencyLevel, 0.75f, concurrencyLevel);
        boolean transactional = this.configuration.transaction().transactionMode().isTransactional();
        if (this.clustered && transactional) {
            this.minTopologyRecalculationLock = new ReentrantLock();
            this.remoteTransactions = new ConcurrentHashMap<GlobalTransaction, RemoteTransaction>(concurrencyLevel, 0.75f, concurrencyLevel);
            this.notifier.addListener(this);
            this.cacheManagerNotifier.addListener(this);
            this.completedTransactionsInfo = new CompletedTransactionsInfo();
            long interval = this.configuration.transaction().reaperWakeUpInterval();
            this.timeoutExecutor.scheduleAtFixedRate(() -> this.completedTransactionsInfo.cleanupCompletedTransactions(), interval, interval, TimeUnit.MILLISECONDS);
            this.timeoutExecutor.scheduleAtFixedRate(this::cleanupTimedOutTransactions, interval, interval, TimeUnit.MILLISECONDS);
        }
        this.running = true;
    }

    @Override
    public GlobalTransaction getGlobalTransaction(Transaction transaction) {
        if (transaction == null) {
            throw new NullPointerException("Transaction must not be null.");
        }
        LocalTransaction localTransaction = (LocalTransaction)this.localTransactions.get(transaction);
        return localTransaction != null ? localTransaction.getGlobalTransaction() : null;
    }

    @Override
    public Collection<GlobalTransaction> getLocalGlobalTransaction() {
        return Collections.unmodifiableCollection(this.globalToLocalTransactions.keySet());
    }

    @Override
    public Collection<GlobalTransaction> getRemoteGlobalTransaction() {
        return Collections.unmodifiableCollection(this.remoteTransactions.keySet());
    }

    @Stop
    void stop() {
        this.running = false;
        this.cacheManagerNotifier.removeListener(this);
        if (this.clustered) {
            this.notifier.removeListener(this);
            this.currentTopologyId = -1;
        }
        this.shutDownGracefully();
    }

    public void remoteTransactionPrepared(GlobalTransaction gtx) {
    }

    public void localTransactionPrepared(LocalTransaction localTransaction) {
    }

    public void enlist(Transaction transaction, LocalTransaction localTransaction) {
        if (!localTransaction.isEnlisted()) {
            SynchronizationAdapter sync = new SynchronizationAdapter(localTransaction, this);
            if (this.transactionSynchronizationRegistry != null) {
                boolean needsSuspend = false;
                try {
                    Transaction currentTransaction = this.transactionManager.getTransaction();
                    if (currentTransaction == null) {
                        this.transactionManager.resume(transaction);
                        needsSuspend = true;
                    } else assert (currentTransaction == transaction);
                    this.transactionSynchronizationRegistry.registerInterposedSynchronization((Synchronization)sync);
                }
                catch (Exception e) {
                    log.failedSynchronizationRegistration(e);
                    throw new CacheException((Throwable)e);
                }
                finally {
                    if (needsSuspend) {
                        try {
                            this.transactionManager.suspend();
                        }
                        catch (Exception e) {
                            throw new CacheException((Throwable)e);
                        }
                    }
                }
            }
            try {
                transaction.registerSynchronization((Synchronization)sync);
            }
            catch (Exception e) {
                log.failedSynchronizationRegistration(e);
                throw new CacheException((Throwable)e);
            }
            ((SyncLocalTransaction)localTransaction).setEnlisted(true);
        }
    }

    public void enlistClientTransaction(Transaction transaction, LocalTransaction localTransaction) {
        if (!localTransaction.isEnlisted()) {
            SynchronizationAdapter sync = new SynchronizationAdapter(localTransaction, this);
            try {
                transaction.registerSynchronization((Synchronization)sync);
            }
            catch (Exception e) {
                log.failedSynchronizationRegistration(e);
                throw new CacheException((Throwable)e);
            }
            ((SyncLocalTransaction)localTransaction).setEnlisted(true);
        }
    }

    public void failureCompletingTransaction(Transaction tx) {
        LocalTransaction localTransaction = (LocalTransaction)this.localTransactions.get(tx);
        if (localTransaction != null) {
            this.removeLocalTransaction(localTransaction);
        }
    }

    public int getMinTopologyId() {
        return this.minTxTopologyId;
    }

    public void cleanupLeaverTransactions(List<Address> members) {
        if (this.remoteTransactions == null) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.tracef("Checking for transactions originated on leavers. Current cache members are %s, remote transactions: %d", members, this.remoteTransactions.size());
        }
        HashSet<Address> membersSet = new HashSet<Address>(members);
        ArrayList<GlobalTransaction> toKill = new ArrayList<GlobalTransaction>();
        for (Map.Entry e : this.remoteTransactions.entrySet()) {
            GlobalTransaction gt = (GlobalTransaction)e.getKey();
            if (log.isTraceEnabled()) {
                log.tracef("Checking transaction %s", gt);
            }
            if (!this.transactionOriginatorChecker.isOriginatorMissing(gt, membersSet)) continue;
            toKill.add(gt);
        }
        if (toKill.isEmpty()) {
            if (log.isTraceEnabled()) {
                log.tracef("No remote transactions pertain to originator(s) who have left the cluster.", new Object[0]);
            }
        } else {
            log.debugf("The originating node left the cluster for %d remote transactions", toKill.size());
            for (GlobalTransaction gtx : toKill) {
                if (this.partitionHandlingManager.canRollbackTransactionAfterOriginatorLeave(gtx)) {
                    log.debugf("Rolling back transaction %s because originator %s left the cluster", gtx, gtx.getAddress());
                    this.killTransactionAsync(gtx);
                    continue;
                }
                log.debugf("Keeping transaction %s after the originator %s left the cluster.", gtx, gtx.getAddress());
            }
            if (log.isTraceEnabled()) {
                log.tracef("Completed cleaning transactions originating on leavers. Remote transactions remaining: %d", this.remoteTransactions.size());
            }
        }
    }

    public void remoteTransactionCommitted(GlobalTransaction gtx, boolean onePc) {
        boolean optimisticWih1Pc;
        boolean bl = optimisticWih1Pc = onePc && this.configuration.transaction().lockingMode() == LockingMode.OPTIMISTIC;
        if (optimisticWih1Pc) {
            this.removeRemoteTransaction(gtx);
        }
    }

    @ViewChanged
    public void onViewChange(ViewChangedEvent e) {
        this.timeoutExecutor.submit(() -> this.cleanupLeaverTransactions(e.getNewMembers()));
    }

    private void cleanupTimedOutTransactions() {
        if (log.isTraceEnabled()) {
            log.tracef("About to cleanup remote transactions older than %d ms", this.configuration.transaction().completedTxTimeout());
        }
        long beginning = this.timeService.time();
        long cutoffCreationTime = beginning - TimeUnit.MILLISECONDS.toNanos(this.configuration.transaction().completedTxTimeout());
        ArrayList<GlobalTransaction> toKill = new ArrayList<GlobalTransaction>();
        HashMap<Address, Collection> toCheck = new HashMap<Address, Collection>();
        for (Map.Entry e : this.remoteTransactions.entrySet()) {
            long creationTime;
            GlobalTransaction gtx = (GlobalTransaction)e.getKey();
            RemoteTransaction remoteTx = (RemoteTransaction)e.getValue();
            assert (remoteTx != null);
            if (log.isTraceEnabled()) {
                log.tracef("Checking transaction %s", gtx);
            }
            if ((creationTime = remoteTx.getCreationTime()) - cutoffCreationTime >= 0L) continue;
            if (this.transactionOriginatorChecker.isOriginatorMissing(gtx)) {
                long duration = this.timeService.timeDuration(creationTime, beginning, TimeUnit.MILLISECONDS);
                log.remoteTransactionTimeout(gtx, duration);
                toKill.add(gtx);
                continue;
            }
            Address orig = gtx.getAddress();
            if (!this.rpcManager.getMembers().contains(orig)) continue;
            Collection addressCheckList = toCheck.computeIfAbsent(orig, k -> new ArrayList());
            addressCheckList.add(gtx);
        }
        for (Map.Entry entry : toCheck.entrySet()) {
            CheckTransactionRpcCommand cmd = this.commandsFactory.buildCheckTransactionRpcCommand((Collection)entry.getValue());
            RpcOptions rpcOptions = this.rpcManager.getSyncRpcOptions();
            this.rpcManager.invokeCommand((Address)entry.getKey(), (CacheRpcCommand)cmd, CheckTransactionRpcCommand.responseCollector(), rpcOptions).thenAccept(this::killAllTransactionsAsync);
        }
        this.killAllTransactionsAsync(toKill);
    }

    private void killTransaction(GlobalTransaction gtx) {
        RollbackCommand rc = new RollbackCommand(ByteString.fromString(this.cacheName), gtx);
        rc.markTransactionAsRemote(false);
        try {
            CompletionStages.join(rc.invokeAsync(this.componentRegistry));
            if (log.isTraceEnabled()) {
                log.tracef("Rollback of transaction %s complete.", gtx);
            }
        }
        catch (Throwable e) {
            log.unableToRollbackGlobalTx(gtx, e);
        }
    }

    public RemoteTransaction getRemoteTransaction(GlobalTransaction txId) {
        return (RemoteTransaction)this.remoteTransactions.get(txId);
    }

    public void remoteTransactionRollback(GlobalTransaction gtx) {
        RemoteTransaction remove = this.removeRemoteTransaction(gtx);
        if (log.isTraceEnabled()) {
            log.tracef("Removed local transaction %s? %b", gtx, remove);
        }
    }

    public RemoteTransaction getOrCreateRemoteTransaction(GlobalTransaction globalTx, List<WriteCommand> modifications) {
        return this.getOrCreateRemoteTransaction(globalTx, modifications, this.currentTopologyId);
    }

    public RemoteTransaction getOrCreateRemoteTransaction(GlobalTransaction globalTx, List<WriteCommand> modifications, int topologyId) {
        RemoteTransaction existingTransaction = (RemoteTransaction)this.remoteTransactions.get(globalTx);
        if (existingTransaction != null) {
            return existingTransaction;
        }
        if (!this.running) {
            throw Log.CONTAINER.cacheIsStopping(this.cacheName);
        }
        int viewId = this.rpcManager.getTransport().getViewId();
        if (this.transactionOriginatorChecker.isOriginatorMissing(globalTx, this.rpcManager.getTransport().getMembers())) {
            throw Log.CLUSTER.remoteTransactionOriginatorNotInView(globalTx);
        }
        RemoteTransaction newTransaction = this.txFactory.newRemoteTransaction(modifications, globalTx, topologyId);
        RemoteTransaction remoteTransaction = this.remoteTransactions.compute(globalTx, (gtx, existing) -> {
            if (existing != null) {
                if (log.isTraceEnabled()) {
                    log.tracef("Remote transaction already registered: %s", existing);
                }
                return existing;
            }
            if (this.isTransactionCompleted((GlobalTransaction)gtx)) {
                throw Log.CLUSTER.remoteTransactionAlreadyCompleted((GlobalTransaction)gtx);
            }
            if (log.isTraceEnabled()) {
                log.tracef("Created and registered remote transaction %s", newTransaction);
            }
            if (topologyId < this.minTxTopologyId) {
                if (log.isTraceEnabled()) {
                    log.tracef("Changing minimum topology ID from %d to %d", this.minTxTopologyId, topologyId);
                }
                this.minTxTopologyId = topologyId;
            }
            return newTransaction;
        });
        if (this.rpcManager.getTransport().getViewId() != viewId && this.transactionOriginatorChecker.isOriginatorMissing(globalTx, this.rpcManager.getTransport().getMembers())) {
            if (this.partitionHandlingManager.canRollbackTransactionAfterOriginatorLeave(globalTx)) {
                log.debugf("Rolling back transaction %s because originator %s left the cluster", globalTx, globalTx.getAddress());
                this.killTransaction(globalTx);
            }
            return remoteTransaction;
        }
        return remoteTransaction;
    }

    public LocalTransaction getOrCreateLocalTransaction(Transaction transaction, boolean implicitTransaction) {
        return this.getOrCreateLocalTransaction(transaction, implicitTransaction, this::newGlobalTransaction);
    }

    public LocalTransaction getOrCreateLocalTransaction(Transaction transaction, boolean implicitTransaction, Supplier<GlobalTransaction> gtxFactory) {
        LocalTransaction current = (LocalTransaction)this.localTransactions.get(transaction);
        if (current == null) {
            if (!this.running) {
                throw Log.CONTAINER.cacheIsStopping(this.cacheName);
            }
            GlobalTransaction tx = gtxFactory.get();
            current = this.txFactory.newLocalTransaction(transaction, tx, implicitTransaction, this.currentTopologyId);
            if (log.isTraceEnabled()) {
                log.tracef("Created a new local transaction: %s", current);
            }
            this.localTransactions.put(transaction, current);
            this.globalToLocalTransactions.put(current.getGlobalTransaction(), current);
            if (this.notifier.hasListener(TransactionRegistered.class)) {
                CompletionStages.join(this.notifier.notifyTransactionRegistered(tx, true));
            }
        }
        return current;
    }

    public boolean removeLocalTransaction(LocalTransaction localTransaction) {
        return localTransaction != null && this.removeLocalTransactionInternal(localTransaction.getTransaction()) != null;
    }

    private GlobalTransaction newGlobalTransaction() {
        Address localAddress = this.rpcManager != null ? this.rpcManager.getTransport().getAddress() : null;
        return this.txFactory.newGlobalTransaction(localAddress, false);
    }

    private LocalTransaction removeLocalTransactionInternal(Transaction tx) {
        LocalTransaction localTx = (LocalTransaction)this.localTransactions.get(tx);
        if (localTx != null) {
            this.globalToLocalTransactions.remove(localTx.getGlobalTransaction());
            this.localTransactions.remove(tx);
            this.releaseResources(localTx);
        }
        return localTx;
    }

    private void releaseResources(CacheTransaction cacheTransaction) {
        if (cacheTransaction != null) {
            if (this.clustered) {
                this.recalculateMinTopologyIdIfNeeded(cacheTransaction);
            }
            if (log.isTraceEnabled()) {
                log.tracef("Removed %s from transaction table.", cacheTransaction);
            }
            cacheTransaction.notifyOnTransactionFinished();
        }
    }

    private void killAllTransactionsAsync(Collection<GlobalTransaction> transactions) {
        for (GlobalTransaction gtx : transactions) {
            this.killTransactionAsync(gtx);
        }
    }

    public final RemoteTransaction removeRemoteTransaction(GlobalTransaction txId) {
        ByRef removed = new ByRef(null);
        this.remoteTransactions.compute(txId, (gtx, remoteTx) -> {
            boolean successful = remoteTx != null && !remoteTx.isMarkedForRollback();
            this.markTransactionCompleted((GlobalTransaction)gtx, successful);
            removed.set(remoteTx);
            return null;
        });
        if (log.isTraceEnabled()) {
            log.tracef("Removed remote transaction %s ? %s", txId, removed.get());
        }
        this.releaseResources((CacheTransaction)removed.get());
        return (RemoteTransaction)removed.get();
    }

    public int getRemoteTxCount() {
        return this.remoteTransactions.size();
    }

    public int getLocalTxCount() {
        return this.localTransactions.size();
    }

    public LocalTransaction getLocalTransaction(GlobalTransaction txId) {
        return (LocalTransaction)this.globalToLocalTransactions.get(txId);
    }

    public boolean containsLocalTx(GlobalTransaction globalTransaction) {
        return this.globalToLocalTransactions.containsKey(globalTransaction);
    }

    public LocalTransaction getLocalTransaction(Transaction tx) {
        return (LocalTransaction)this.localTransactions.get(tx);
    }

    public boolean containRemoteTx(GlobalTransaction globalTransaction) {
        return this.remoteTransactions.containsKey(globalTransaction);
    }

    public Collection<RemoteTransaction> getRemoteTransactions() {
        return this.remoteTransactions.values();
    }

    public Collection<LocalTransaction> getLocalTransactions() {
        return this.localTransactions.values();
    }

    protected final void recalculateMinTopologyIdIfNeeded(CacheTransaction removedTransaction) {
        if (removedTransaction == null) {
            throw new IllegalArgumentException("Transaction cannot be null!");
        }
        if (this.currentTopologyId != -1) {
            int removedTransactionTopologyId = removedTransaction.getTopologyId();
            if (removedTransactionTopologyId < this.minTxTopologyId) {
                if (log.isTraceEnabled()) {
                    log.tracef("A transaction has a topology ID (%s) that is smaller than the smallest transaction topology ID (%s) this node knows about!  This can happen if a concurrent thread recalculates the minimum topology ID after the current transaction has been removed from the transaction table.", removedTransactionTopologyId, this.minTxTopologyId);
                }
            } else if (removedTransactionTopologyId == this.minTxTopologyId && removedTransactionTopologyId < this.currentTopologyId) {
                this.calculateMinTopologyId(removedTransactionTopologyId);
            }
        }
    }

    @TopologyChanged
    public void onTopologyChange(TopologyChangedEvent<?, ?> tce) {
        if (this.clustered && !tce.isPre()) {
            this.currentTopologyId = tce.getNewTopologyId();
            log.debugf("Topology changed, recalculating minimum topology id", new Object[0]);
            this.calculateMinTopologyId(-1);
        }
    }

    private void killTransactionAsync(GlobalTransaction gtx) {
        RollbackCommand rc = new RollbackCommand(ByteString.fromString(this.cacheName), gtx);
        rc.markTransactionAsRemote(false);
        try {
            rc.invokeAsync(this.componentRegistry);
        }
        catch (Throwable throwable) {
            log.unableToRollbackGlobalTx(gtx, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="minTopologyRecalculationLock")
    private void calculateMinTopologyId(int idOfRemovedTransaction) {
        this.minTopologyRecalculationLock.lock();
        try {
            if (idOfRemovedTransaction == -1 || idOfRemovedTransaction == this.minTxTopologyId && idOfRemovedTransaction < this.currentTopologyId) {
                int topologyId;
                int minTopologyIdFound = this.currentTopologyId;
                for (CacheTransaction ct : this.localTransactions.values()) {
                    topologyId = ct.getTopologyId();
                    if (topologyId >= minTopologyIdFound) continue;
                    minTopologyIdFound = topologyId;
                }
                for (CacheTransaction ct : this.remoteTransactions.values()) {
                    topologyId = ct.getTopologyId();
                    if (topologyId >= minTopologyIdFound) continue;
                    minTopologyIdFound = topologyId;
                }
                if (minTopologyIdFound != this.minTxTopologyId) {
                    if (log.isTraceEnabled()) {
                        log.tracef("Changing minimum topology ID from %s to %s", this.minTxTopologyId, minTopologyIdFound);
                    }
                    this.minTxTopologyId = minTopologyIdFound;
                } else if (log.isTraceEnabled()) {
                    log.tracef("Minimum topology ID still is %s; nothing to change", minTopologyIdFound);
                }
            }
        }
        finally {
            this.minTopologyRecalculationLock.unlock();
        }
    }

    private void shutDownGracefully() {
        boolean localTxsOnGoing;
        if (log.isDebugEnabled()) {
            log.debugf("Wait for on-going transactions to finish for %s.", Util.prettyPrintTime((long)this.configuration.transaction().cacheStopTimeout(), (TimeUnit)TimeUnit.MILLISECONDS));
        }
        long now = System.nanoTime();
        long failTime = now + TimeUnit.MILLISECONDS.toNanos(this.configuration.transaction().cacheStopTimeout());
        boolean bl = localTxsOnGoing = !this.localTransactions.isEmpty();
        while (localTxsOnGoing && System.nanoTime() - failTime < 0L) {
            try {
                Thread.sleep(30L);
                localTxsOnGoing = !this.localTransactions.isEmpty();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.debugf("Interrupted waiting for %d on-going local transactions to finish.", this.localTransactions.size());
            }
        }
        if (this.remoteTransactions != null) {
            Future<?> remoteTxsFuture = this.timeoutExecutor.submit(() -> {
                Iterator i$ = this.remoteTransactions.values().iterator();
                while (i$.hasNext()) {
                    RemoteTransaction tx;
                    RemoteTransaction remoteTransaction = tx = (RemoteTransaction)i$.next();
                    synchronized (remoteTransaction) {
                        tx.markForRollback(true);
                    }
                    if (!Thread.currentThread().isInterrupted()) continue;
                    break;
                }
            });
            try {
                remoteTxsFuture.get(failTime - System.nanoTime(), TimeUnit.NANOSECONDS);
            }
            catch (InterruptedException e) {
                log.debug("Interrupted waiting for on-going remote transactional commands to finish.");
                remoteTxsFuture.cancel(true);
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                log.debug("Exception while waiting for on-going remote transactional commands to finish", e);
            }
            catch (TimeoutException e) {
                remoteTxsFuture.cancel(true);
            }
        }
        if (!this.localTransactions.isEmpty() || this.remoteTransactionsCount() != 0) {
            log.unfinishedTransactionsRemain(this.localTransactions.size(), this.remoteTransactionsCount());
            if (log.isTraceEnabled()) {
                log.tracef("Unfinished local transactions: %s", this.localTransactions.values().stream().map(tx -> tx.getGlobalTransaction().toString()).collect(Collectors.joining(", ", "[", "]")));
                log.tracef("Unfinished remote transactions: %s", this.remoteTransactions == null ? "none" : this.remoteTransactions.keySet());
            }
        } else {
            log.debug("All transactions terminated");
        }
    }

    private int remoteTransactionsCount() {
        return this.remoteTransactions == null ? 0 : this.remoteTransactions.size();
    }

    public void markTransactionCompleted(GlobalTransaction gtx, boolean successful) {
        if (this.completedTransactionsInfo != null) {
            this.completedTransactionsInfo.markTransactionCompleted(gtx, successful);
        }
    }

    public boolean isTransactionCompleted(GlobalTransaction gtx) {
        return this.completedTransactionsInfo != null && this.completedTransactionsInfo.isTransactionCompleted(gtx);
    }

    public CompletedTransactionStatus getCompletedTransactionStatus(GlobalTransaction gtx) {
        if (this.completedTransactionsInfo == null) {
            return CompletedTransactionStatus.NOT_COMPLETED;
        }
        return this.completedTransactionsInfo.getTransactionStatus(gtx);
    }

    public CompletionStage<Integer> beforeCompletion(LocalTransaction localTransaction) {
        if (log.isTraceEnabled()) {
            log.tracef("beforeCompletion called for %s", localTransaction);
        }
        return this.txCoordinator.prepare(localTransaction).exceptionally(t -> {
            throw new CacheException("Could not prepare. ", t);
        });
    }

    public CompletionStage<Void> afterCompletion(LocalTransaction localTransaction, int status) {
        if (log.isTraceEnabled()) {
            log.tracef("afterCompletion(%s) called for %s.", status, localTransaction);
        }
        if (status == 3) {
            return this.txCoordinator.commit(localTransaction, false).handle((isOnePhase, t) -> {
                if (t != null) {
                    throw new CacheException("Could not commit.", t);
                }
                this.releaseLocksForCompletedTransaction(localTransaction, (boolean)isOnePhase);
                return null;
            });
        }
        if (status == 4) {
            localTransaction.markForRollback(true);
            return this.txCoordinator.rollback(localTransaction).exceptionally(t -> {
                throw new CacheException("Could not commit.", t);
            });
        }
        throw new IllegalArgumentException("Unknown status: " + status);
    }

    protected final void releaseLocksForCompletedTransaction(LocalTransaction localTransaction, boolean committedInOnePhase) {
        GlobalTransaction gtx = localTransaction.getGlobalTransaction();
        if (!(committedInOnePhase && this.isOptimisticCache() || !this.isClustered())) {
            this.removeTransactionInfoRemotely(localTransaction, gtx);
        }
        this.removeLocalTransaction(localTransaction);
        if (log.isTraceEnabled()) {
            log.tracef("Committed in onePhase? %s isOptimistic? %s", committedInOnePhase, this.isOptimisticCache());
        }
    }

    private void removeTransactionInfoRemotely(LocalTransaction localTransaction, GlobalTransaction gtx) {
        if (this.mayHaveRemoteLocks(localTransaction) && !this.partitionHandlingManager.isTransactionPartiallyCommitted(gtx)) {
            TxCompletionNotificationCommand command = this.commandsFactory.buildTxCompletionNotificationCommand(null, gtx);
            LocalizedCacheTopology cacheTopology = this.clusteringLogic.getCacheTopology();
            Collection<Address> owners = cacheTopology.getWriteOwners(localTransaction.getAffectedKeys());
            Collection<Address> commitNodes = cacheTopology.getReadConsistentHash().isReplicated() ? null : owners;
            commitNodes = localTransaction.getCommitNodes(commitNodes, cacheTopology);
            if (log.isTraceEnabled()) {
                log.tracef("About to invoke tx completion notification on commitNodes: %s", commitNodes);
            }
            this.rpcManager.sendToMany(commitNodes, command, DeliverOrder.NONE);
        }
    }

    private boolean mayHaveRemoteLocks(LocalTransaction lt) {
        return lt.getRemoteLocksAcquired() != null && !lt.getRemoteLocksAcquired().isEmpty() || lt.hasModifications() || this.isPessimisticLocking && lt.getTopologyId() != this.rpcManager.getTopologyId();
    }

    private boolean isClustered() {
        return this.rpcManager != null;
    }

    private boolean isOptimisticCache() {
        return !this.isPessimisticLocking;
    }

    private class CompletedTransactionsInfo {
        final ConcurrentMap<GlobalTransaction, CompletedTransactionInfo> completedTransactions;
        final ConcurrentMap<Address, Long> nodeMaxPrunedTxIds = new ConcurrentHashMap<Address, Long>();
        volatile long globalMaxPrunedTxId = -1L;

        CompletedTransactionsInfo() {
            this.completedTransactions = new ConcurrentHashMap<GlobalTransaction, CompletedTransactionInfo>();
        }

        void markTransactionCompleted(GlobalTransaction globalTx, boolean successful) {
            if (log.isTraceEnabled()) {
                log.tracef("Marking transaction %s as completed", globalTx);
            }
            this.completedTransactions.put(globalTx, new CompletedTransactionInfo(TransactionTable.this.timeService.time(), successful));
        }

        boolean isTransactionCompleted(GlobalTransaction gtx) {
            if (this.completedTransactions.containsKey(gtx)) {
                return true;
            }
            if (gtx.getId() > this.globalMaxPrunedTxId) {
                return false;
            }
            Long nodeMaxPrunedTxId = (Long)this.nodeMaxPrunedTxIds.get(gtx.getAddress());
            return nodeMaxPrunedTxId != null && gtx.getId() <= nodeMaxPrunedTxId;
        }

        CompletedTransactionStatus getTransactionStatus(GlobalTransaction gtx) {
            CompletedTransactionInfo completedTx = (CompletedTransactionInfo)this.completedTransactions.get(gtx);
            if (completedTx != null) {
                return completedTx.successful ? CompletedTransactionStatus.COMMITTED : CompletedTransactionStatus.ABORTED;
            }
            if (gtx.getId() > this.globalMaxPrunedTxId) {
                return CompletedTransactionStatus.NOT_COMPLETED;
            }
            Long nodeMaxPrunedTxId = (Long)this.nodeMaxPrunedTxIds.get(gtx.getAddress());
            if (nodeMaxPrunedTxId == null) {
                return CompletedTransactionStatus.NOT_COMPLETED;
            }
            if (gtx.getId() > nodeMaxPrunedTxId) {
                return CompletedTransactionStatus.NOT_COMPLETED;
            }
            return CompletedTransactionStatus.EXPIRED;
        }

        void cleanupCompletedTransactions() {
            if (this.completedTransactions.isEmpty()) {
                return;
            }
            try {
                if (log.isTraceEnabled()) {
                    log.tracef("About to cleanup completed transaction. Initial size is %d", this.completedTransactions.size());
                }
                long beginning = TransactionTable.this.timeService.time();
                long minCompleteTimestamp = TransactionTable.this.timeService.time() - TimeUnit.MILLISECONDS.toNanos(TransactionTable.this.configuration.transaction().completedTxTimeout());
                int removedEntries = 0;
                HashSet<Address> leavers = new HashSet<Address>();
                for (Map.Entry e : this.nodeMaxPrunedTxIds.entrySet()) {
                    if (TransactionTable.this.rpcManager.getMembers().contains(e.getKey())) continue;
                    leavers.add((Address)e.getKey());
                }
                Iterator txIterator = this.completedTransactions.entrySet().iterator();
                while (txIterator.hasNext()) {
                    Map.Entry e;
                    e = txIterator.next();
                    CompletedTransactionInfo completedTx = (CompletedTransactionInfo)e.getValue();
                    if (minCompleteTimestamp - completedTx.timestamp > 0L) {
                        long txId = ((GlobalTransaction)e.getKey()).getId();
                        Address address = ((GlobalTransaction)e.getKey()).getAddress();
                        this.updateLastPrunedTxId(txId, address);
                        txIterator.remove();
                        ++removedEntries;
                        continue;
                    }
                    leavers.remove(((GlobalTransaction)e.getKey()).getAddress());
                }
                leavers.forEach(this.nodeMaxPrunedTxIds::remove);
                long duration = TransactionTable.this.timeService.timeDuration(beginning, TimeUnit.MILLISECONDS);
                if (log.isTraceEnabled()) {
                    log.tracef("Finished cleaning up completed transactions in %d millis, %d transactions were removed, current number of completed transactions is %d", removedEntries, duration, this.completedTransactions.size());
                }
                if (log.isTraceEnabled()) {
                    log.tracef("Last pruned transaction ids were updated: %d, %s", this.globalMaxPrunedTxId, this.nodeMaxPrunedTxIds);
                }
            }
            catch (Exception e) {
                log.errorf(e, "Failed to cleanup completed transactions: %s", e.getMessage());
            }
        }

        private void updateLastPrunedTxId(long txId, Address address) {
            if (txId > this.globalMaxPrunedTxId) {
                this.globalMaxPrunedTxId = txId;
            }
            this.nodeMaxPrunedTxIds.compute(address, (a, nodeMaxPrunedTxId) -> {
                if (nodeMaxPrunedTxId != null && txId <= nodeMaxPrunedTxId) {
                    return nodeMaxPrunedTxId;
                }
                return txId;
            });
        }
    }

    public static enum CompletedTransactionStatus {
        NOT_COMPLETED,
        COMMITTED,
        ABORTED,
        EXPIRED;

    }

    private static class CompletedTransactionInfo {
        public final long timestamp;
        public final boolean successful;

        private CompletedTransactionInfo(long timestamp, boolean successful) {
            this.timestamp = timestamp;
            this.successful = successful;
        }
    }
}

