/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.protostream.impl;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Queue;
import org.infinispan.marshall.protostream.impl.AbstractInternalProtoStreamMarshaller;
import org.infinispan.marshall.protostream.impl.AbstractMarshallableCollection;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=18)
public class MarshallableDeque<T>
extends AbstractMarshallableCollection<T> {
    final Deque<T> deque;

    public static <T> MarshallableDeque<T> create(Queue<T> queue) {
        MarshallableDeque<T> marshallableDeque;
        if (queue == null) {
            marshallableDeque = null;
        } else if (queue instanceof Deque) {
            Deque deque = (Deque)queue;
            marshallableDeque = new MarshallableDeque<T>(deque);
        } else {
            marshallableDeque = new MarshallableDeque<T>(new ArrayDeque<T>(queue));
        }
        return marshallableDeque;
    }

    public static <T> MarshallableDeque<T> create(Deque<T> deque) {
        return deque == null ? null : new MarshallableDeque<T>(deque);
    }

    public static <T> Deque<T> unwrap(MarshallableDeque<T> wrapper) {
        return wrapper == null ? null : wrapper.get();
    }

    private MarshallableDeque(Deque<T> deque) {
        this.deque = deque;
    }

    @ProtoFactory
    MarshallableDeque(int size, Deque<byte[]> bytes) {
        throw log.marshallerNotOverridden(this.getClass().getName());
    }

    @ProtoField(value=2, collectionImplementation=ArrayDeque.class)
    Deque<byte[]> getBytes() {
        throw log.marshallerNotOverridden(this.getClass().getName());
    }

    @Override
    public Deque<T> get() {
        return this.deque;
    }

    public static class Marshaller
    extends AbstractMarshallableCollection.Marshaller {
        public Marshaller(AbstractInternalProtoStreamMarshaller marshaller) {
            super(marshaller);
        }

        @Override
        Collection<Object> newCollection(int size) {
            return new ArrayDeque<Object>(size);
        }

        @Override
        AbstractMarshallableCollection<?> newWrapperInstance(Collection<?> collection) {
            return new MarshallableDeque((Deque)collection);
        }

        public Class<MarshallableDeque> getJavaClass() {
            return MarshallableDeque.class;
        }
    }
}

