/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.impl;

import java.util.ArrayDeque;
import java.util.Queue;
import java.util.Set;
import net.jcip.annotations.GuardedBy;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.transport.AbstractRequest;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.remoting.transport.impl.RequestRepository;

public abstract class ExclusiveTargetRequest<T>
extends AbstractRequest<Address, T> {
    @GuardedBy(value="this")
    private Queue<Runnable> queue;
    @GuardedBy(value="this")
    private boolean handling;

    public ExclusiveTargetRequest(ResponseCollector<Address, T> responseCollector, long requestId, RequestRepository repository) {
        super(requestId, responseCollector, repository);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onResponse(Address sender, Response response) {
        if (this.isDone()) {
            return;
        }
        ExclusiveTargetRequest exclusiveTargetRequest = this;
        synchronized (exclusiveTargetRequest) {
            if (this.isDone()) {
                return;
            }
            if (this.handling) {
                this.enqueueOperation(() -> this.actualOnResponse(sender, response));
                return;
            }
            this.handling = true;
        }
        this.actualOnResponse(sender, response);
        this.handleLoop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean onNewView(Set<Address> members) {
        if (this.isDone()) {
            return false;
        }
        ExclusiveTargetRequest exclusiveTargetRequest = this;
        synchronized (exclusiveTargetRequest) {
            if (this.isDone()) {
                return false;
            }
            if (this.handling) {
                this.enqueueOperation(() -> this.actualOnView(members));
                return false;
            }
            this.handling = true;
        }
        boolean response = this.actualOnView(members);
        this.handleLoop();
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void onTimeout() {
        if (this.isDone()) {
            return;
        }
        ExclusiveTargetRequest exclusiveTargetRequest = this;
        synchronized (exclusiveTargetRequest) {
            if (this.isDone()) {
                return;
            }
            if (this.handling) {
                this.enqueueOperation(this::actualOnTimeout);
                return;
            }
            this.handling = true;
        }
        this.actualOnTimeout();
        this.handleLoop();
    }

    @GuardedBy(value="this")
    private void enqueueOperation(Runnable runnable) {
        Queue<Runnable> queue = this.queue;
        if (queue == null) {
            this.queue = queue = new ArrayDeque<Runnable>(2);
        }
        queue.add(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleLoop() {
        assert (this.handling);
        while (!this.isDone()) {
            Queue<Runnable> queue;
            ExclusiveTargetRequest exclusiveTargetRequest = this;
            synchronized (exclusiveTargetRequest) {
                queue = this.queue;
                if (queue == null) {
                    this.handling = false;
                    return;
                }
                this.queue = null;
            }
            queue.forEach(Runnable::run);
        }
    }

    protected abstract void actualOnResponse(Address var1, Response var2);

    protected abstract boolean actualOnView(Set<Address> var1);

    protected abstract void actualOnTimeout();
}

