/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.responses;

import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.ResponseGenerator;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.responses.UnsuccessfulResponse;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class DefaultResponseGenerator
implements ResponseGenerator {
    private static final Log log = LogFactory.getLog(DefaultResponseGenerator.class);

    @Override
    public Response getResponse(CacheRpcCommand command, Object rv) {
        if (rv instanceof Response) {
            return (Response)rv;
        }
        if (command.isReturnValueExpected()) {
            if (!command.isSuccessful()) {
                return rv == null ? UnsuccessfulResponse.EMPTY_RESPONSE : new UnsuccessfulResponse<Object>(rv);
            }
            return SuccessfulResponse.create(rv);
        }
        if (rv != null && log.isTraceEnabled()) {
            log.tracef("Ignoring non-null response for command %s: %s", command, rv);
        }
        return null;
    }
}

