/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.reactive.publisher;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.infinispan.commons.util.Util;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.reactivestreams.Publisher;

public class PublisherReducers {
    private PublisherReducers() {
    }

    public static Function<Publisher<Boolean>, CompletionStage<Boolean>> and() {
        return AndFinalizer.INSTANCE;
    }

    public static <E> Function<Publisher<E>, CompletionStage<Boolean>> allMatch(Predicate<? super E> predicate) {
        return new AllMatchReducer<E>(MarshallableObject.create(predicate));
    }

    public static <E> Function<Publisher<E>, CompletionStage<Boolean>> anyMatch(Predicate<? super E> predicate) {
        return new AnyMatchReducer<E>(MarshallableObject.create(predicate));
    }

    public static <I, E> Function<Publisher<I>, CompletionStage<E>> collect(Supplier<E> supplier, BiConsumer<E, ? super I> consumer) {
        return new CollectReducer<I, E>(MarshallableObject.create(supplier), MarshallableObject.create(consumer));
    }

    public static <I, E> Function<Publisher<I>, CompletionStage<E>> collectorReducer(Collector<? super I, E, ?> collector) {
        return new CollectorReducer<I, E>(MarshallableObject.create(collector));
    }

    public static <E> Function<Publisher<E>, CompletionStage<E>> collectorFinalizer(Collector<?, E, ?> collector) {
        return new CollectorFinalizer(MarshallableObject.create(collector));
    }

    public static <E> Function<Publisher<E>, CompletionStage<E>> accumulate(BiConsumer<E, E> biConsumer) {
        return new CombinerFinalizer<E>(MarshallableObject.create(biConsumer));
    }

    public static <E> Function<Publisher<E>, CompletionStage<E>> findFirst() {
        return FindFirstReducerFinalizer.INSTANCE;
    }

    public static <E> Function<Publisher<E>, CompletionStage<E>> max(Comparator<? super E> comparator) {
        return new MaxReducerFinalizer<E>(MarshallableObject.create(comparator));
    }

    public static <E> Function<Publisher<E>, CompletionStage<E>> min(Comparator<? super E> comparator) {
        return new MinReducerFinalizer<E>(MarshallableObject.create(comparator));
    }

    public static <E> Function<Publisher<E>, CompletionStage<Boolean>> noneMatch(Predicate<? super E> predicate) {
        return new NoneMatchReducer<E>(MarshallableObject.create(predicate));
    }

    public static Function<Publisher<Boolean>, CompletionStage<Boolean>> or() {
        return OrFinalizer.INSTANCE;
    }

    public static <I, E> Function<Publisher<I>, CompletionStage<E>> reduce(E identity, BiFunction<E, ? super I, E> biFunction) {
        return new ReduceWithIdentityReducer<I, E>(MarshallableObject.create(identity), MarshallableObject.create(biFunction));
    }

    public static <I, E> Function<Publisher<I>, CompletionStage<E>> reduceWith(Callable<? extends E> initialSupplier, BiFunction<E, ? super I, E> biFunction) {
        return new ReduceWithInitialSupplierReducer<I, E>(MarshallableObject.create(initialSupplier), MarshallableObject.create(biFunction));
    }

    public static <E> Function<Publisher<E>, CompletionStage<E>> reduce(BinaryOperator<E> operator) {
        return new ReduceReducerFinalizer<E>(MarshallableObject.create(operator));
    }

    public static Function<Publisher<?>, CompletionStage<Long>> count() {
        return SumReducer.INSTANCE;
    }

    public static Function<Publisher<Long>, CompletionStage<Long>> add() {
        return SumFinalizer.INSTANCE;
    }

    public static <I> Function<Publisher<I>, CompletionStage<Object[]>> toArrayReducer() {
        return PublisherReducers.toArrayReducer(null);
    }

    public static <I extends E, E> Function<Publisher<I>, CompletionStage<E[]>> toArrayReducer(IntFunction<E[]> generator) {
        return new ToArrayReducer(MarshallableObject.create(generator));
    }

    public static <E> Function<Publisher<E[]>, CompletionStage<E[]>> toArrayFinalizer() {
        return PublisherReducers.toArrayFinalizer(null);
    }

    public static <E> Function<Publisher<E[]>, CompletionStage<E[]>> toArrayFinalizer(IntFunction<E[]> generator) {
        return new ToArrayFinalizer(MarshallableObject.create(generator));
    }

    @ProtoTypeId(value=1307)
    public static final class AndFinalizer
    implements Function<Publisher<Boolean>, CompletionStage<Boolean>> {
        private static final AndFinalizer INSTANCE = new AndFinalizer();

        @ProtoFactory
        static AndFinalizer protoFactory() {
            return INSTANCE;
        }

        @Override
        public CompletionStage<Boolean> apply(Publisher<Boolean> booleanPublisher) {
            return Flowable.fromPublisher(booleanPublisher).all(bool -> bool == Boolean.TRUE).toCompletionStage();
        }
    }

    @ProtoTypeId(value=1305)
    public static class AllMatchReducer<E>
    implements Function<Publisher<E>, CompletionStage<Boolean>> {
        @ProtoField(value=1)
        final MarshallableObject<Predicate<? super E>> predicate;

        @ProtoFactory
        AllMatchReducer(MarshallableObject<Predicate<? super E>> predicate) {
            this.predicate = predicate;
        }

        @Override
        public CompletionStage<Boolean> apply(Publisher<E> ePublisher) {
            return Flowable.fromPublisher(ePublisher).all(((Predicate)this.predicate.get())::test).toCompletionStage();
        }
    }

    @ProtoTypeId(value=1306)
    public static class AnyMatchReducer<E>
    implements Function<Publisher<E>, CompletionStage<Boolean>> {
        @ProtoField(value=1)
        final MarshallableObject<Predicate<? super E>> predicate;

        @ProtoFactory
        AnyMatchReducer(MarshallableObject<Predicate<? super E>> predicate) {
            this.predicate = predicate;
        }

        @Override
        public CompletionStage<Boolean> apply(Publisher<E> ePublisher) {
            return Flowable.fromPublisher(ePublisher).any(((Predicate)this.predicate.get())::test).toCompletionStage();
        }
    }

    @ProtoTypeId(value=1308)
    public static final class CollectReducer<I, E>
    implements Function<Publisher<I>, CompletionStage<E>> {
        @ProtoField(value=1)
        final MarshallableObject<Supplier<E>> supplier;
        @ProtoField(value=2)
        final MarshallableObject<BiConsumer<E, ? super I>> accumulator;

        @ProtoFactory
        CollectReducer(MarshallableObject<Supplier<E>> supplier, MarshallableObject<BiConsumer<E, ? super I>> accumulator) {
            this.supplier = supplier;
            this.accumulator = accumulator;
        }

        @Override
        public CompletionStage<E> apply(Publisher<I> iPublisher) {
            return Flowable.fromPublisher(iPublisher).collect(((Supplier)((Supplier)this.supplier.get()))::get, ((BiConsumer)this.accumulator.get())::accept).toCompletionStage();
        }
    }

    @ProtoTypeId(value=1310)
    public static final class CollectorReducer<I, E>
    implements Function<Publisher<I>, CompletionStage<E>> {
        @ProtoField(value=1)
        final MarshallableObject<Collector<? super I, E, ?>> collector;

        @ProtoFactory
        CollectorReducer(MarshallableObject<Collector<? super I, E, ?>> collector) {
            this.collector = collector;
        }

        @Override
        public CompletionStage<E> apply(Publisher<I> iPublisher) {
            Collector collector = (Collector)this.collector.get();
            return Flowable.fromPublisher(iPublisher).collect(((Supplier)collector.supplier())::get, collector.accumulator()::accept).toCompletionStage();
        }
    }

    @ProtoTypeId(value=1309)
    public static final class CollectorFinalizer<E, R>
    implements Function<Publisher<E>, CompletionStage<E>> {
        @ProtoField(value=1)
        final MarshallableObject<Collector<?, E, ?>> collector;

        @ProtoFactory
        CollectorFinalizer(MarshallableObject<Collector<?, E, ?>> collector) {
            this.collector = collector;
        }

        @Override
        public CompletionStage<E> apply(Publisher<E> ePublisher) {
            Collector collector = (Collector)this.collector.get();
            return Flowable.fromPublisher(ePublisher).reduce(collector.combiner()::apply).switchIfEmpty((SingleSource)Single.fromCallable(((Supplier)collector.supplier())::get)).toCompletionStage();
        }
    }

    @ProtoTypeId(value=1311)
    public static final class CombinerFinalizer<E>
    implements Function<Publisher<E>, CompletionStage<E>> {
        @ProtoField(value=1)
        final MarshallableObject<BiConsumer<E, E>> biConsumer;

        @ProtoFactory
        CombinerFinalizer(MarshallableObject<BiConsumer<E, E>> biConsumer) {
            this.biConsumer = biConsumer;
        }

        @Override
        public CompletionStage<E> apply(Publisher<E> ePublisher) {
            return Flowable.fromPublisher(ePublisher).reduce((e1, e2) -> {
                ((BiConsumer)this.biConsumer.get()).accept(e1, e2);
                return e1;
            }).toCompletionStage(null);
        }
    }

    @ProtoTypeId(value=1312)
    public static final class FindFirstReducerFinalizer<E>
    implements Function<Publisher<E>, CompletionStage<E>> {
        private static final FindFirstReducerFinalizer INSTANCE = new FindFirstReducerFinalizer();

        @ProtoFactory
        static FindFirstReducerFinalizer protoFactory() {
            return INSTANCE;
        }

        @Override
        public CompletionStage<E> apply(Publisher<E> ePublisher) {
            return Flowable.fromPublisher(ePublisher).firstElement().toCompletionStage(null);
        }
    }

    @ProtoTypeId(value=1313)
    public static class MaxReducerFinalizer<E>
    implements Function<Publisher<E>, CompletionStage<E>> {
        @ProtoField(value=1)
        final MarshallableObject<Comparator<? super E>> comparator;

        @ProtoFactory
        MaxReducerFinalizer(MarshallableObject<Comparator<? super E>> comparator) {
            this.comparator = comparator;
        }

        @Override
        public CompletionStage<E> apply(Publisher<E> ePublisher) {
            return Flowable.fromPublisher(ePublisher).reduce((e1, e2) -> {
                if (((Comparator)this.comparator.get()).compare(e1, e2) > 0) {
                    return e1;
                }
                return e2;
            }).toCompletionStage(null);
        }
    }

    @ProtoTypeId(value=1314)
    public static class MinReducerFinalizer<E>
    implements Function<Publisher<E>, CompletionStage<E>> {
        @ProtoField(value=1)
        final MarshallableObject<Comparator<? super E>> comparator;

        @ProtoFactory
        MinReducerFinalizer(MarshallableObject<Comparator<? super E>> comparator) {
            this.comparator = comparator;
        }

        @Override
        public CompletionStage<E> apply(Publisher<E> ePublisher) {
            return Flowable.fromPublisher(ePublisher).reduce((e1, e2) -> {
                if (((Comparator)this.comparator.get()).compare(e1, e2) > 0) {
                    return e2;
                }
                return e1;
            }).toCompletionStage(null);
        }
    }

    @ProtoTypeId(value=1315)
    public static class NoneMatchReducer<E>
    implements Function<Publisher<E>, CompletionStage<Boolean>> {
        @ProtoField(value=1)
        final MarshallableObject<Predicate<? super E>> predicate;

        @ProtoFactory
        NoneMatchReducer(MarshallableObject<Predicate<? super E>> predicate) {
            this.predicate = predicate;
        }

        @Override
        public CompletionStage<Boolean> apply(Publisher<E> ePublisher) {
            return Flowable.fromPublisher(ePublisher).all(((Predicate)this.predicate.get()).negate()::test).toCompletionStage();
        }
    }

    @ProtoTypeId(value=1316)
    public static final class OrFinalizer
    implements Function<Publisher<Boolean>, CompletionStage<Boolean>> {
        private static final OrFinalizer INSTANCE = new OrFinalizer();

        @ProtoFactory
        static OrFinalizer protoFactory() {
            return INSTANCE;
        }

        @Override
        public CompletionStage<Boolean> apply(Publisher<Boolean> booleanPublisher) {
            return Flowable.fromPublisher(booleanPublisher).any(bool -> bool == Boolean.TRUE).toCompletionStage();
        }
    }

    @ProtoTypeId(value=1317)
    public static class ReduceWithIdentityReducer<I, E>
    implements Function<Publisher<I>, CompletionStage<E>> {
        @ProtoField(value=1)
        final MarshallableObject<E> identity;
        @ProtoField(value=2)
        final MarshallableObject<BiFunction<E, ? super I, E>> biFunction;

        @ProtoFactory
        ReduceWithIdentityReducer(MarshallableObject<E> identity, MarshallableObject<BiFunction<E, ? super I, E>> biFunction) {
            this.identity = identity;
            this.biFunction = biFunction;
        }

        @Override
        public CompletionStage<E> apply(Publisher<I> iPublisher) {
            return Flowable.fromPublisher(iPublisher).reduce(this.identity.get(), ((BiFunction)this.biFunction.get())::apply).toCompletionStage();
        }
    }

    @ProtoTypeId(value=1318)
    public static class ReduceWithInitialSupplierReducer<I, E>
    implements Function<Publisher<I>, CompletionStage<E>> {
        @ProtoField(value=1)
        final MarshallableObject<Callable<? extends E>> initialSupplier;
        @ProtoField(value=2)
        final MarshallableObject<BiFunction<E, ? super I, E>> biFunction;

        @ProtoFactory
        ReduceWithInitialSupplierReducer(MarshallableObject<Callable<? extends E>> initialSupplier, MarshallableObject<BiFunction<E, ? super I, E>> biFunction) {
            this.initialSupplier = initialSupplier;
            this.biFunction = biFunction;
        }

        @Override
        public CompletionStage<E> apply(Publisher<I> iPublisher) {
            return Flowable.fromPublisher(iPublisher).reduceWith(((Callable)this.initialSupplier.get())::call, ((BiFunction)this.biFunction.get())::apply).toCompletionStage();
        }
    }

    @ProtoTypeId(value=1319)
    public static class ReduceReducerFinalizer<E>
    implements Function<Publisher<E>, CompletionStage<E>> {
        @ProtoField(value=1)
        final MarshallableObject<BinaryOperator<E>> operator;

        @ProtoFactory
        ReduceReducerFinalizer(MarshallableObject<BinaryOperator<E>> operator) {
            this.operator = operator;
        }

        @Override
        public CompletionStage<E> apply(Publisher<E> ePublisher) {
            return Flowable.fromPublisher(ePublisher).reduce(((BinaryOperator)this.operator.get())::apply).toCompletionStage(null);
        }
    }

    @ProtoTypeId(value=1320)
    public static class SumReducer
    implements Function<Publisher<?>, CompletionStage<Long>> {
        private static final SumReducer INSTANCE = new SumReducer();

        @ProtoFactory
        static SumReducer protoFactory() {
            return INSTANCE;
        }

        @Override
        public CompletionStage<Long> apply(Publisher<?> longPublisher) {
            return Flowable.fromPublisher(longPublisher).count().toCompletionStage();
        }
    }

    @ProtoTypeId(value=1321)
    public static class SumFinalizer
    implements Function<Publisher<Long>, CompletionStage<Long>> {
        private static final SumFinalizer INSTANCE = new SumFinalizer();

        @ProtoFactory
        static SumFinalizer protoFactory() {
            return INSTANCE;
        }

        @Override
        public CompletionStage<Long> apply(Publisher<Long> longPublisher) {
            return Flowable.fromPublisher(longPublisher).reduce((Object)0L, Long::sum).toCompletionStage();
        }
    }

    @ProtoTypeId(value=1323)
    public static class ToArrayReducer<I extends E, E>
    implements Function<Publisher<I>, CompletionStage<E[]>> {
        @ProtoField(value=1)
        final MarshallableObject<IntFunction<E[]>> generator;

        @ProtoFactory
        ToArrayReducer(MarshallableObject<IntFunction<E[]>> generator) {
            this.generator = generator;
        }

        @Override
        public CompletionStage<E[]> apply(Publisher<I> ePublisher) {
            Single listSingle = Flowable.fromPublisher(ePublisher).toList();
            Single arraySingle = this.generator != null ? listSingle.map(l -> {
                Object[] array = (Object[])((IntFunction)this.generator.get()).apply(l.size());
                int offset = 0;
                for (Object e : l) {
                    array[offset++] = e;
                }
                return array;
            }) : listSingle.map(l -> l.toArray(Util.EMPTY_OBJECT_ARRAY));
            return arraySingle.toCompletionStage();
        }
    }

    @ProtoTypeId(value=1322)
    public static class ToArrayFinalizer<E>
    implements Function<Publisher<E[]>, CompletionStage<E[]>> {
        @ProtoField(value=1)
        final MarshallableObject<IntFunction<E[]>> generator;

        @ProtoFactory
        ToArrayFinalizer(MarshallableObject<IntFunction<E[]>> generator) {
            this.generator = generator;
        }

        @Override
        public CompletionStage<E[]> apply(Publisher<E[]> publisher) {
            Single arraySingle;
            Flowable flowable = Flowable.fromPublisher(publisher);
            if (this.generator != null) {
                IntFunction generator = (IntFunction)this.generator.get();
                arraySingle = flowable.reduce((v1, v2) -> {
                    Object[] array = (Object[])generator.apply(((Object[])v1).length + ((Object[])v2).length);
                    System.arraycopy(v1, 0, array, 0, ((Object[])v1).length);
                    System.arraycopy(v2, 0, array, ((Object[])v1).length, ((Object[])v2).length);
                    return array;
                }).switchIfEmpty((SingleSource)Single.fromCallable(() -> (Object[])generator.apply(0)));
            } else {
                arraySingle = flowable.reduce((v1, v2) -> {
                    Object[] array = Arrays.copyOf(v1, ((Object[])v1).length + ((Object[])v2).length);
                    System.arraycopy(v2, 0, array, ((Object[])v1).length, ((Object[])v2).length);
                    return array;
                }).switchIfEmpty((SingleSource)Single.just((Object)Util.EMPTY_OBJECT_ARRAY));
            }
            return arraySingle.toCompletionStage();
        }
    }
}

