/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.functional.impl;

import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=1081)
public class StatsEnvelope<T> {
    public static final byte HIT = 1;
    public static final byte MISS = 2;
    public static final byte CREATE = 4;
    public static final byte UPDATE = 8;
    public static final byte DELETE = 16;
    private final T value;
    private final byte flags;

    public static <T> StatsEnvelope<T> create(T returnValue, CacheEntry<?, ?> e, boolean exists, boolean isRead) {
        byte flags = 0;
        if (isRead) {
            flags = exists ? (byte)((byte)(flags | 1)) : (byte)((byte)(flags | 2));
        }
        if (exists) {
            if (e.getValue() == null) {
                flags = (byte)(flags | 0x10);
            } else if (e.isChanged()) {
                flags = (byte)(flags | 8);
            }
        } else if (e.getValue() != null) {
            flags = (byte)(flags | 4);
        }
        return new StatsEnvelope<T>(returnValue, flags);
    }

    public static <R> StatsEnvelope create(R ret, boolean isNull) {
        return new StatsEnvelope<R>(ret, isNull ? (byte)2 : 1);
    }

    public static Object unpack(InvocationContext ctx, VisitableCommand command, Object o) {
        return ((StatsEnvelope)o).value;
    }

    public static Object unpackCollection(InvocationContext ctx, VisitableCommand command, Object o) {
        return ((Collection)o).stream().map(StatsEnvelope::value).collect(Collectors.toList());
    }

    public static Object unpackStream(InvocationContext ctx, VisitableCommand command, Object o) {
        return ((Stream)o).map(StatsEnvelope::value);
    }

    private StatsEnvelope(T value, byte flags) {
        this.value = value;
        this.flags = flags;
    }

    @ProtoFactory
    StatsEnvelope(MarshallableObject<T> wrappedValue, byte flags) {
        this(MarshallableObject.unwrap(wrappedValue), flags);
    }

    @ProtoField(number=1, name="value")
    MarshallableObject<T> getWrappedValue() {
        return MarshallableObject.create(this.value);
    }

    public T value() {
        return this.value;
    }

    @ProtoField(value=2)
    public byte flags() {
        return this.flags;
    }

    public String toString() {
        return "StatsEnvelope{value=" + String.valueOf(this.value) + ", flags=" + ((this.flags & 1) != 0 ? (char)'H' : '_') + ((this.flags & 2) != 0 ? (char)'M' : '_') + ((this.flags & 4) != 0 ? (char)'C' : '_') + ((this.flags & 8) != 0 ? (char)'U' : '_') + ((this.flags & 0x10) != 0 ? (char)'D' : '_') + "}";
    }

    public boolean isHit() {
        return (this.flags & 1) != 0;
    }

    public boolean isMiss() {
        return (this.flags & 2) != 0;
    }

    public boolean isDelete() {
        return (this.flags & 0x10) != 0;
    }
}

