/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.statetransfer;

import java.util.List;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.util.ByteString;
import org.infinispan.xsite.statetransfer.XSiteState;
import org.infinispan.xsite.statetransfer.XSiteStateConsumer;

@ProtoTypeId(value=1241)
public class XSiteStatePushCommand
extends BaseRpcCommand {
    private List<XSiteState> chunk;

    @ProtoFactory
    public XSiteStatePushCommand(ByteString cacheName, List<XSiteState> chunk) {
        super(cacheName);
        this.chunk = chunk;
    }

    @ProtoField(value=2)
    public List<XSiteState> getChunk() {
        return this.chunk;
    }

    @Override
    public CompletionStage<?> invokeAsync(ComponentRegistry componentRegistry) throws Throwable {
        XSiteStateConsumer stateConsumer = componentRegistry.getXSiteStateTransferManager().running().getStateConsumer();
        stateConsumer.applyState(this.chunk);
        return CompletableFutures.completedNull();
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public boolean canBlock() {
        return true;
    }

    @Override
    public String toString() {
        return "XSiteStatePushCommand{cacheName=" + String.valueOf(this.cacheName) + " (" + this.chunk.size() + " keys)}";
    }
}

