/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.events;

import java.util.Objects;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.util.ByteString;
import org.infinispan.xsite.events.XSiteEventType;

@ProtoTypeId(value=1236)
public final class XSiteEvent {
    @ProtoField(value=1)
    final XSiteEventType type;
    @ProtoField(value=2)
    final ByteString siteName;
    @ProtoField(value=3)
    final ByteString cacheName;

    @ProtoFactory
    XSiteEvent(XSiteEventType type, ByteString siteName, ByteString cacheName) {
        this.type = Objects.requireNonNull(type);
        this.siteName = siteName;
        this.cacheName = cacheName;
    }

    public static XSiteEvent createConnectEvent(ByteString localSite) {
        return new XSiteEvent(XSiteEventType.SITE_CONNECTED, Objects.requireNonNull(localSite), null);
    }

    public static XSiteEvent createRequestState(ByteString localSite, ByteString cacheName) {
        return new XSiteEvent(XSiteEventType.STATE_REQUEST, Objects.requireNonNull(localSite), Objects.requireNonNull(cacheName));
    }

    public static XSiteEvent createInitialStateRequest(ByteString localSite, ByteString cacheName) {
        return new XSiteEvent(XSiteEventType.INITIAL_STATE_REQUEST, Objects.requireNonNull(localSite), Objects.requireNonNull(cacheName));
    }

    public XSiteEventType getType() {
        return this.type;
    }

    public ByteString getSiteName() {
        return this.siteName;
    }

    public ByteString getCacheName() {
        return this.cacheName;
    }

    public String toString() {
        return "XSiteEvent{type=" + String.valueOf((Object)this.type) + ", siteName=" + String.valueOf(this.siteName) + ", cacheName=" + String.valueOf(this.cacheName) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XSiteEvent that = (XSiteEvent)o;
        if (this.type != that.type) {
            return false;
        }
        if (!Objects.equals(this.siteName, that.siteName)) {
            return false;
        }
        return Objects.equals(this.cacheName, that.cacheName);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + (this.siteName != null ? this.siteName.hashCode() : 0);
        result = 31 * result + (this.cacheName != null ? this.cacheName.hashCode() : 0);
        return result;
    }
}

