/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.commands.remote;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.concurrent.AggregateCompletionStage;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.marshall.protostream.impl.MarshallableList;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.IracMetadata;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoName;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.util.ByteString;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.BackupReceiver;
import org.infinispan.xsite.commands.remote.IracUpdateKeyRequest;

@ProtoTypeId(value=1102)
public class IracPutManyRequest
extends IracUpdateKeyRequest<IntSet> {
    private static final Log log = LogFactory.getLog(IracPutManyRequest.class);
    final List<Update> updateList;

    public IracPutManyRequest(ByteString cacheName, int maxCapacity) {
        super(cacheName);
        this.updateList = new ArrayList<Update>(maxCapacity);
    }

    @ProtoFactory
    IracPutManyRequest(ByteString cacheName, MarshallableList<Update> updateList) {
        super(cacheName);
        this.updateList = MarshallableList.unwrap(updateList);
    }

    @ProtoField(value=2)
    MarshallableList<Update> getUpdateList() {
        return MarshallableList.create(this.updateList);
    }

    @Override
    public CompletionStage<IntSet> executeOperation(BackupReceiver receiver) {
        IntSet rsp = IntSets.concurrentSet((int)this.updateList.size());
        AggregateCompletionStage stage = CompletionStages.aggregateCompletionStage((Object)rsp);
        for (int i = 0; i < this.updateList.size(); ++i) {
            int keyIndex = i;
            Update update = this.updateList.get(i);
            stage.dependsOn(update.execute(receiver).exceptionally(throwable -> {
                if (log.isTraceEnabled()) {
                    log.tracef((Throwable)throwable, "[IRAC] Received exception while applying %s", update);
                }
                rsp.set(keyIndex);
                return null;
            }));
        }
        return stage.freeze();
    }

    public String toString() {
        return "IracPutManyRequest{cacheName=" + String.valueOf(this.cacheName) + ", updateList=" + Util.toStr(this.updateList) + "}";
    }

    public void addUpdate(Object key, Object value, Metadata metadata, IracMetadata iracMetadata) {
        this.updateList.add(new Write(key, iracMetadata, value, metadata));
    }

    public void addRemove(Object key, IracMetadata tombstone) {
        this.updateList.add(new Remove(key, tombstone));
    }

    public void addExpire(Object key, IracMetadata tombstone) {
        this.updateList.add(new Expire(key, tombstone));
    }

    public boolean isEmpty() {
        return this.updateList.isEmpty();
    }

    private static interface Update {
        public CompletionStage<Void> execute(BackupReceiver var1);
    }

    @ProtoName(value="IracPutManyRequestWrite")
    @ProtoTypeId(value=1105)
    public static final class Write
    extends Remove {
        private final Object value;
        private final Metadata metadata;

        private Write(Object key, IracMetadata iracMetadata, Object value, Metadata metadata) {
            super(key, iracMetadata);
            this.value = value;
            this.metadata = metadata;
        }

        @ProtoFactory
        Write(MarshallableObject<Object> key, IracMetadata iracMetadata, MarshallableObject<Object> value, MarshallableObject<Metadata> metadata) {
            this(MarshallableObject.unwrap(key), iracMetadata, MarshallableObject.unwrap(value), MarshallableObject.unwrap(metadata));
        }

        @ProtoField(value=3)
        MarshallableObject<Object> getValue() {
            return MarshallableObject.create(this.value);
        }

        @ProtoField(value=4)
        MarshallableObject<Metadata> getMetadata() {
            return MarshallableObject.create(this.metadata);
        }

        @Override
        public CompletionStage<Void> execute(BackupReceiver backupReceiver) {
            return backupReceiver.putKeyValue(this.key, this.value, this.metadata, this.iracMetadata);
        }

        @Override
        public String toString() {
            return "Write{key=" + Util.toStr((Object)this.key) + ", value=" + Util.toStr((Object)this.value) + ", iracMetadata=" + String.valueOf(this.iracMetadata) + ", metadata=" + String.valueOf(this.metadata) + "}";
        }
    }

    @ProtoName(value="IracPutManyRequestRemove")
    @ProtoTypeId(value=1104)
    public static class Remove
    implements Update {
        final Object key;
        @ProtoField(value=2)
        final IracMetadata iracMetadata;

        @ProtoField(value=1)
        MarshallableObject<Object> getKey() {
            return MarshallableObject.create(this.key);
        }

        @ProtoFactory
        Remove(MarshallableObject<Object> key, IracMetadata iracMetadata) {
            this(MarshallableObject.unwrap(key), iracMetadata);
        }

        Remove(Object key, IracMetadata iracMetadata) {
            this.key = key;
            this.iracMetadata = iracMetadata;
        }

        @Override
        public CompletionStage<Void> execute(BackupReceiver backupReceiver) {
            return backupReceiver.removeKey(this.key, this.iracMetadata, false);
        }

        public String toString() {
            return "Remove{key=" + Util.toStr((Object)this.key) + ", iracMetadata=" + String.valueOf(this.iracMetadata) + "}";
        }
    }

    @ProtoName(value="IracPutManyRequestExpire")
    @ProtoTypeId(value=1103)
    public static final class Expire
    extends Remove {
        @ProtoFactory
        Expire(MarshallableObject<Object> key, IracMetadata iracMetadata) {
            this(MarshallableObject.unwrap(key), iracMetadata);
        }

        private Expire(Object key, IracMetadata tombstone) {
            super(key, tombstone);
        }

        @Override
        public CompletionStage<Void> execute(BackupReceiver backupReceiver) {
            return backupReceiver.removeKey(this.key, this.iracMetadata, true);
        }

        @Override
        public String toString() {
            return "Expire{key=" + Util.toStr((Object)this.key) + ", iracMetadata=" + String.valueOf(this.iracMetadata) + "}";
        }
    }
}

