/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.commands;

import java.util.concurrent.CompletionStage;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.util.ByteString;
import org.infinispan.xsite.statetransfer.XSiteStateTransferManager;

@ProtoTypeId(value=1247)
public class XSiteStateTransferFinishSendCommand
extends BaseRpcCommand {
    @ProtoField(value=2)
    final String siteName;
    @ProtoField(value=3)
    final boolean statusOk;

    @ProtoFactory
    public XSiteStateTransferFinishSendCommand(ByteString cacheName, String siteName, boolean statusOk) {
        super(cacheName);
        this.siteName = siteName;
        this.statusOk = statusOk;
    }

    @Override
    public CompletionStage<?> invokeAsync(ComponentRegistry registry) throws Throwable {
        XSiteStateTransferManager stateTransferManager = registry.getXSiteStateTransferManager().running();
        stateTransferManager.notifyStatePushFinished(this.siteName, this.getOrigin(), this.statusOk);
        return CompletableFutures.completedNull();
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public String toString() {
        return "XSiteStateTransferFinishSendCommand{siteName='" + this.siteName + "', statusOk=" + this.statusOk + ", cacheName=" + String.valueOf(this.cacheName) + "}";
    }
}

