/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.commands;

import java.util.concurrent.CompletionStage;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.util.ByteString;
import org.infinispan.xsite.statetransfer.XSiteStateProvider;

@ProtoTypeId(value=1243)
public class XSiteStateTransferCancelSendCommand
extends BaseRpcCommand {
    @ProtoField(value=2)
    final String siteName;

    @ProtoFactory
    public XSiteStateTransferCancelSendCommand(ByteString cacheName, String siteName) {
        super(cacheName);
        this.siteName = siteName;
    }

    @Override
    public CompletionStage<?> invokeAsync(ComponentRegistry registry) {
        this.invokeLocal(registry.getXSiteStateTransferManager().running().getStateProvider());
        return CompletableFutures.completedNull();
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public String toString() {
        return "XSiteStateTransferCancelSendCommand{siteName='" + this.siteName + "', cacheName=" + String.valueOf(this.cacheName) + "}";
    }

    public void invokeLocal(XSiteStateProvider provider) {
        provider.cancelStateTransfer(this.siteName);
    }
}

