/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite;

import java.util.concurrent.CompletionStage;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.telemetry.InfinispanSpanAttributes;
import org.infinispan.util.ByteString;
import org.infinispan.xsite.commands.remote.XSiteCacheRequest;

@ProtoTypeId(value=1235)
public class SingleXSiteRpcCommand
extends XSiteCacheRequest<Object> {
    private final VisitableCommand command;
    private InfinispanSpanAttributes spanAttributes;

    public SingleXSiteRpcCommand(ByteString cacheName, VisitableCommand command) {
        super(cacheName);
        this.command = command;
    }

    @ProtoFactory
    SingleXSiteRpcCommand(ByteString cacheName, MarshallableObject<VisitableCommand> command) {
        this(cacheName, MarshallableObject.unwrap(command));
    }

    @ProtoField(value=2)
    MarshallableObject<VisitableCommand> getCommand() {
        return MarshallableObject.create(this.command);
    }

    @Override
    protected CompletionStage<Object> invokeInLocalCache(String origin, ComponentRegistry registry) {
        return registry.getBackupReceiver().running().handleRemoteCommand(this.command);
    }

    @Override
    public InfinispanSpanAttributes getSpanAttributes() {
        return this.spanAttributes;
    }

    @Override
    public String getOperationName() {
        return this.command.getClass().getSimpleName();
    }

    @Override
    public void setSpanAttributes(InfinispanSpanAttributes attributes) {
        this.spanAttributes = attributes;
    }

    public String toString() {
        return "SingleXSiteRpcCommand{command=" + String.valueOf(this.command) + "}";
    }
}

