/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.infinispan.commons.util.Util;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=3)
public final class ByteString
implements Comparable<ByteString> {
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private static final ByteString EMPTY = new ByteString(Util.EMPTY_BYTE_ARRAY);
    private static final int MAX_LENGTH = 255;
    private transient String s;
    private final transient int hash;
    final byte[] bytes;

    ByteString(byte[] bytes) {
        if (bytes.length > 255) {
            throw new IllegalArgumentException("ByteString must be less than 256 bytes");
        }
        this.bytes = bytes;
        this.hash = Arrays.hashCode(bytes);
    }

    @ProtoFactory
    static ByteString protoFactory(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return EMPTY;
        }
        return new ByteString(bytes);
    }

    @ProtoField(value=1)
    byte[] getBytes() {
        return this.bytes.length == 0 ? null : this.bytes;
    }

    public static ByteString fromString(String s) {
        if (s.isEmpty()) {
            return EMPTY;
        }
        return new ByteString(s.getBytes(CHARSET));
    }

    public static boolean isValid(String s) {
        return s.getBytes(CHARSET).length <= 255;
    }

    public static ByteString emptyString() {
        return EMPTY;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteString that = (ByteString)o;
        return Arrays.equals(this.bytes, that.bytes);
    }

    public String toString() {
        if (this.s == null) {
            this.s = new String(this.bytes, CHARSET);
        }
        return this.s;
    }

    @Override
    public int compareTo(ByteString o) {
        int ourLength = this.bytes.length;
        int otherLength = o.bytes.length;
        int compare = Integer.compare(ourLength, otherLength);
        if (compare != 0) {
            return compare;
        }
        for (int i = 0; i < ourLength; ++i) {
            compare = Byte.compare(this.bytes[i], o.bytes[i]);
            if (compare == 0) continue;
            return compare;
        }
        return 0;
    }
}

