/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.topology;

import java.util.Collections;
import java.util.List;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.protostream.annotations.Proto;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.infinispan.topology.PersistentUUID;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@ProtoTypeId(value=1051)
public class CacheTopology {
    private static final Log log = LogFactory.getLog(CacheTopology.class);
    private final int topologyId;
    private final int rebalanceId;
    private final boolean restoredFromState;
    private final ConsistentHash currentCH;
    private final ConsistentHash pendingCH;
    private final ConsistentHash unionCH;
    private final Phase phase;
    private final List<Address> actualMembers;
    private final List<PersistentUUID> persistentUUIDs;

    public CacheTopology(int topologyId, int rebalanceId, ConsistentHash currentCH, ConsistentHash pendingCH, Phase phase, List<Address> actualMembers, List<PersistentUUID> persistentUUIDs) {
        this(topologyId, rebalanceId, currentCH, pendingCH, null, phase, actualMembers, persistentUUIDs);
    }

    public CacheTopology(int topologyId, int rebalanceId, boolean restoredTopology, ConsistentHash currentCH, ConsistentHash pendingCH, Phase phase, List<Address> actualMembers, List<PersistentUUID> persistentUUIDs) {
        this(topologyId, rebalanceId, restoredTopology, currentCH, pendingCH, null, phase, actualMembers, persistentUUIDs);
    }

    public CacheTopology(int topologyId, int rebalanceId, ConsistentHash currentCH, ConsistentHash pendingCH, ConsistentHash unionCH, Phase phase, List<Address> actualMembers, List<PersistentUUID> persistentUUIDs) {
        this(topologyId, rebalanceId, false, currentCH, pendingCH, unionCH, phase, actualMembers, persistentUUIDs);
    }

    public CacheTopology(int topologyId, int rebalanceId, boolean restoredTopology, ConsistentHash currentCH, ConsistentHash pendingCH, ConsistentHash unionCH, Phase phase, List<Address> actualMembers, List<PersistentUUID> persistentUUIDs) {
        if (pendingCH != null && !pendingCH.getMembers().containsAll(currentCH.getMembers())) {
            throw new IllegalArgumentException("A cache topology's pending consistent hash must contain all the current consistent hash's members: currentCH=" + String.valueOf(currentCH) + ", pendingCH=" + String.valueOf(pendingCH));
        }
        if (persistentUUIDs != null && persistentUUIDs.size() != actualMembers.size()) {
            throw new IllegalArgumentException("There must be one persistent UUID for each actual member");
        }
        this.topologyId = topologyId;
        this.rebalanceId = rebalanceId;
        this.currentCH = currentCH;
        this.pendingCH = pendingCH;
        this.unionCH = unionCH;
        this.phase = phase;
        this.actualMembers = actualMembers;
        this.persistentUUIDs = persistentUUIDs;
        this.restoredFromState = restoredTopology;
    }

    @ProtoFactory
    CacheTopology(int topologyId, int rebalanceId, boolean restoredFromState, Phase phase, List<PersistentUUID> membersPersistentUUIDs, MarshallableObject<ConsistentHash> wrappedCurrentCH, MarshallableObject<ConsistentHash> wrappedPendingCH, MarshallableObject<ConsistentHash> wrappedUnionCH, List<JGroupsAddress> jGroupsMembers) {
        this.topologyId = topologyId;
        this.rebalanceId = rebalanceId;
        this.restoredFromState = restoredFromState;
        this.currentCH = MarshallableObject.unwrap(wrappedCurrentCH);
        this.pendingCH = MarshallableObject.unwrap(wrappedPendingCH);
        this.unionCH = MarshallableObject.unwrap(wrappedUnionCH);
        this.phase = phase;
        this.persistentUUIDs = membersPersistentUUIDs;
        this.actualMembers = jGroupsMembers;
    }

    @ProtoField(value=1)
    public int getTopologyId() {
        return this.topologyId;
    }

    @ProtoField(value=2)
    public int getRebalanceId() {
        return this.rebalanceId;
    }

    @ProtoField(value=3)
    boolean getRestoredFromState() {
        return this.restoredFromState;
    }

    @ProtoField(value=4)
    public Phase getPhase() {
        return this.phase;
    }

    @ProtoField(value=5)
    public List<PersistentUUID> getMembersPersistentUUIDs() {
        return this.persistentUUIDs;
    }

    @ProtoField(number=6, name="currentCH")
    MarshallableObject<ConsistentHash> getWrappedCurrentCH() {
        return MarshallableObject.create(this.currentCH);
    }

    @ProtoField(number=7, name="pendingCH")
    MarshallableObject<ConsistentHash> getWrappedPendingCH() {
        return MarshallableObject.create(this.pendingCH);
    }

    @ProtoField(number=8, name="unionCH")
    MarshallableObject<ConsistentHash> getWrappedUnionCH() {
        return MarshallableObject.create(this.unionCH);
    }

    @ProtoField(value=9)
    List<JGroupsAddress> getJGroupsMembers() {
        return this.actualMembers;
    }

    public ConsistentHash getCurrentCH() {
        return this.currentCH;
    }

    public ConsistentHash getPendingCH() {
        return this.pendingCH;
    }

    public ConsistentHash getUnionCH() {
        return this.unionCH;
    }

    public List<Address> getMembers() {
        if (this.pendingCH != null) {
            return this.pendingCH.getMembers();
        }
        if (this.currentCH != null) {
            return this.currentCH.getMembers();
        }
        return Collections.emptyList();
    }

    public List<Address> getActualMembers() {
        return this.actualMembers;
    }

    public boolean wasTopologyRestoredFromState() {
        return this.restoredFromState;
    }

    public ConsistentHash getReadConsistentHash() {
        switch (this.phase.ordinal()) {
            case 0: 
            case 1: {
                assert (this.pendingCH == null);
                assert (this.unionCH == null);
                return this.currentCH;
            }
            case 2: {
                assert (this.pendingCH != null);
                assert (this.unionCH != null);
                return this.currentCH;
            }
            case 3: {
                assert (this.pendingCH != null);
                return this.unionCH;
            }
            case 4: {
                assert (this.unionCH != null);
                return this.pendingCH;
            }
        }
        throw new IllegalStateException();
    }

    public ConsistentHash getWriteConsistentHash() {
        switch (this.phase.ordinal()) {
            case 0: 
            case 1: {
                assert (this.pendingCH == null);
                assert (this.unionCH == null);
                return this.currentCH;
            }
            case 2: 
            case 3: 
            case 4: {
                assert (this.pendingCH != null);
                assert (this.unionCH != null);
                return this.unionCH;
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheTopology that = (CacheTopology)o;
        if (this.topologyId != that.topologyId) {
            return false;
        }
        if (this.rebalanceId != that.rebalanceId) {
            return false;
        }
        if (this.phase != that.phase) {
            return false;
        }
        if (this.currentCH != null ? !this.currentCH.equals(that.currentCH) : that.currentCH != null) {
            return false;
        }
        if (this.pendingCH != null ? !this.pendingCH.equals(that.pendingCH) : that.pendingCH != null) {
            return false;
        }
        if (this.unionCH != null ? !this.unionCH.equals(that.unionCH) : that.unionCH != null) {
            return false;
        }
        return !(this.actualMembers != null ? !this.actualMembers.equals(that.actualMembers) : that.actualMembers != null);
    }

    public int hashCode() {
        int result = this.topologyId;
        result = 31 * result + this.rebalanceId;
        result = 31 * result + (this.phase != null ? this.phase.hashCode() : 0);
        result = 31 * result + (this.currentCH != null ? this.currentCH.hashCode() : 0);
        result = 31 * result + (this.pendingCH != null ? this.pendingCH.hashCode() : 0);
        result = 31 * result + (this.unionCH != null ? this.unionCH.hashCode() : 0);
        result = 31 * result + (this.actualMembers != null ? this.actualMembers.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "CacheTopology{id=" + this.topologyId + ", phase=" + String.valueOf((Object)this.phase) + ", rebalanceId=" + this.rebalanceId + ", currentCH=" + String.valueOf(this.currentCH) + ", pendingCH=" + String.valueOf(this.pendingCH) + ", unionCH=" + String.valueOf(this.unionCH) + ", actualMembers=" + String.valueOf(this.actualMembers) + ", persistentUUIDs=" + String.valueOf(this.persistentUUIDs) + "}";
    }

    public final void logRoutingTableInformation(String cacheName) {
        if (log.isTraceEnabled()) {
            log.tracef("[%s] Current consistent hash's routing table: %s", cacheName, this.currentCH.getRoutingTableAsString());
            if (this.pendingCH != null) {
                log.tracef("[%s] Pending consistent hash's routing table: %s", cacheName, this.pendingCH.getRoutingTableAsString());
            }
        }
    }

    @Proto
    @ProtoTypeId(value=1052)
    public static enum Phase {
        NO_REBALANCE(false),
        CONFLICT_RESOLUTION(false),
        READ_OLD_WRITE_ALL(true),
        READ_ALL_WRITE_ALL(false),
        READ_NEW_WRITE_ALL(false);

        private static final Phase[] values;
        private final boolean rebalance;

        private Phase(boolean rebalance) {
            this.rebalance = rebalance;
        }

        public boolean isRebalance() {
            return this.rebalance;
        }

        public static Phase valueOf(int ordinal) {
            return values[ordinal];
        }

        static {
            values = Phase.values();
        }
    }
}

