/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl;

import io.reactivex.rxjava3.core.Flowable;
import java.util.Queue;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.infinispan.commands.functional.functions.InjectableComponent;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.marshall.protostream.impl.MarshallableDeque;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.stream.impl.intops.IntermediateOperation;
import org.reactivestreams.Publisher;

@ProtoTypeId(value=1050)
public final class CacheStreamIntermediateReducer<R>
implements Function<Publisher<Object>, CompletionStage<R>>,
InjectableComponent {
    private final Queue<IntermediateOperation> intOps;
    private final Function<? super Publisher<Object>, ? extends CompletionStage<R>> transformer;

    CacheStreamIntermediateReducer(Queue<IntermediateOperation> intOps, Function<? super Publisher<Object>, ? extends CompletionStage<R>> transformer) {
        this.intOps = intOps;
        this.transformer = transformer;
    }

    @ProtoFactory
    CacheStreamIntermediateReducer(MarshallableDeque<IntermediateOperation> intermediateOperations, MarshallableObject<Function<? super Publisher<Object>, ? extends CompletionStage<R>>> transformer) {
        this.intOps = MarshallableDeque.unwrap(intermediateOperations);
        this.transformer = MarshallableObject.unwrap(transformer);
    }

    @ProtoField(value=1)
    MarshallableDeque<IntermediateOperation> getIntermediateOperations() {
        return MarshallableDeque.create(this.intOps);
    }

    @ProtoField(value=2)
    MarshallableObject<Function<? super Publisher<Object>, ? extends CompletionStage<R>>> getTransformer() {
        return MarshallableObject.create(this.transformer);
    }

    @Override
    public CompletionStage<R> apply(Publisher<Object> objectPublisher) {
        Flowable innerPublisher = Flowable.fromPublisher(objectPublisher);
        for (IntermediateOperation intOp : this.intOps) {
            innerPublisher = intOp.mapFlowable(innerPublisher);
        }
        return this.transformer.apply((Publisher<Object>)innerPublisher);
    }

    @Override
    public void inject(ComponentRegistry registry) {
        for (IntermediateOperation intOp : this.intOps) {
            intOp.handleInjection(registry);
        }
    }
}

