/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.List;
import java.util.Set;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.marshall.protostream.impl.MarshallableList;
import org.infinispan.marshall.protostream.impl.MarshallableSet;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.transaction.xa.GlobalTransaction;

@ProtoTypeId(value=1215)
public class TransactionInfo {
    private final GlobalTransaction globalTransaction;
    private final List<WriteCommand> modifications;
    private final Set<Object> lockedKeys;
    private final int topologyId;

    @ProtoFactory
    TransactionInfo(GlobalTransaction globalTransaction, int topologyId, MarshallableList<WriteCommand> wrappedModifications, MarshallableSet<Object> wrappedKeys) {
        this(globalTransaction, topologyId, MarshallableList.unwrap(wrappedModifications), MarshallableSet.unwrap(wrappedKeys));
    }

    public TransactionInfo(GlobalTransaction globalTransaction, int topologyId, List<WriteCommand> modifications, Set<Object> lockedKeys) {
        this.globalTransaction = globalTransaction;
        this.topologyId = topologyId;
        this.modifications = modifications;
        this.lockedKeys = lockedKeys;
    }

    @ProtoField(value=1)
    public GlobalTransaction getGlobalTransaction() {
        return this.globalTransaction;
    }

    public List<WriteCommand> getModifications() {
        return this.modifications;
    }

    @ProtoField(value=2)
    MarshallableList<WriteCommand> getWrappedModifications() {
        return MarshallableList.create(this.modifications);
    }

    public Set<Object> getLockedKeys() {
        return this.lockedKeys;
    }

    @ProtoField(value=3)
    MarshallableSet<Object> getWrappedKeys() {
        return MarshallableSet.create(this.lockedKeys);
    }

    @ProtoField(value=4)
    public int getTopologyId() {
        return this.topologyId;
    }

    public String toString() {
        return "TransactionInfo{globalTransaction=" + String.valueOf(this.globalTransaction) + ", topologyId=" + this.topologyId + ", modifications=" + String.valueOf(this.modifications) + ", lockedKeys=" + String.valueOf(this.lockedKeys) + "}";
    }
}

