/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.sql.DataSource;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.TracedCommand;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.IllegalLifecycleStateException;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.io.ByteBufferImpl;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.FileLookup;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.TransportConfiguration;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.CacheManagerJmxRegistration;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.inboundhandler.InboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.Reply;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.responses.ValidResponse;
import org.infinispan.remoting.rpc.ResponseFilter;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.transport.AbstractRequest;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.ValidResponseCollector;
import org.infinispan.remoting.transport.XSiteResponse;
import org.infinispan.remoting.transport.impl.EmptyRaftManager;
import org.infinispan.remoting.transport.impl.FilterMapResponseCollector;
import org.infinispan.remoting.transport.impl.MapResponseCollector;
import org.infinispan.remoting.transport.impl.MultiTargetRequest;
import org.infinispan.remoting.transport.impl.RequestRepository;
import org.infinispan.remoting.transport.impl.SingleResponseCollector;
import org.infinispan.remoting.transport.impl.SingleTargetRequest;
import org.infinispan.remoting.transport.impl.SingletonMapResponseCollector;
import org.infinispan.remoting.transport.impl.SiteUnreachableXSiteResponse;
import org.infinispan.remoting.transport.impl.XSiteResponseImpl;
import org.infinispan.remoting.transport.jgroups.ClusterView;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.infinispan.remoting.transport.jgroups.JGroupsAddressCache;
import org.infinispan.remoting.transport.jgroups.JGroupsChannelConfigurator;
import org.infinispan.remoting.transport.jgroups.JGroupsMetricsManager;
import org.infinispan.remoting.transport.jgroups.JGroupsRaftManager;
import org.infinispan.remoting.transport.jgroups.JGroupsTopologyAwareAddress;
import org.infinispan.remoting.transport.jgroups.NamedSocketFactory;
import org.infinispan.remoting.transport.jgroups.RaftUtil;
import org.infinispan.remoting.transport.jgroups.SingleSiteRequest;
import org.infinispan.remoting.transport.jgroups.StaggeredRequest;
import org.infinispan.remoting.transport.jgroups.ThreadPoolProbeHandler;
import org.infinispan.remoting.transport.raft.RaftManager;
import org.infinispan.telemetry.InfinispanSpan;
import org.infinispan.telemetry.InfinispanSpanAttributes;
import org.infinispan.telemetry.InfinispanTelemetry;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.XSiteBackup;
import org.infinispan.xsite.commands.remote.XSiteRequest;
import org.jgroups.BytesMessage;
import org.jgroups.ChannelListener;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.JChannel;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.UpHandler;
import org.jgroups.View;
import org.jgroups.blocks.RequestCorrelator;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.fork.ForkChannel;
import org.jgroups.jmx.JmxConfigurator;
import org.jgroups.protocols.FORK;
import org.jgroups.protocols.relay.RELAY;
import org.jgroups.protocols.relay.RELAY2;
import org.jgroups.protocols.relay.RouteStatusListener;
import org.jgroups.protocols.relay.SiteAddress;
import org.jgroups.protocols.relay.SiteMaster;
import org.jgroups.stack.AddressGenerator;
import org.jgroups.stack.DiagnosticsHandler;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.util.ExtendedUUID;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.SocketFactory;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;

@Scope(value=Scopes.GLOBAL)
public class JGroupsTransport
implements Transport {
    public static final String CONFIGURATION_STRING = "configurationString";
    public static final String CONFIGURATION_XML = "configurationXml";
    public static final String CONFIGURATION_FILE = "configurationFile";
    public static final String CHANNEL_CONFIGURATOR = "channelConfigurator";
    public static final String SOCKET_FACTORY = "socketFactory";
    public static final String DATA_SOURCE = "dataSource";
    public static final short REQUEST_FLAGS_UNORDERED = (short)(Message.Flag.OOB.value() | Message.Flag.NO_TOTAL_ORDER.value());
    public static final short REQUEST_FLAGS_UNORDERED_NO_FC = (short)(REQUEST_FLAGS_UNORDERED | Message.Flag.NO_FC.value());
    public static final short REQUEST_FLAGS_PER_SENDER = Message.Flag.NO_TOTAL_ORDER.value();
    public static final short REQUEST_FLAGS_PER_SENDER_NO_FC = (short)(REQUEST_FLAGS_PER_SENDER | Message.Flag.NO_FC.value());
    public static final short REPLY_FLAGS = (short)(Message.Flag.NO_FC.value() | Message.Flag.OOB.value() | Message.Flag.NO_TOTAL_ORDER.value());
    protected static final String DEFAULT_JGROUPS_CONFIGURATION_FILE = "default-configs/default-jgroups-udp.xml";
    public static final Log log = LogFactory.getLog(JGroupsTransport.class);
    private static final CompletableFuture<Map<Address, Response>> EMPTY_RESPONSES_FUTURE = CompletableFuture.completedFuture(Collections.emptyMap());
    private static final short CORRELATOR_ID = 0;
    private static final short HEADER_ID = ClassConfigurator.getProtocolId(RequestCorrelator.class);
    private static final byte REQUEST = 0;
    private static final byte RESPONSE = 1;
    private static final byte SINGLE_MESSAGE = 2;
    private static final byte EMPTY_MESSAGE_BYTE = 0;
    private static final ByteBuffer EMPTY_MESSAGE_BUFFER = ByteBufferImpl.create((byte[])new byte[]{0});
    @Inject
    protected GlobalConfiguration configuration;
    @Inject
    @ComponentName(value="org.infinispan.marshaller.internal")
    protected Marshaller marshaller;
    @Inject
    protected CacheManagerNotifier notifier;
    @Inject
    protected TimeService timeService;
    @Inject
    protected InboundInvocationHandler invocationHandler;
    @Inject
    @ComponentName(value="org.infinispan.executors.timeout")
    protected ScheduledExecutorService timeoutExecutor;
    @Inject
    @ComponentName(value="org.infinispan.executors.non-blocking")
    protected ExecutorService nonBlockingExecutor;
    @Inject
    protected CacheManagerJmxRegistration jmxRegistration;
    @Inject
    protected JGroupsMetricsManager metricsManager;
    @Inject
    InfinispanTelemetry telemetry;
    private final Lock viewUpdateLock = new ReentrantLock();
    private final Condition viewUpdateCondition = this.viewUpdateLock.newCondition();
    private final ThreadPoolProbeHandler probeHandler;
    private final ChannelCallbacks channelCallbacks = new ChannelCallbacks();
    protected TypedProperties props;
    protected JChannel channel;
    protected Address address;
    protected Address physicalAddress;
    protected volatile ClusterView clusterView = new ClusterView(-1, Collections.emptyList(), null);
    private CompletableFuture<Void> nextViewFuture = new CompletableFuture();
    private RequestRepository requests;
    private final Map<String, SiteUnreachableReason> unreachableSites;
    private String localSite;
    private volatile RaftManager raftManager = EmptyRaftManager.INSTANCE;
    private boolean running;

    public static FORK findFork(JChannel channel) {
        return (FORK)channel.getProtocolStack().findProtocol(FORK.class);
    }

    public JGroupsTransport(JChannel channel) {
        this();
        this.channel = channel;
        if (channel == null) {
            throw new IllegalArgumentException("Cannot deal with a null channel!");
        }
        if (channel.isConnected()) {
            throw new IllegalArgumentException("Channel passed in cannot already be connected!");
        }
    }

    public JGroupsTransport() {
        this.probeHandler = new ThreadPoolProbeHandler();
        this.unreachableSites = new ConcurrentHashMap<String, SiteUnreachableReason>();
    }

    @Override
    public CompletableFuture<Map<Address, Response>> invokeRemotelyAsync(Collection<Address> recipients, ReplicableCommand command, ResponseMode mode, long timeout, ResponseFilter responseFilter, DeliverOrder deliverOrder, boolean anycast) {
        boolean broadcast;
        if (recipients != null && recipients.isEmpty()) {
            log.tracef("Destination list is empty: no need to send command %s", command);
            return EMPTY_RESPONSES_FUTURE;
        }
        ClusterView view = this.clusterView;
        List<Address> localMembers = view.getMembers();
        int membersSize = localMembers.size();
        boolean ignoreLeavers = mode == ResponseMode.SYNCHRONOUS_IGNORE_LEAVERS || mode == ResponseMode.WAIT_FOR_VALID_RESPONSE;
        boolean sendStaggeredRequest = mode == ResponseMode.WAIT_FOR_VALID_RESPONSE && deliverOrder == DeliverOrder.NONE && recipients != null && recipients.size() > 1 && timeout > 0L;
        boolean bl = broadcast = recipients == null;
        if (recipients == null && membersSize == 1) {
            log.tracef("The cluster has a single node: no need to broadcast command %s", command);
            return EMPTY_RESPONSES_FUTURE;
        }
        Address singleTarget = this.computeSingleTarget(recipients, localMembers, membersSize, broadcast);
        if (this.address.equals(singleTarget)) {
            log.tracef("Skipping request to self for command %s", command);
            return EMPTY_RESPONSES_FUTURE;
        }
        if (mode.isAsynchronous()) {
            return this.performAsyncRemoteInvocation(recipients, command, deliverOrder, broadcast, singleTarget);
        }
        Collection<Address> actualTargets = broadcast ? localMembers : recipients;
        return this.performSyncRemoteInvocation(actualTargets, command, mode, timeout, responseFilter, deliverOrder, ignoreLeavers, sendStaggeredRequest, broadcast, singleTarget);
    }

    @Override
    public void sendTo(Address destination, ReplicableCommand command, DeliverOrder deliverOrder) {
        if (destination.equals(this.address)) {
            if (log.isTraceEnabled()) {
                log.tracef("%s not sending command to self: %s", this.address, command);
            }
            return;
        }
        this.logCommand(command, destination);
        this.sendCommand(destination, command, 0L, deliverOrder, true, true);
    }

    @Override
    public void sendToMany(Collection<Address> targets, ReplicableCommand command, DeliverOrder deliverOrder) {
        if (targets == null) {
            this.logCommand(command, "all");
            this.sendCommandToAll(command, 0L, deliverOrder);
        } else {
            this.logCommand(command, targets);
            this.sendCommand(targets, command, 0L, deliverOrder, true);
        }
    }

    @Override
    public <O> XSiteResponse<O> backupRemotely(XSiteBackup backup, XSiteRequest<O> rpcCommand) {
        assert (!this.localSite.equals(backup.getSiteName())) : "sending to local site";
        if (this.unreachableSites.containsKey(backup.getSiteName())) {
            return new SiteUnreachableXSiteResponse(backup, this.timeService);
        }
        Address recipient = JGroupsAddressCache.fromJGroupsAddress((org.jgroups.Address)new SiteMaster(backup.getSiteName()));
        long requestId = this.requests.newRequestId();
        this.logRequest(requestId, rpcCommand, recipient, "backup");
        SingleSiteRequest<ValidResponse> request = new SingleSiteRequest<ValidResponse>(SingleResponseCollector.validOnly(), requestId, this.requests, backup.getSiteName());
        this.addRequest(request);
        DeliverOrder order = backup.isSync() ? DeliverOrder.NONE : DeliverOrder.PER_SENDER;
        long timeout = backup.getTimeout();
        XSiteResponseImpl xSiteResponse = new XSiteResponseImpl(this.timeService, backup);
        try {
            this.traceRequest(request, rpcCommand);
            this.sendCommand(recipient, rpcCommand, request.getRequestId(), order, false, false);
            if (timeout > 0L) {
                request.setTimeout(this.timeoutExecutor, timeout, TimeUnit.MILLISECONDS);
            }
            request.whenComplete((BiConsumer)xSiteResponse);
        }
        catch (Throwable t) {
            request.cancel(true);
            xSiteResponse.completeExceptionally(t);
        }
        return xSiteResponse;
    }

    @Override
    public boolean isCoordinator() {
        return this.clusterView.isCoordinator();
    }

    @Override
    public Address getCoordinator() {
        return this.clusterView.getCoordinator();
    }

    @Override
    public Address getAddress() {
        return this.address;
    }

    @Override
    public List<Address> getPhysicalAddresses() {
        if (this.physicalAddress == null && this.channel != null) {
            Optional<org.jgroups.Address> addr = this.findPhysicalAddress(this.channel.getAddress());
            if (addr.isEmpty()) {
                return Collections.emptyList();
            }
            this.physicalAddress = new JGroupsAddress(addr.get());
        }
        return Collections.singletonList(this.physicalAddress);
    }

    @Override
    public List<Address> getMembers() {
        return this.clusterView.getMembers();
    }

    @Override
    public List<Address> getMembersPhysicalAddresses() {
        if (this.channel == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(this.channel.getView().getMembersRaw()).map(this::findPhysicalAddress).filter(Optional::isPresent).map(Optional::get).map(JGroupsAddress::new).collect(Collectors.toList());
    }

    @Override
    public boolean isMulticastCapable() {
        return this.channel.getProtocolStack().getTransport().supportsMulticasting();
    }

    @Override
    public void checkCrossSiteAvailable() throws CacheConfigurationException {
        if (this.localSite == null) {
            throw Log.CLUSTER.crossSiteUnavailable();
        }
    }

    @Override
    public String localSiteName() {
        return this.localSite;
    }

    @Override
    public String localNodeName() {
        if (this.channel == null) {
            return Transport.super.localNodeName();
        }
        return this.channel.getName();
    }

    @Override
    @Start
    public void start() {
        if (this.running) {
            throw new IllegalStateException("Two or more cache managers are using the same JGroupsTransport instance");
        }
        this.probeHandler.updateThreadPool(this.nonBlockingExecutor);
        this.props = TypedProperties.toTypedProperties((Map)this.configuration.transport().properties());
        this.requests = new RequestRepository();
        this.initChannel();
        this.channel.setUpHandler((UpHandler)this.channelCallbacks);
        this.setXSiteViewListener(this.channelCallbacks);
        this.startJGroupsChannelIfNeeded();
        this.waitForInitialNodes();
        this.channel.getProtocolStack().getTransport().registerProbeHandler((DiagnosticsHandler.ProbeHandler)this.probeHandler);
        this.localSite = this.findRelay2().map(RELAY::site).orElse(null);
        this.running = true;
    }

    protected void initChannel() {
        TransportConfiguration transportCfg = this.configuration.transport();
        if (this.channel == null) {
            this.buildChannel();
            String transportNodeName = transportCfg.nodeName();
            if (transportNodeName != null && !transportNodeName.isEmpty()) {
                this.channel.setName(transportNodeName);
            }
        }
        this.channel.addChannelListener((ChannelListener)this.channelCallbacks);
        this.channel.setDiscardOwnMessages(false);
        if (transportCfg.hasTopologyInfo()) {
            this.channel.addAddressGenerator((AddressGenerator)this.channelCallbacks);
        }
        this.initRaftManager();
    }

    private void initRaftManager() {
        TransportConfiguration transportCfg = this.configuration.transport();
        if (RaftUtil.isRaftAvailable()) {
            if (transportCfg.nodeName() == null || transportCfg.nodeName().isEmpty()) {
                log.raftProtocolUnavailable("transport.node-name is not set.");
                return;
            }
            if (transportCfg.raftMembers().isEmpty()) {
                log.raftProtocolUnavailable("transport.raft-members is not set.");
                return;
            }
            byte[] key = Util.stringToBytes((String)"raft-id");
            byte[] value = Util.stringToBytes((String)transportCfg.nodeName());
            this.channel.addAddressGenerator(() -> ExtendedUUID.randomUUID((String)this.channel.getName()).put(key, value));
            this.insertForkIfMissing();
            this.raftManager = new JGroupsRaftManager(this.configuration, this.channel);
            this.raftManager.start();
            log.raftProtocolAvailable();
        }
    }

    private void insertForkIfMissing() {
        if (JGroupsTransport.findFork(this.channel) != null) {
            return;
        }
        ProtocolStack protocolStack = this.channel.getProtocolStack();
        Optional<RELAY2> relay2 = this.findRelay2();
        if (relay2.isPresent()) {
            protocolStack.insertProtocolInStack((Protocol)new FORK(), (Protocol)relay2.get(), ProtocolStack.Position.BELOW);
        } else {
            protocolStack.addProtocol((Protocol)new FORK());
        }
    }

    private void setXSiteViewListener(RouteStatusListener listener) {
        this.findRelay2().ifPresent(relay2 -> {
            relay2.setRouteStatusListener(listener);
            Set<String> view = this.getSitesView();
            if (view != null && !view.isEmpty()) {
                Log.XSITE.receivedXSiteClusterView(view);
            }
        });
    }

    protected void startJGroupsChannelIfNeeded() {
        String stack;
        String clusterName = this.configuration.transport().clusterName();
        if (log.isDebugEnabled()) {
            log.debugf("JGroups protocol stack: %s\n", this.channel.getProtocolStack().printProtocolSpec(true));
        }
        if ((stack = this.configuration.transport().stack()) != null) {
            Log.CLUSTER.startingJGroupsChannel(clusterName, stack);
        } else if (!(this.channel instanceof ForkChannel)) {
            Log.CLUSTER.startingJGroupsChannel(clusterName);
        }
        try {
            this.channel.connect(clusterName);
        }
        catch (Exception e) {
            throw new CacheException("Unable to start JGroups Channel", (Throwable)e);
        }
        this.receiveClusterView(this.channel.getView(), true);
        this.registerMBeansIfNeeded(clusterName);
        if (!(this.channel instanceof ForkChannel)) {
            Log.CLUSTER.localAndPhysicalAddress(clusterName, this.getAddress(), this.getPhysicalAddresses());
        }
        this.telemetry.setNodeName(String.valueOf(this.channel.getAddress()));
    }

    private void registerMBeansIfNeeded(String clusterName) {
        try {
            if (this.jmxRegistration.enabled()) {
                ObjectName namePrefix = new ObjectName(this.jmxRegistration.getDomain() + ":manager=" + ObjectName.quote(this.configuration.cacheManagerName()));
                JmxConfigurator.registerChannel((JChannel)this.channel, (MBeanServer)this.jmxRegistration.getMBeanServer(), (ObjectName)namePrefix, (String)clusterName, (boolean)true);
            }
        }
        catch (Exception e) {
            throw new CacheException("Channel connected, but unable to register MBeans", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForInitialNodes() {
        int initialClusterSize = this.configuration.transport().initialClusterSize();
        if (initialClusterSize <= 1) {
            return;
        }
        long timeout = this.configuration.transport().initialClusterTimeout();
        long remainingNanos = TimeUnit.MILLISECONDS.toNanos(timeout);
        this.viewUpdateLock.lock();
        try {
            while (this.channel != null && this.channel.getView().getMembers().size() < initialClusterSize && remainingNanos > 0L) {
                log.debugf("Waiting for %d nodes, current view has %d", initialClusterSize, this.channel.getView().getMembers().size());
                remainingNanos = this.viewUpdateCondition.awaitNanos(remainingNanos);
            }
        }
        catch (InterruptedException e) {
            Log.CLUSTER.interruptedWaitingForCoordinator(e);
            Thread.currentThread().interrupt();
        }
        finally {
            this.viewUpdateLock.unlock();
        }
        if (remainingNanos <= 0L) {
            throw Log.CLUSTER.timeoutWaitingForInitialNodes(initialClusterSize, this.channel.getView().getMembers());
        }
        log.debugf("Initial cluster size of %d nodes reached", initialClusterSize);
    }

    private void buildChannel() {
        FileLookup fileLookup = FileLookupFactory.newInstance();
        if (this.props != null) {
            String cfg;
            if (this.channel == null && this.props.containsKey((Object)CHANNEL_CONFIGURATOR)) {
                this.channelFromConfigurator((JGroupsChannelConfigurator)this.props.get((Object)CHANNEL_CONFIGURATOR));
            }
            if (this.channel == null && this.props.containsKey((Object)CONFIGURATION_FILE)) {
                cfg = this.props.getProperty(CONFIGURATION_FILE);
                Collection<Object> confs = Collections.emptyList();
                try {
                    confs = fileLookup.lookupFileLocations(cfg, this.configuration.classLoader());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (confs.isEmpty()) {
                    throw Log.CLUSTER.jgroupsConfigurationNotFound(cfg);
                }
                if (confs.size() > 1) {
                    Log.CLUSTER.ambiguousConfigurationFiles(org.infinispan.commons.util.Util.toStr(confs));
                }
                try {
                    URL url = (URL)confs.iterator().next();
                    this.channel = new JChannel(url.openStream());
                }
                catch (Exception e) {
                    throw Log.CLUSTER.errorCreatingChannelFromConfigFile(cfg, e);
                }
            }
            if (this.channel == null && this.props.containsKey((Object)CONFIGURATION_XML)) {
                cfg = this.props.getProperty(CONFIGURATION_XML);
                try {
                    this.channel = new JChannel((InputStream)new ByteArrayInputStream(cfg.getBytes()));
                }
                catch (Exception e) {
                    throw Log.CLUSTER.errorCreatingChannelFromXML(cfg, e);
                }
            }
            if (this.channel == null && this.props.containsKey((Object)CONFIGURATION_STRING)) {
                cfg = this.props.getProperty(CONFIGURATION_STRING);
                try {
                    this.channel = new JChannel((InputStream)new ByteArrayInputStream(cfg.getBytes()));
                }
                catch (Exception e) {
                    throw Log.CLUSTER.errorCreatingChannelFromConfigString(cfg, e);
                }
            }
            if (this.channel == null && this.configuration.transport().stack() != null) {
                this.channelFromConfigurator(this.configuration.transport().jgroups().configurator(this.configuration.transport().stack()));
            }
        }
        if (this.channel == null) {
            Log.CLUSTER.unableToUseJGroupsPropertiesProvided(this.props);
            try (InputStream is = fileLookup.lookupFileLocation(DEFAULT_JGROUPS_CONFIGURATION_FILE, this.configuration.classLoader()).openStream();){
                this.channel = new JChannel(is);
            }
            catch (Exception e) {
                throw Log.CLUSTER.errorCreatingChannelFromConfigFile(DEFAULT_JGROUPS_CONFIGURATION_FILE, e);
            }
        }
        if (this.props != null && this.props.containsKey((Object)SOCKET_FACTORY) && !this.props.containsKey((Object)CHANNEL_CONFIGURATOR)) {
            Protocol protocol = this.channel.getProtocolStack().getTopProtocol();
            protocol.setSocketFactory((SocketFactory)this.props.get((Object)SOCKET_FACTORY));
        }
    }

    private void channelFromConfigurator(JGroupsChannelConfigurator configurator) {
        if (this.props.containsKey((Object)SOCKET_FACTORY)) {
            SocketFactory socketFactory = (SocketFactory)this.props.get((Object)SOCKET_FACTORY);
            if (socketFactory instanceof NamedSocketFactory) {
                ((NamedSocketFactory)socketFactory).setName(this.configuration.transport().clusterName());
            }
            configurator.setSocketFactory(socketFactory);
        }
        if (this.props.containsKey((Object)DATA_SOURCE)) {
            Supplier dataSourceSupplier = (Supplier)this.props.get((Object)DATA_SOURCE);
            configurator.setDataSource((DataSource)dataSourceSupplier.get());
        }
        try {
            this.channel = configurator.createChannel(this.configuration.transport().clusterName());
        }
        catch (Exception e) {
            throw Log.CLUSTER.errorCreatingChannelFromConfigurator(configurator.getName(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveClusterView(View newView, boolean installIfFirst) {
        boolean hasNotifier;
        List<List<Address>> subGroups;
        if (this.address == null) {
            org.jgroups.Address jgroupsAddress = this.channel.getAddress();
            this.address = JGroupsAddressCache.fromJGroupsAddress(jgroupsAddress);
            if (log.isTraceEnabled()) {
                String uuid = jgroupsAddress instanceof UUID ? ((UUID)jgroupsAddress).toStringLong() : "N/A";
                log.tracef("Local address %s, uuid %s", jgroupsAddress, uuid);
            }
        }
        if (installIfFirst && this.clusterView.getViewId() != -1) {
            return;
        }
        if (newView instanceof MergeView) {
            if (!(this.channel instanceof ForkChannel)) {
                Log.CLUSTER.receivedMergedView(this.channel.clusterName(), newView);
            }
            subGroups = new ArrayList();
            List jgroupsSubGroups = ((MergeView)newView).getSubgroups();
            for (View group : jgroupsSubGroups) {
                subGroups.add(JGroupsTransport.fromJGroupsAddressList(group.getMembers()));
            }
        } else {
            if (!(this.channel instanceof ForkChannel)) {
                Log.CLUSTER.receivedClusterView(this.channel.clusterName(), newView);
            }
            subGroups = Collections.emptyList();
        }
        long viewId = newView.getViewId().getId();
        List<Address> members = JGroupsTransport.fromJGroupsAddressList(newView.getMembers());
        if (members.isEmpty()) {
            return;
        }
        ClusterView oldView = this.clusterView;
        CompletableFuture<Void> oldFuture = null;
        this.viewUpdateLock.lock();
        try {
            if (log.isDebugEnabled() && oldView.getMembers() != null) {
                ArrayList<Address> joined = new ArrayList<Address>(members);
                joined.removeAll(oldView.getMembers());
                ArrayList<Address> left = new ArrayList<Address>(oldView.getMembers());
                left.removeAll(members);
                log.debugf("Joined: %s, Left: %s", joined, left);
            }
            this.clusterView = new ClusterView((int)viewId, members, this.address);
            oldFuture = this.nextViewFuture;
            this.nextViewFuture = new CompletableFuture();
            this.viewUpdateCondition.signalAll();
        }
        finally {
            this.viewUpdateLock.unlock();
            if (oldFuture != null) {
                CompletableFuture<Void> future = oldFuture;
                this.nonBlockingExecutor.execute(() -> future.complete(null));
            }
        }
        boolean bl = hasNotifier = this.notifier != null;
        if (hasNotifier) {
            if (!subGroups.isEmpty()) {
                Address address1 = this.getAddress();
                CompletionStages.join(this.notifier.notifyMerge(members, oldView.getMembers(), address1, (int)viewId, subGroups));
            } else {
                CompletionStages.join(this.notifier.notifyViewChange(members, oldView.getMembers(), this.getAddress(), (int)viewId));
            }
        }
        this.nonBlockingExecutor.execute(() -> {
            if (this.requests != null) {
                this.requests.forEach(request -> request.onNewView(this.clusterView.getMembersSet()));
            }
        });
        JGroupsAddressCache.pruneAddressCache();
    }

    private static List<Address> fromJGroupsAddressList(List<org.jgroups.Address> list) {
        return list.stream().map(JGroupsAddressCache::fromJGroupsAddress).toList();
    }

    @Override
    @Stop
    public void stop() {
        this.running = false;
        if (this.channel != null) {
            this.channel.getProtocolStack().getTransport().unregisterProbeHandler((DiagnosticsHandler.ProbeHandler)this.probeHandler);
        }
        this.raftManager.stop();
        String clusterName = this.configuration.transport().clusterName();
        try {
            if (this.channel != null && this.channel.isConnected()) {
                if (!(this.channel instanceof ForkChannel)) {
                    Log.CLUSTER.disconnectJGroups(clusterName);
                }
                this.channel.disconnect();
            }
            if (this.channel != null && this.channel.isOpen()) {
                this.channel.close();
            }
            this.unregisterMBeansIfNeeded(clusterName);
        }
        catch (Exception toLog) {
            Log.CLUSTER.problemClosingChannel(toLog, clusterName);
        }
        if (this.requests != null) {
            this.requests.forEach(request -> request.cancel((Exception)((Object)Log.CONTAINER.cacheManagerIsStopping())));
        }
        this.channel = null;
        this.clusterView = new ClusterView(Integer.MAX_VALUE, Collections.emptyList(), null);
        CompletableFuture<Void> oldFuture = null;
        this.viewUpdateLock.lock();
        try {
            oldFuture = this.nextViewFuture;
            this.nextViewFuture = new CompletableFuture();
            this.viewUpdateCondition.signalAll();
        }
        finally {
            this.viewUpdateLock.unlock();
            if (oldFuture != null) {
                oldFuture.complete(null);
            }
        }
    }

    private void unregisterMBeansIfNeeded(String clusterName) throws Exception {
        if (this.jmxRegistration.enabled() && this.channel != null) {
            ObjectName namePrefix = new ObjectName(this.jmxRegistration.getDomain() + ":manager=" + ObjectName.quote(this.configuration.cacheManagerName()));
            JmxConfigurator.unregisterChannel((JChannel)this.channel, (MBeanServer)this.jmxRegistration.getMBeanServer(), (ObjectName)namePrefix, (String)clusterName);
        }
    }

    @Override
    public int getViewId() {
        if (this.channel == null) {
            throw new IllegalLifecycleStateException("The cache has been stopped and invocations are not allowed!");
        }
        return this.clusterView.getViewId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> withView(int expectedViewId) {
        ClusterView view = this.clusterView;
        if (view.isViewIdAtLeast(expectedViewId)) {
            return CompletableFutures.completedNull();
        }
        if (log.isTraceEnabled()) {
            log.tracef("Waiting for view %d, current view is %d", expectedViewId, view.getViewId());
        }
        this.viewUpdateLock.lock();
        try {
            view = this.clusterView;
            if (view.isViewIdAtLeast(Integer.MAX_VALUE)) {
                throw new IllegalLifecycleStateException();
            }
            if (view.isViewIdAtLeast(expectedViewId)) {
                CompletableFuture completableFuture = CompletableFutures.completedNull();
                return completableFuture;
            }
            CompletionStage completionStage = this.nextViewFuture.thenCompose(nil -> this.withView(expectedViewId));
            return completionStage;
        }
        finally {
            this.viewUpdateLock.unlock();
        }
    }

    @Override
    public Log getLog() {
        return log;
    }

    @Override
    public Set<String> getSitesView() {
        Optional<List> sites = this.findRelay2().map(RELAY::getCurrentSites);
        return sites.isEmpty() ? Collections.emptySet() : new TreeSet(sites.get());
    }

    @Override
    public boolean isSiteCoordinator() {
        return this.findRelay2().map(RELAY::isSiteMaster).orElse(false);
    }

    @Override
    public Collection<Address> getRelayNodesAddress() {
        return this.findRelay2().map(RELAY::siteMasters).map(addresses -> addresses.stream().map(JGroupsAddressCache::fromJGroupsAddress).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    @Override
    public boolean isPrimaryRelayNode() {
        return this.findRelay2().map(RELAY::siteMasters).flatMap(c -> c.stream().findFirst()).map(a -> Objects.equals(a, this.channel.getAddress())).orElse(false);
    }

    @Override
    public <T> CompletionStage<T> invokeCommand(Address target, ReplicableCommand command, ResponseCollector<T> collector, DeliverOrder deliverOrder, long timeout, TimeUnit unit) {
        if (target.equals(this.address)) {
            return CompletableFuture.completedFuture(collector.finish());
        }
        long requestId = this.requests.newRequestId();
        this.logRequest(requestId, command, target, "single");
        SingleTargetRequest<T> request = new SingleTargetRequest<T>(collector, requestId, this.requests, this.metricsManager.trackRequest(target));
        this.addRequest(request);
        if (!request.onNewView(this.clusterView.getMembersSet())) {
            this.traceRequest(request, command);
            this.sendCommand(target, command, requestId, deliverOrder, true, false);
        }
        if (timeout > 0L) {
            request.setTimeout(this.timeoutExecutor, timeout, unit);
        }
        return request;
    }

    @Override
    public <T> CompletionStage<T> invokeCommand(Collection<Address> targets, ReplicableCommand command, ResponseCollector<T> collector, DeliverOrder deliverOrder, long timeout, TimeUnit unit) {
        long requestId = this.requests.newRequestId();
        this.logRequest(requestId, command, targets, "multi");
        if (targets.isEmpty()) {
            return CompletableFuture.completedFuture(collector.finish());
        }
        Address excludedTarget = this.getAddress();
        MultiTargetRequest<T> request = new MultiTargetRequest<T>(collector, requestId, this.requests, targets, excludedTarget, this.metricsManager);
        if (request.isDone()) {
            return request;
        }
        try {
            this.addRequest(request);
            this.traceRequest(request, command);
            boolean checkView = request.onNewView(this.clusterView.getMembersSet());
            this.sendCommand(targets, command, requestId, deliverOrder, checkView);
        }
        catch (Throwable t) {
            request.cancel(true);
            throw t;
        }
        if (timeout > 0L) {
            request.setTimeout(this.timeoutExecutor, timeout, unit);
        }
        return request;
    }

    @Override
    public <T> CompletionStage<T> invokeCommandOnAll(ReplicableCommand command, ResponseCollector<T> collector, DeliverOrder deliverOrder, long timeout, TimeUnit unit) {
        long requestId = this.requests.newRequestId();
        this.logRequest(requestId, command, null, "broadcast");
        Address excludedTarget = this.getAddress();
        MultiTargetRequest<T> request = new MultiTargetRequest<T>(collector, requestId, this.requests, this.clusterView.getMembers(), excludedTarget, this.metricsManager);
        if (request.isDone()) {
            return request;
        }
        try {
            this.addRequest(request);
            this.traceRequest(request, command);
            request.onNewView(this.clusterView.getMembersSet());
            this.sendCommandToAll(command, requestId, deliverOrder);
        }
        catch (Throwable t) {
            request.cancel(true);
            throw t;
        }
        if (timeout > 0L) {
            request.setTimeout(this.timeoutExecutor, timeout, unit);
        }
        return request;
    }

    @Override
    public <T> CompletionStage<T> invokeCommandOnAll(Collection<Address> requiredTargets, ReplicableCommand command, ResponseCollector<T> collector, DeliverOrder deliverOrder, long timeout, TimeUnit unit) {
        long requestId = this.requests.newRequestId();
        this.logRequest(requestId, command, requiredTargets, "broadcast");
        Address excludedTarget = this.getAddress();
        MultiTargetRequest<T> request = new MultiTargetRequest<T>(collector, requestId, this.requests, requiredTargets, excludedTarget, this.metricsManager);
        if (request.isDone()) {
            return request;
        }
        try {
            this.addRequest(request);
            this.traceRequest(request, command);
            request.onNewView(this.clusterView.getMembersSet());
            this.sendCommandToAll(command, requestId, deliverOrder);
        }
        catch (Throwable t) {
            request.cancel(true);
            throw t;
        }
        if (timeout > 0L) {
            request.setTimeout(this.timeoutExecutor, timeout, unit);
        }
        return request;
    }

    @Override
    public <T> CompletionStage<T> invokeCommandStaggered(Collection<Address> targets, ReplicableCommand command, ResponseCollector<T> collector, DeliverOrder deliverOrder, long timeout, TimeUnit unit) {
        long requestId = this.requests.newRequestId();
        this.logRequest(requestId, command, targets, "staggered");
        StaggeredRequest<T> request = new StaggeredRequest<T>(collector, requestId, this.requests, targets, this.getAddress(), command, deliverOrder, timeout, unit, this);
        try {
            this.addRequest(request);
            this.traceRequest(request, command);
            request.onNewView(this.clusterView.getMembersSet());
            request.sendNextMessage();
        }
        catch (Throwable t) {
            request.cancel(true);
            throw t;
        }
        return request;
    }

    @Override
    public <T> CompletionStage<T> invokeCommands(Collection<Address> targets, Function<Address, ReplicableCommand> commandGenerator, ResponseCollector<T> collector, DeliverOrder deliverOrder, long timeout, TimeUnit timeUnit) {
        Address excludedTarget;
        long requestId = this.requests.newRequestId();
        MultiTargetRequest<T> request = new MultiTargetRequest<T>(collector, requestId, this.requests, targets, excludedTarget = this.getAddress(), this.metricsManager);
        if (request.isDone()) {
            return request;
        }
        this.addRequest(request);
        boolean checkView = request.onNewView(this.clusterView.getMembersSet());
        try {
            for (Address target : targets) {
                if (target.equals(excludedTarget)) continue;
                ReplicableCommand command = commandGenerator.apply(target);
                this.logRequest(requestId, command, target, "mixed");
                this.traceRequest(request, command);
                this.sendCommand(target, command, requestId, deliverOrder, true, checkView);
            }
        }
        catch (Throwable t) {
            request.cancel(true);
            throw t;
        }
        if (timeout > 0L) {
            request.setTimeout(this.timeoutExecutor, timeout, timeUnit);
        }
        return request;
    }

    @Override
    public RaftManager raftManager() {
        return this.raftManager;
    }

    private void addRequest(AbstractRequest<?> request) {
        try {
            this.requests.addRequest(request);
            if (!this.running) {
                request.cancel((Exception)((Object)Log.CONTAINER.cacheManagerIsStopping()));
            }
        }
        catch (Throwable t) {
            request.cancel(true);
            throw t;
        }
    }

    private void traceRequest(AbstractRequest<?> request, TracedCommand command) {
        InfinispanSpanAttributes traceSpan = command.getSpanAttributes();
        if (traceSpan != null) {
            InfinispanSpan span = this.telemetry.startTraceRequest(command.getOperationName(), traceSpan);
            request.whenComplete((BiConsumer)span);
        }
    }

    void sendCommand(Address target, Object command, long requestId, DeliverOrder deliverOrder, boolean noRelay, boolean checkView) {
        if (checkView && !this.clusterView.contains(target)) {
            return;
        }
        BytesMessage message = new BytesMessage(JGroupsTransport.toJGroupsAddress(target));
        this.marshallRequest((Message)message, command, requestId);
        JGroupsTransport.setMessageFlags((Message)message, deliverOrder, noRelay);
        this.send((Message)message);
        if (noRelay) {
            this.metricsManager.recordMessageSent(target, message.size(), requestId == 0L);
        }
    }

    private static org.jgroups.Address toJGroupsAddress(Address address) {
        return ((JGroupsAddress)address).getJGroupsAddress();
    }

    private void marshallRequest(Message message, Object command, long requestId) {
        try {
            ByteBuffer bytes = this.marshaller.objectToBuffer(command);
            message.setArray(bytes.getBuf(), bytes.getOffset(), bytes.getLength());
            JGroupsTransport.addRequestHeader(message, requestId);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Failure to marshal argument(s)", e);
        }
    }

    private static void setMessageFlags(Message message, DeliverOrder deliverOrder, boolean noRelay) {
        short flags = JGroupsTransport.encodeDeliverMode(deliverOrder);
        if (noRelay) {
            flags = (short)(flags | Message.Flag.NO_RELAY.value());
        }
        message.setFlag(flags, false);
        message.setFlag(new Message.TransientFlag[]{Message.TransientFlag.DONT_LOOPBACK});
    }

    private void send(Message message) {
        try {
            JChannel channel = this.channel;
            if (channel != null) {
                channel.send(message);
            }
        }
        catch (Exception e) {
            if (this.running) {
                throw new CacheException((Throwable)e);
            }
            throw Log.CONTAINER.cacheManagerIsStopping();
        }
    }

    private static void addRequestHeader(Message message, long requestId) {
        if (requestId != 0L) {
            RequestCorrelator.Header header = new RequestCorrelator.Header(0, requestId, 0);
            message.putHeader(HEADER_ID, (Header)header);
        }
    }

    private static short encodeDeliverMode(DeliverOrder deliverOrder) {
        return switch (deliverOrder) {
            default -> throw new IncompatibleClassChangeError();
            case DeliverOrder.PER_SENDER -> REQUEST_FLAGS_PER_SENDER;
            case DeliverOrder.PER_SENDER_NO_FC -> REQUEST_FLAGS_PER_SENDER_NO_FC;
            case DeliverOrder.NONE -> REQUEST_FLAGS_UNORDERED;
            case DeliverOrder.NONE_NO_FC -> REQUEST_FLAGS_UNORDERED_NO_FC;
        };
    }

    private Address computeSingleTarget(Collection<Address> targets, List<Address> localMembers, int membersSize, boolean broadcast) {
        Address singleTarget;
        if (broadcast) {
            singleTarget = null;
        } else if (targets == null) {
            assert (membersSize == 2);
            singleTarget = localMembers.get(0).equals(this.address) ? localMembers.get(1) : localMembers.get(0);
        } else {
            singleTarget = targets.size() == 1 ? targets.iterator().next() : null;
        }
        return singleTarget;
    }

    private CompletableFuture<Map<Address, Response>> performAsyncRemoteInvocation(Collection<Address> recipients, ReplicableCommand command, DeliverOrder deliverOrder, boolean broadcast, Address singleTarget) {
        if (broadcast) {
            this.logCommand(command, "all");
            this.sendCommandToAll(command, 0L, deliverOrder);
        } else if (singleTarget != null) {
            this.logCommand(command, singleTarget);
            this.sendCommand(singleTarget, command, 0L, deliverOrder, true, true);
        } else {
            this.logCommand(command, recipients);
            this.sendCommand(recipients, command, 0L, deliverOrder, true);
        }
        return EMPTY_RESPONSES_FUTURE;
    }

    private CompletableFuture<Map<Address, Response>> performSyncRemoteInvocation(Collection<Address> targets, ReplicableCommand command, ResponseMode mode, long timeout, ResponseFilter responseFilter, DeliverOrder deliverOrder, boolean ignoreLeavers, boolean sendStaggeredRequest, boolean broadcast, Address singleTarget) {
        CompletionStage<Map<Address, Response>> request;
        if (sendStaggeredRequest) {
            FilterMapResponseCollector collector = new FilterMapResponseCollector(responseFilter, false, targets.size());
            request = this.invokeCommandStaggered(targets, command, collector, deliverOrder, timeout, TimeUnit.MILLISECONDS);
        } else if (singleTarget != null) {
            SingletonMapResponseCollector collector = ignoreLeavers ? SingletonMapResponseCollector.ignoreLeavers() : SingletonMapResponseCollector.validOnly();
            request = this.invokeCommand(singleTarget, command, collector, deliverOrder, timeout, TimeUnit.MILLISECONDS);
        } else {
            ValidResponseCollector collector = mode == ResponseMode.WAIT_FOR_VALID_RESPONSE ? new FilterMapResponseCollector(responseFilter, false, targets.size()) : (responseFilter != null ? new FilterMapResponseCollector(responseFilter, true, targets.size()) : MapResponseCollector.ignoreLeavers(ignoreLeavers, targets.size()));
            request = broadcast ? this.invokeCommandOnAll(command, collector, deliverOrder, timeout, TimeUnit.MILLISECONDS) : this.invokeCommand(targets, command, collector, deliverOrder, timeout, TimeUnit.MILLISECONDS);
        }
        return request.toCompletableFuture();
    }

    @Override
    public void sendToAll(ReplicableCommand command, DeliverOrder deliverOrder) {
        this.logCommand(command, "all");
        this.sendCommandToAll(command, 0L, deliverOrder);
    }

    private void sendCommandToAll(ReplicableCommand command, long requestId, DeliverOrder deliverOrder) {
        BytesMessage message = new BytesMessage();
        this.marshallRequest((Message)message, command, requestId);
        JGroupsTransport.setMessageFlags((Message)message, deliverOrder, true);
        this.send((Message)message);
        this.clusterView.getMembersSet().stream().filter(t -> !t.equals(this.address)).forEach(arg_0 -> this.lambda$sendCommandToAll$1((Message)message, requestId, arg_0));
    }

    private void logRequest(long requestId, Object command, Object targets, String type) {
        if (log.isTraceEnabled()) {
            log.tracef("%s sending %s request %d to %s: %s", new Object[]{this.address, type, requestId, targets, command});
        }
    }

    private void logCommand(Object command, Object targets) {
        if (log.isTraceEnabled()) {
            log.tracef("%s sending command to %s: %s", this.address, targets, command);
        }
    }

    public JChannel getChannel() {
        return this.channel;
    }

    private void updateSitesView(Collection<String> sitesUp, Collection<String> sitesDown) {
        Set<String> view = this.getSitesView();
        log.tracef("Sites view changed: up %s, down %s, new view is %s", sitesUp, sitesDown, view);
        if (!sitesUp.isEmpty()) {
            Log.XSITE.crossSiteViewEvent("joining", String.join((CharSequence)", ", sitesUp));
        }
        if (!sitesDown.isEmpty()) {
            Log.XSITE.crossSiteViewEvent("leaving", String.join((CharSequence)", ", sitesDown));
        }
        if (this.isPrimaryRelayNode()) {
            Log.XSITE.receivedXSiteClusterView(view);
        } else {
            view = Collections.emptySet();
        }
        CompletionStages.join(this.notifier.notifyCrossSiteViewChanged(view, sitesUp, sitesDown));
    }

    private void siteUnreachable(String site) {
        if (this.unreachableSites.putIfAbsent(site, SiteUnreachableReason.SITE_UNREACHABLE_EVENT) != null) {
            return;
        }
        try {
            this.cancelRequestsFromSite(site);
        }
        finally {
            this.unreachableSites.remove(site, (Object)SiteUnreachableReason.SITE_UNREACHABLE_EVENT);
        }
    }

    private void cancelRequestsFromSite(String site) {
        this.requests.forEach(request -> {
            if (request instanceof SingleSiteRequest) {
                ((SingleSiteRequest)request).sitesUnreachable(site);
            }
        });
    }

    private void sendCommand(Collection<Address> targets, ReplicableCommand command, long requestId, DeliverOrder deliverOrder, boolean checkView) {
        Objects.requireNonNull(targets);
        BytesMessage message = new BytesMessage();
        this.marshallRequest((Message)message, command, requestId);
        JGroupsTransport.setMessageFlags((Message)message, deliverOrder, true);
        BytesMessage copy = message;
        Iterator<Address> it = targets.iterator();
        while (it.hasNext()) {
            Address address = it.next();
            if (checkView && !this.clusterView.contains(address) || address.equals(this.address)) continue;
            copy.dest(JGroupsTransport.toJGroupsAddress(address));
            this.send((Message)copy);
            this.metricsManager.recordMessageSent(address, copy.size(), requestId == 0L);
            if (!it.hasNext()) continue;
            copy = copy.copy(true, true);
        }
    }

    TimeService getTimeService() {
        return this.timeService;
    }

    ScheduledExecutorService getTimeoutExecutor() {
        return this.timeoutExecutor;
    }

    void processMessage(Message message) {
        long requestId;
        int type;
        org.jgroups.Address src = message.src();
        short flags = message.getFlags();
        byte[] buffer = message.getArray();
        int offset = message.getOffset();
        int length = message.getLength();
        RequestCorrelator.Header header = (RequestCorrelator.Header)message.getHeader(HEADER_ID);
        if (header != null) {
            type = header.type;
            requestId = header.requestId();
        } else {
            type = 2;
            requestId = 0L;
        }
        if (!this.running) {
            if (log.isTraceEnabled()) {
                log.tracef("Ignoring message received before start or after stop", new Object[0]);
            }
            if (type == 0) {
                this.sendResponse(src, CacheNotFoundResponse.INSTANCE, requestId, null);
            }
            return;
        }
        switch (type) {
            case 0: 
            case 2: {
                this.processRequest(src, flags, buffer, offset, length, requestId);
                break;
            }
            case 1: {
                this.processResponse(src, buffer, offset, length, requestId);
                break;
            }
            default: {
                Log.CLUSTER.invalidMessageType(type, src);
            }
        }
    }

    private void sendResponse(org.jgroups.Address target, Response response, long requestId, Object command) {
        block9: {
            ByteBuffer bytes;
            JChannel channel;
            if (log.isTraceEnabled()) {
                log.tracef("%s sending response for request %d to %s: %s", new Object[]{this.getAddress(), requestId, target, response});
            }
            if ((channel = this.channel) == null) {
                return;
            }
            try {
                bytes = response == null ? EMPTY_MESSAGE_BUFFER : this.marshaller.objectToBuffer((Object)response);
            }
            catch (Throwable t) {
                try {
                    Throwable e = t instanceof Exception ? (Exception)t : new CacheException(t);
                    bytes = this.marshaller.objectToBuffer((Object)new ExceptionResponse((Exception)e));
                }
                catch (Throwable tt) {
                    if (channel.isConnected()) {
                        Log.CLUSTER.errorSendingResponse(requestId, target, command);
                    }
                    return;
                }
            }
            try {
                Message message = new BytesMessage(target).setFlag(REPLY_FLAGS, false);
                message.setArray(bytes.getBuf(), bytes.getOffset(), bytes.getLength());
                RequestCorrelator.Header header = new RequestCorrelator.Header(1, requestId, 0);
                message.putHeader(HEADER_ID, (Header)header);
                channel.send(message);
            }
            catch (Throwable t) {
                if (!channel.isConnected()) break block9;
                Log.CLUSTER.errorSendingResponse(requestId, target, command);
            }
        }
    }

    private void processRequest(org.jgroups.Address src, short flags, byte[] buffer, int offset, int length, long requestId) {
        try {
            Reply reply;
            DeliverOrder deliverOrder = this.decodeDeliverMode(flags);
            if (src.equals((Object)((JGroupsAddress)this.getAddress()).getJGroupsAddress())) {
                if (log.isTraceEnabled()) {
                    log.tracef("Ignoring request %d from self without total order", requestId);
                }
                return;
            }
            Object command = this.marshaller.objectFromByteBuffer(buffer, offset, length);
            if (requestId != 0L) {
                if (log.isTraceEnabled()) {
                    log.tracef("%s received request %d from %s: %s", new Object[]{this.getAddress(), requestId, src, command});
                }
                reply = response -> this.sendResponse(src, response, requestId, command);
            } else {
                if (log.isTraceEnabled()) {
                    log.tracef("%s received command from %s: %s", this.getAddress(), src, command);
                }
                reply = Reply.NO_OP;
            }
            if (Util.isFlagSet((short)flags, (Message.Flag)Message.Flag.NO_RELAY)) {
                assert (command instanceof ReplicableCommand);
                this.invocationHandler.handleFromCluster(JGroupsAddressCache.fromJGroupsAddress(src), (ReplicableCommand)command, reply, deliverOrder);
            } else {
                assert (src instanceof SiteAddress);
                assert (command instanceof XSiteRequest);
                String originSite = ((SiteAddress)src).getSite();
                this.invocationHandler.handleFromRemoteSite(originSite, (XSiteRequest)command, reply, deliverOrder);
            }
        }
        catch (Throwable t) {
            Log.CLUSTER.errorProcessingRequest(requestId, src, t);
            Throwable e = t instanceof Exception ? (Exception)t : new CacheException(t);
            this.sendResponse(src, new ExceptionResponse((Exception)e), requestId, null);
        }
    }

    private void processResponse(org.jgroups.Address src, byte[] buffer, int offset, int length, long requestId) {
        try {
            Response response = length == 0 ? CacheNotFoundResponse.INSTANCE : (length == 1 && buffer[0] == 0 ? SuccessfulResponse.SUCCESSFUL_EMPTY_RESPONSE : (Response)this.marshaller.objectFromByteBuffer(buffer, offset, length));
            if (log.isTraceEnabled()) {
                log.tracef("%s received response for request %d from %s: %s", new Object[]{this.getAddress(), requestId, src, response});
            }
            Address address = JGroupsAddressCache.fromJGroupsAddress(src);
            this.requests.addResponse(requestId, address, response);
        }
        catch (Throwable t) {
            Log.CLUSTER.errorProcessingResponse(requestId, src, t);
        }
    }

    private DeliverOrder decodeDeliverMode(short flags) {
        boolean oob = Util.isFlagSet((short)flags, (Message.Flag)Message.Flag.OOB);
        return oob ? DeliverOrder.NONE : DeliverOrder.PER_SENDER;
    }

    private Optional<RELAY2> findRelay2() {
        return Optional.ofNullable((RELAY2)this.channel.getProtocolStack().findProtocol(RELAY2.class));
    }

    private Optional<org.jgroups.Address> findPhysicalAddress(org.jgroups.Address member) {
        return Optional.ofNullable((org.jgroups.Address)this.channel.down(new Event(87, (Object)member)));
    }

    private /* synthetic */ void lambda$sendCommandToAll$1(Message message, long requestId, Address t) {
        this.metricsManager.recordMessageSent(t, message.size(), requestId == 0L);
    }

    private class ChannelCallbacks
    implements RouteStatusListener,
    UpHandler,
    ChannelListener,
    AddressGenerator {
        private ChannelCallbacks() {
        }

        public void sitesUp(String ... sites) {
            for (String upSite : sites) {
                JGroupsTransport.this.unreachableSites.remove(upSite, (Object)SiteUnreachableReason.SITE_DOWN_EVENT);
            }
            JGroupsTransport.this.updateSitesView(Arrays.asList(sites), Collections.emptyList());
        }

        public void sitesDown(String ... sites) {
            ArrayList<String> requestsToCancel = new ArrayList<String>(sites.length);
            for (String downSite : sites) {
                if (JGroupsTransport.this.unreachableSites.put(downSite, SiteUnreachableReason.SITE_DOWN_EVENT) != null) continue;
                requestsToCancel.add(downSite);
            }
            requestsToCancel.forEach(JGroupsTransport.this::cancelRequestsFromSite);
            JGroupsTransport.this.updateSitesView(Collections.emptyList(), Arrays.asList(sites));
        }

        public UpHandler setLocalAddress(org.jgroups.Address a) {
            return this;
        }

        public Object up(Event evt) {
            switch (evt.getType()) {
                case 6: {
                    JGroupsTransport.this.receiveClusterView((View)evt.getArg(), false);
                    break;
                }
                case 104: {
                    SiteMaster site_master = (SiteMaster)evt.getArg();
                    String site = site_master.getSite();
                    JGroupsTransport.this.siteUnreachable(site);
                }
            }
            return null;
        }

        public Object up(Message msg) {
            JGroupsTransport.this.processMessage(msg);
            return null;
        }

        public void up(MessageBatch batch) {
            batch.forEach(message -> {
                if (message == null) {
                    return;
                }
                JGroupsTransport.this.processMessage((Message)message);
            });
        }

        public void channelConnected(JChannel channel) {
            JGroupsTransport.this.metricsManager.onChannelConnected(channel, channel == JGroupsTransport.this.channel);
        }

        public void channelDisconnected(JChannel channel) {
            JGroupsTransport.this.metricsManager.onChannelDisconnected(channel);
        }

        public void channelClosed(JChannel channel) {
        }

        public org.jgroups.Address generateAddress() {
            TransportConfiguration transportCfg = JGroupsTransport.this.configuration.transport();
            return JGroupsTopologyAwareAddress.randomUUID(JGroupsTransport.this.channel.getName(), transportCfg.siteId(), transportCfg.rackId(), transportCfg.machineId());
        }

        public org.jgroups.Address generateAddress(String name) {
            TransportConfiguration transportCfg = JGroupsTransport.this.configuration.transport();
            return JGroupsTopologyAwareAddress.randomUUID(name, transportCfg.siteId(), transportCfg.rackId(), transportCfg.machineId());
        }
    }

    private static enum SiteUnreachableReason {
        SITE_DOWN_EVENT,
        SITE_UNREACHABLE_EVENT;

    }
}

