/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.infinispan.commons.marshall.MarshallingException;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.jgroups.JGroupsAddressCache;
import org.jgroups.util.Util;

@ProtoTypeId(value=10)
public class JGroupsAddress
implements Address {
    protected final org.jgroups.Address address;
    private final int hashCode;
    private volatile byte[] bytes;

    public JGroupsAddress(org.jgroups.Address address) {
        if (address == null) {
            throw new IllegalArgumentException("Address shall not be null");
        }
        this.address = address;
        this.hashCode = address.hashCode();
    }

    @ProtoFactory
    static JGroupsAddress protoFactory(byte[] bytes) throws IOException {
        JGroupsAddress jGroupsAddress;
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            org.jgroups.Address address = Util.readAddress((DataInput)in);
            jGroupsAddress = (JGroupsAddress)JGroupsAddressCache.fromJGroupsAddress(address);
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ClassNotFoundException e) {
                throw new MarshallingException((Throwable)e);
            }
        }
        in.close();
        return jGroupsAddress;
    }

    @ProtoField(value=1)
    byte[] getBytes() throws IOException {
        if (this.bytes == null) {
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
                 DataOutputStream out = new DataOutputStream(baos);){
                Util.writeAddress((org.jgroups.Address)this.address, (DataOutput)out);
                this.bytes = baos.toByteArray();
            }
        }
        return this.bytes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JGroupsAddress that = (JGroupsAddress)o;
        return this.hashCode == that.hashCode && this.address.equals((Object)that.address);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return String.valueOf(this.address);
    }

    public org.jgroups.Address getJGroupsAddress() {
        return this.address;
    }

    @Override
    public int compareTo(Address o) {
        JGroupsAddress oa = (JGroupsAddress)o;
        return this.address.compareTo((Object)oa.address);
    }
}

