/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.api.Lifecycle;
import org.infinispan.commons.util.Experimental;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.concurrent.AggregateCompletionStage;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.rpc.ResponseFilter;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.remoting.transport.XSiteResponse;
import org.infinispan.remoting.transport.raft.RaftManager;
import org.infinispan.util.logging.Log;
import org.infinispan.xsite.XSiteBackup;
import org.infinispan.xsite.commands.remote.XSiteRequest;

@Scope(value=Scopes.GLOBAL)
public interface Transport
extends Lifecycle {
    public CompletableFuture<Map<Address, Response>> invokeRemotelyAsync(Collection<Address> var1, ReplicableCommand var2, ResponseMode var3, long var4, ResponseFilter var6, DeliverOrder var7, boolean var8) throws Exception;

    public void sendTo(Address var1, ReplicableCommand var2, DeliverOrder var3) throws Exception;

    public void sendToMany(Collection<Address> var1, ReplicableCommand var2, DeliverOrder var3) throws Exception;

    @Experimental
    default public void sendToAll(ReplicableCommand rpcCommand, DeliverOrder deliverOrder) throws Exception {
        this.sendToMany(null, rpcCommand, deliverOrder);
    }

    public <O> XSiteResponse<O> backupRemotely(XSiteBackup var1, XSiteRequest<O> var2);

    public boolean isCoordinator();

    public Address getCoordinator();

    public Address getAddress();

    public List<Address> getPhysicalAddresses();

    public List<Address> getMembers();

    public List<Address> getMembersPhysicalAddresses();

    public boolean isMulticastCapable();

    public void checkCrossSiteAvailable() throws CacheConfigurationException;

    public String localSiteName();

    default public String localNodeName() {
        return this.getAddress().toString();
    }

    public void start();

    public void stop();

    public int getViewId();

    public CompletableFuture<Void> withView(int var1);

    public Log getLog();

    public Set<String> getSitesView();

    public boolean isSiteCoordinator();

    public Collection<Address> getRelayNodesAddress();

    default public boolean isPrimaryRelayNode() {
        Collection<Address> relayNodeList = this.getRelayNodesAddress();
        return !relayNodeList.isEmpty() && relayNodeList.iterator().next().equals(this.getAddress());
    }

    @Experimental
    default public <T> CompletionStage<T> invokeCommand(Address target, ReplicableCommand command, ResponseCollector<T> collector, DeliverOrder deliverOrder, long timeout, TimeUnit unit) {
        return this.invokeCommand(Collections.singleton(target), command, collector, deliverOrder, timeout, unit);
    }

    @Experimental
    default public <T> CompletionStage<T> invokeCommand(Collection<Address> targets, ReplicableCommand command, ResponseCollector<T> collector, DeliverOrder deliverOrder, long timeout, TimeUnit unit) {
        try {
            return this.invokeRemotelyAsync(targets, command, ResponseMode.SYNCHRONOUS_IGNORE_LEAVERS, unit.toMillis(timeout), null, deliverOrder, false).thenApply(map -> {
                for (Map.Entry e : map.entrySet()) {
                    Object result = collector.addResponse((Address)e.getKey(), (Response)e.getValue());
                    if (result == null) continue;
                    return result;
                }
                return collector.finish();
            });
        }
        catch (Exception e) {
            throw Util.rewrapAsCacheException((Throwable)e);
        }
    }

    @Experimental
    default public <T> CompletionStage<T> invokeCommandOnAll(ReplicableCommand command, ResponseCollector<T> collector, DeliverOrder deliverOrder, long timeout, TimeUnit unit) {
        return this.invokeCommand(this.getMembers(), command, collector, deliverOrder, timeout, unit);
    }

    @Experimental
    default public <T> CompletionStage<T> invokeCommandOnAll(Collection<Address> requiredTargets, ReplicableCommand command, ResponseCollector<T> collector, DeliverOrder deliverOrder, long timeout, TimeUnit unit) {
        return this.invokeCommand(requiredTargets, command, collector, deliverOrder, timeout, unit);
    }

    @Experimental
    default public <T> CompletionStage<T> invokeCommandStaggered(Collection<Address> targets, ReplicableCommand command, final ResponseCollector<T> collector, DeliverOrder deliverOrder, long timeout, TimeUnit unit) {
        final AtomicReference<Object> result = new AtomicReference<Object>(null);
        try {
            ResponseFilter responseFilter = new ResponseFilter(){
                final /* synthetic */ Transport this$0;
                {
                    this.this$0 = this$0;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean isAcceptable(Response response, Address sender) {
                    AtomicReference atomicReference = result;
                    synchronized (atomicReference) {
                        if (result.get() != null) {
                            return false;
                        }
                        Object t = collector.addResponse(sender, response);
                        result.set(t);
                        return t != null;
                    }
                }

                @Override
                public boolean needMoreResponses() {
                    return result.get() == null;
                }
            };
            return this.invokeRemotelyAsync(targets, command, ResponseMode.WAIT_FOR_VALID_RESPONSE, unit.toMillis(timeout), responseFilter, deliverOrder, false).thenApply(map -> {
                AtomicReference atomicReference = result;
                synchronized (atomicReference) {
                    if (result.get() != null) {
                        return result.get();
                    }
                    result.set(new Object());
                    return collector.finish();
                }
            });
        }
        catch (Exception e) {
            throw Util.rewrapAsCacheException((Throwable)e);
        }
    }

    @Experimental
    default public <T> CompletionStage<T> invokeCommands(Collection<Address> targets, Function<Address, ReplicableCommand> commandGenerator, final ResponseCollector<T> collector, DeliverOrder deliverOrder, long timeout, TimeUnit timeUnit) {
        final AtomicReference<Object> result = new AtomicReference<Object>(null);
        ResponseCollector partCollector = new ResponseCollector<T>(this){
            final /* synthetic */ Transport this$0;
            {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T addResponse(Address sender, Response response) {
                2 var3_3 = this;
                synchronized (var3_3) {
                    if (result.get() != null) {
                        return null;
                    }
                    result.set(collector.addResponse(sender, response));
                    return null;
                }
            }

            @Override
            public T finish() {
                return null;
            }
        };
        AggregateCompletionStage allStage = CompletionStages.aggregateCompletionStage();
        for (Address target : targets) {
            allStage.dependsOn(this.invokeCommand(target, commandGenerator.apply(target), partCollector, deliverOrder, timeout, timeUnit));
        }
        return allStage.freeze().thenApply(v -> {
            ResponseCollector responseCollector = partCollector;
            synchronized (responseCollector) {
                if (result.get() != null) {
                    return result.get();
                }
                return collector.finish();
            }
        });
    }

    public RaftManager raftManager();
}

