/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.reactive.publisher.impl.commands.reduction;

import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.functional.functions.InjectableComponent;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.Util;
import org.infinispan.context.Flag;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.marshall.protostream.impl.MarshallableSet;
import org.infinispan.marshall.protostream.impl.WrappedMessages;
import org.infinispan.protostream.WrappedMessage;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.reactive.publisher.impl.DeliveryGuarantee;
import org.infinispan.reactive.publisher.impl.LocalPublisherManager;
import org.infinispan.util.ByteString;

@ProtoTypeId(value=1165)
public class ReductionPublisherRequestCommand<K>
extends BaseRpcCommand
implements TopologyAffectedCommand {
    @ProtoField(value=2)
    final boolean parallelStream;
    @ProtoField(value=3)
    final DeliveryGuarantee deliveryGuarantee;
    @ProtoField(value=4)
    final long explicitFlags;
    @ProtoField(value=5)
    final boolean entryStream;
    final IntSet segments;
    final Set<K> keys;
    final Set<K> excludedKeys;
    final Function<?, ?> transformer;
    final Function<?, ?> finalizer;
    private int topologyId = -1;

    public ReductionPublisherRequestCommand(ByteString cacheName, boolean parallelStream, DeliveryGuarantee deliveryGuarantee, IntSet segments, Set<K> keys, Set<K> excludedKeys, long explicitFlags, boolean entryStream, Function<?, ?> transformer, Function<?, ?> finalizer) {
        super(cacheName);
        this.parallelStream = parallelStream;
        this.deliveryGuarantee = deliveryGuarantee;
        this.segments = segments;
        this.keys = keys;
        this.excludedKeys = excludedKeys;
        this.explicitFlags = explicitFlags;
        this.entryStream = entryStream;
        this.transformer = transformer;
        this.finalizer = finalizer;
    }

    @ProtoFactory
    ReductionPublisherRequestCommand(ByteString cacheName, boolean parallelStream, DeliveryGuarantee deliveryGuarantee, WrappedMessage wrappedSegments, MarshallableSet<K> keys, long explicitFlags, boolean entryStream, MarshallableSet<K> excludedKeys, MarshallableObject<Function<?, ?>> transformer, MarshallableObject<Function<?, ?>> finalizer, int topologyId) {
        super(cacheName);
        this.parallelStream = parallelStream;
        this.deliveryGuarantee = deliveryGuarantee;
        this.segments = (IntSet)WrappedMessages.unwrap(wrappedSegments);
        this.keys = MarshallableSet.unwrap(keys);
        this.excludedKeys = MarshallableSet.unwrap(excludedKeys);
        this.explicitFlags = explicitFlags;
        this.entryStream = entryStream;
        this.finalizer = MarshallableObject.unwrap(finalizer);
        this.transformer = transformer == null ? this.finalizer : MarshallableObject.unwrap(transformer);
        this.topologyId = topologyId;
    }

    @ProtoField(value=6)
    WrappedMessage getWrappedSegments() {
        return WrappedMessages.orElseNull(this.segments);
    }

    @ProtoField(value=7)
    MarshallableSet<K> getKeys() {
        return MarshallableSet.create(this.keys);
    }

    @ProtoField(value=8)
    MarshallableSet<K> getExcludedKeys() {
        return MarshallableSet.create(this.excludedKeys);
    }

    @ProtoField(value=9)
    MarshallableObject<Function<?, ?>> getTransformer() {
        return this.transformer == this.finalizer ? null : MarshallableObject.create(this.transformer);
    }

    @ProtoField(value=10)
    MarshallableObject<Function<?, ?>> getFinalizer() {
        return MarshallableObject.create(this.finalizer);
    }

    @Override
    @ProtoField(value=11)
    public int getTopologyId() {
        return this.topologyId;
    }

    @Override
    public CompletionStage<?> invokeAsync(ComponentRegistry componentRegistry) throws Throwable {
        if (this.transformer instanceof InjectableComponent) {
            ((InjectableComponent)((Object)this.transformer)).inject(componentRegistry);
        }
        if (this.finalizer instanceof InjectableComponent) {
            ((InjectableComponent)((Object)this.finalizer)).inject(componentRegistry);
        }
        LocalPublisherManager lpm = componentRegistry.getLocalPublisherManager().running();
        if (this.entryStream) {
            return lpm.entryReduction(this.parallelStream, this.segments, this.keys, this.excludedKeys, this.explicitFlags, this.deliveryGuarantee, this.transformer, this.finalizer);
        }
        return lpm.keyReduction(this.parallelStream, this.segments, this.keys, this.excludedKeys, this.explicitFlags, this.deliveryGuarantee, this.transformer, this.finalizer);
    }

    @Override
    public void setTopologyId(int topologyId) {
        this.topologyId = topologyId;
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public String toString() {
        return "PublisherRequestCommand{, flags=" + EnumUtil.prettyPrintBitSet((long)this.explicitFlags, Flag.class) + ", topologyId=" + this.topologyId + ", segments=" + String.valueOf(this.segments) + ", keys=" + Util.toStr(this.keys) + ", excludedKeys=" + Util.toStr(this.excludedKeys) + ", transformer= " + String.valueOf(this.transformer) + ", finalizer=" + String.valueOf(this.finalizer) + "}";
    }
}

