/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.reactive.publisher.impl.commands.batch;

import java.util.List;
import java.util.function.ObjIntConsumer;
import org.infinispan.commons.util.IntSet;
import org.infinispan.marshall.protostream.impl.MarshallableArray;
import org.infinispan.protostream.WrappedMessage;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.reactive.publisher.impl.PublisherHandler;
import org.infinispan.reactive.publisher.impl.commands.batch.PublisherResponse;

@ProtoTypeId(value=1117)
public class KeyPublisherResponse
extends PublisherResponse {
    final Object[] extraObjects;
    final int extraSize;
    final Object[] keys;
    final int keySize;

    public KeyPublisherResponse(Object[] results, IntSet completedSegments, IntSet lostSegments, int size, boolean complete, List<PublisherHandler.SegmentResult> segmentResults, Object[] extraObjects, int extraSize, Object[] keys, int keySize) {
        super(results, completedSegments, lostSegments, size, complete, segmentResults);
        this.extraObjects = extraObjects;
        this.extraSize = extraSize;
        this.keys = keys;
        this.keySize = keySize;
    }

    @ProtoFactory
    KeyPublisherResponse(MarshallableArray<Object> wrappedResults, WrappedMessage completedSegmentsWrapped, WrappedMessage lostSegmentsWrapped, boolean complete, List<PublisherHandler.SegmentResult> segmentResults, MarshallableArray<Object> keys) {
        super(wrappedResults, completedSegmentsWrapped, lostSegmentsWrapped, complete, segmentResults);
        this.extraObjects = null;
        this.extraSize = 0;
        this.keys = keys != null ? MarshallableArray.unwrap(keys) : new Object[]{};
        this.keySize = this.keys.length;
    }

    @Override
    MarshallableArray<Object> wrappedResults() {
        if (this.extraSize > 0) {
            int j;
            Object[] r = new Object[this.size + this.extraSize];
            int i = 0;
            for (j = 0; j < this.size; ++j) {
                r[i++] = this.results[j];
            }
            for (j = 0; j < this.extraSize; ++j) {
                r[i++] = this.extraObjects[j];
            }
            return MarshallableArray.create(r);
        }
        return MarshallableArray.create(this.results);
    }

    @ProtoField(value=6)
    MarshallableArray<Object> getKeys() {
        return MarshallableArray.create(this.keys);
    }

    public int getExtraSize() {
        return this.extraSize;
    }

    public Object[] getExtraObjects() {
        return this.extraObjects;
    }

    @Override
    public void keysForNonCompletedSegments(ObjIntConsumer consumer) {
        int size = this.segmentResults.size();
        if (size == 0) {
            return;
        }
        PublisherHandler.SegmentResult segmentResult = (PublisherHandler.SegmentResult)this.segmentResults.get(this.segmentResults.size() - 1);
        int segment = segmentResult.getSegment();
        for (int i = 0; i < this.keySize; ++i) {
            consumer.accept(this.keys[i], segment);
        }
    }

    @Override
    public String toString() {
        return "KeyPublisherResponse{size=" + this.size + ", completedSegments=" + String.valueOf(this.completedSegments) + ", lostSegments=" + String.valueOf(this.lostSegments) + ", complete=" + this.complete + ", segmentResults=" + String.valueOf(this.segmentResults) + ", extraSize=" + this.extraSize + ", keySize=" + this.keySize + "}";
    }
}

