/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener.cluster;

import java.util.Objects;
import org.infinispan.Cache;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryExpiredEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.notifications.cachelistener.event.impl.EventImpl;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.infinispan.transaction.xa.GlobalTransaction;

@ProtoTypeId(value=1056)
public class ClusterEvent<K, V>
implements CacheEntryCreatedEvent<K, V>,
CacheEntryRemovedEvent<K, V>,
CacheEntryModifiedEvent<K, V>,
CacheEntryExpiredEvent<K, V> {
    transient Cache<K, V> cache;
    private final K key;
    private final V value;
    private final V oldValue;
    private final Metadata metadata;
    @ProtoField(value=1)
    final Event.Type type;
    @ProtoField(value=2)
    final GlobalTransaction transaction;
    @ProtoField(number=3, javaType=JGroupsAddress.class)
    final Address origin;
    @ProtoField(value=4)
    final boolean commandRetried;

    public static <K, V> ClusterEvent<K, V> fromEvent(CacheEntryEvent<K, V> event) {
        if (event instanceof ClusterEvent) {
            return (ClusterEvent)event;
        }
        V oldValue = null;
        Event.Type eventType = event.getType();
        boolean commandRetried = switch (eventType) {
            case Event.Type.CACHE_ENTRY_REMOVED -> {
                oldValue = ((CacheEntryRemovedEvent)event).getOldValue();
                yield ((CacheEntryRemovedEvent)event).isCommandRetried();
            }
            case Event.Type.CACHE_ENTRY_CREATED -> ((CacheEntryCreatedEvent)event).isCommandRetried();
            case Event.Type.CACHE_ENTRY_MODIFIED -> ((CacheEntryModifiedEvent)event).isCommandRetried();
            case Event.Type.CACHE_ENTRY_EXPIRED -> false;
            default -> throw new IllegalArgumentException("Cluster Event can only be created from a CacheEntryRemoved, CacheEntryCreated or CacheEntryModified event!");
        };
        GlobalTransaction transaction = event.getGlobalTransaction();
        Metadata metadata = null;
        if (event instanceof EventImpl) {
            metadata = event.getMetadata();
        }
        ClusterEvent<K, Object> clusterEvent = new ClusterEvent<K, Object>(event.getKey(), event.getValue(), oldValue, metadata, eventType, event.getCache().getCacheManager().getAddress(), transaction, commandRetried);
        clusterEvent.cache = event.getCache();
        return clusterEvent;
    }

    ClusterEvent(K key, V value, V oldValue, Metadata metadata, Event.Type type, Address origin, GlobalTransaction transaction, boolean commandRetried) {
        this.key = key;
        this.value = value;
        this.oldValue = oldValue;
        this.metadata = metadata;
        this.type = type;
        this.origin = origin;
        this.transaction = transaction;
        this.commandRetried = commandRetried;
    }

    @ProtoFactory
    ClusterEvent(MarshallableObject<K> wrappedKey, MarshallableObject<V> wrappedValue, MarshallableObject<V> wrappedOldValue, MarshallableObject<Metadata> wrappedMetadata, GlobalTransaction transaction, JGroupsAddress origin, Event.Type type, boolean commandRetried) {
        this(MarshallableObject.unwrap(wrappedKey), MarshallableObject.unwrap(wrappedValue), MarshallableObject.unwrap(wrappedOldValue), MarshallableObject.unwrap(wrappedMetadata), type, (Address)origin, transaction, commandRetried);
    }

    @ProtoField(number=5, name="key")
    MarshallableObject<K> getWrappedKey() {
        return MarshallableObject.create(this.key);
    }

    @ProtoField(number=6, name="value")
    MarshallableObject<V> getWrappedValue() {
        return MarshallableObject.create(this.value);
    }

    @ProtoField(number=7, name="oldValue")
    MarshallableObject<V> getWrappedOldValue() {
        return MarshallableObject.create(this.oldValue);
    }

    @ProtoField(number=8, name="metadata")
    MarshallableObject<Metadata> getWrappedMetadata() {
        return MarshallableObject.create(this.metadata);
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public V getNewValue() {
        return this.value;
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public Metadata getOldMetadata() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isCommandRetried() {
        return this.commandRetried;
    }

    @Override
    public V getOldValue() {
        return this.oldValue;
    }

    @Override
    public boolean isCreated() {
        return this.type == Event.Type.CACHE_ENTRY_CREATED;
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public GlobalTransaction getGlobalTransaction() {
        return this.transaction;
    }

    @Override
    public boolean isOriginLocal() {
        if (this.cache != null) {
            return this.cache.getCacheManager().getAddress().equals(this.origin);
        }
        return false;
    }

    @Override
    public Event.Type getType() {
        return this.type;
    }

    @Override
    public boolean isPre() {
        return false;
    }

    @Override
    public Cache<K, V> getCache() {
        return this.cache;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterEvent that = (ClusterEvent)o;
        return this.commandRetried == that.commandRetried && Objects.equals(this.cache, that.cache) && Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value) && Objects.equals(this.oldValue, that.oldValue) && Objects.equals(this.metadata, that.metadata) && this.type == that.type && Objects.equals(this.transaction, that.transaction) && Objects.equals(this.origin, that.origin);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.cache, this.key, this.value, this.oldValue, this.metadata, this.type, this.transaction, this.origin, this.commandRetried});
    }

    public String toString() {
        return "ClusterEvent {type=" + String.valueOf((Object)this.type) + ", cache=" + String.valueOf(this.cache) + ", key=" + String.valueOf(this.key) + ", value=" + String.valueOf(this.value) + ", oldValue=" + String.valueOf(this.oldValue) + ", transaction=" + String.valueOf(this.transaction) + ", retryCommand=" + this.commandRetried + ", origin=" + String.valueOf(this.origin) + "}";
    }
}

