/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.protostream.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.util.Util;
import org.infinispan.marshall.protostream.impl.AbstractInternalProtoStreamMarshaller;
import org.infinispan.marshall.protostream.impl.GlobalContextInitializer;
import org.infinispan.protostream.ProtobufTagMarshaller;
import org.infinispan.protostream.TagReader;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.protostream.annotations.impl.GeneratedMarshallerBase;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@ProtoTypeId(value=21)
public class MarshallableMap<K, V> {
    static final Log log = LogFactory.getLog(MarshallableMap.class);
    final Map<K, V> map;

    public static <K, V> MarshallableMap<K, V> create(Map<K, V> map) {
        return map == null ? null : new MarshallableMap<K, V>(map);
    }

    public static <K, V> Map<K, V> unwrap(MarshallableMap<K, V> wrapper) {
        return wrapper == null ? null : wrapper.get();
    }

    @ProtoFactory
    MarshallableMap(List<byte[]> keys, List<byte[]> values) {
        throw log.marshallerNotOverridden(this.getClass().getName());
    }

    private MarshallableMap(Map<K, V> map) {
        this.map = map;
    }

    @ProtoField(value=1)
    List<byte[]> getKeys() {
        throw log.marshallerNotOverridden(this.getClass().getName());
    }

    @ProtoField(value=2)
    List<byte[]> getValues() {
        throw log.marshallerNotOverridden(this.getClass().getName());
    }

    public Map<K, V> get() {
        return this.map;
    }

    public static class Marshaller
    extends GeneratedMarshallerBase
    implements ProtobufTagMarshaller<MarshallableMap<?, ?>> {
        private final String typeName = GlobalContextInitializer.getFqTypeName(MarshallableMap.class);
        private final AbstractInternalProtoStreamMarshaller marshaller;

        public Marshaller(AbstractInternalProtoStreamMarshaller marshaller) {
            this.marshaller = marshaller;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public MarshallableMap<?, ?> read(ProtobufTagMarshaller.ReadContext ctx) throws IOException {
            TagReader in = ctx.getReader();
            ArrayList<Object> keys = new ArrayList<Object>();
            ArrayList<Object> values = new ArrayList<Object>();
            boolean done = false;
            block5: while (!done) {
                int tag = in.readTag();
                switch (tag) {
                    case 0: {
                        done = true;
                        continue block5;
                    }
                    case 10: {
                        keys.add(this.read(in));
                        continue block5;
                    }
                    case 18: {
                        values.add(this.read(in));
                        continue block5;
                    }
                }
                if (in.skipField(tag)) continue;
                done = true;
            }
            HashMap map = new HashMap(keys.size());
            for (int i = 0; i < keys.size(); ++i) {
                Object key = keys.get(i);
                Object value = values.get(i);
                map.put(key, value);
            }
            return new MarshallableMap(map);
        }

        public void write(ProtobufTagMarshaller.WriteContext ctx, MarshallableMap<?, ?> wrapper) throws IOException {
            Map<?, ?> map = wrapper.get();
            if (map == null) {
                return;
            }
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                this.write(ctx, 1, entry.getKey());
                this.write(ctx, 2, entry.getValue());
            }
        }

        public Class getJavaClass() {
            return MarshallableMap.class;
        }

        private Object read(TagReader in) throws IOException {
            byte[] bytes = in.readByteArray();
            return bytes.length == 0 ? null : this.marshaller.objectFromByteBuffer(bytes);
        }

        private void write(ProtobufTagMarshaller.WriteContext ctx, int field, Object object) throws IOException {
            if (object == null) {
                ctx.getWriter().writeBytes(field, Util.EMPTY_BYTE_ARRAY);
            } else {
                ByteBuffer buf = this.marshaller.objectToBuffer(object);
                ctx.getWriter().writeBytes(field, buf.getBuf(), buf.getOffset(), buf.getLength());
            }
        }
    }
}

