/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.manager.impl;

import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.security.auth.Subject;
import org.infinispan.commands.GlobalRpcCommand;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.impl.UnwrappingEmbeddedCacheManager;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.security.Security;
import org.infinispan.util.concurrent.BlockingManager;

@ProtoTypeId(value=1167)
@Scope(value=Scopes.NONE)
public class ReplicableManagerFunctionCommand
implements GlobalRpcCommand {
    final Function<? super EmbeddedCacheManager, ?> function;
    final Subject subject;

    public ReplicableManagerFunctionCommand(Function<? super EmbeddedCacheManager, ?> function, Subject subject) {
        this.function = function;
        this.subject = subject;
    }

    @ProtoFactory
    ReplicableManagerFunctionCommand(MarshallableObject<Function<? super EmbeddedCacheManager, ?>> function, Subject subject) {
        this.function = MarshallableObject.unwrap(function);
        this.subject = subject;
    }

    @ProtoField(value=1)
    MarshallableObject<Function<? super EmbeddedCacheManager, ?>> getFunction() {
        return MarshallableObject.create(this.function);
    }

    @ProtoField(value=2)
    Subject getSubject() {
        return this.subject;
    }

    public CompletableFuture<Object> invokeAsync(GlobalComponentRegistry globalComponentRegistry) throws Throwable {
        BlockingManager bm = globalComponentRegistry.getComponent(BlockingManager.class);
        return bm.supplyBlocking(() -> {
            if (this.subject == null) {
                return this.function.apply(new UnwrappingEmbeddedCacheManager(globalComponentRegistry.getCacheManager()));
            }
            return Security.doAs(this.subject, this.function, new UnwrappingEmbeddedCacheManager(globalComponentRegistry.getCacheManager()));
        }, "replicable-manager-function").toCompletableFuture();
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }
}

