/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.functional;

import java.util.Optional;
import org.infinispan.commons.util.Experimental;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.NumericVersion;
import org.infinispan.container.versioning.SimpleClusteredVersion;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@Experimental
public interface MetaParam<T> {
    public T get();

    @Experimental
    public static final class MetaUpdateCreationTime
    extends MetaBoolean
    implements Writable<Boolean> {
        private static final MetaUpdateCreationTime UPDATE = new MetaUpdateCreationTime(true);
        private static final MetaUpdateCreationTime NOT_UPDATE = new MetaUpdateCreationTime(false);

        public MetaUpdateCreationTime(boolean value) {
            super(value);
        }

        public static MetaUpdateCreationTime of(boolean update) {
            return update ? UPDATE : NOT_UPDATE;
        }
    }

    @Experimental
    public static final class MetaLoadedFromPersistence
    extends MetaBoolean {
        public static final MetaLoadedFromPersistence LOADED = new MetaLoadedFromPersistence(true);
        public static final MetaLoadedFromPersistence NOT_LOADED = new MetaLoadedFromPersistence(false);

        private MetaLoadedFromPersistence(boolean loaded) {
            super(loaded);
        }

        public static MetaLoadedFromPersistence of(boolean loaded) {
            return loaded ? LOADED : NOT_LOADED;
        }
    }

    @Experimental
    public static abstract class MetaBoolean
    implements MetaParam<Boolean> {
        protected final boolean value;

        public MetaBoolean(boolean value) {
            this.value = value;
        }

        @Override
        public Boolean get() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MetaBoolean metaBoolean = (MetaBoolean)o;
            return this.value == metaBoolean.value;
        }

        public int hashCode() {
            return this.value ? 1 : 0;
        }
    }

    @Experimental
    public static abstract class MetaLong
    implements MetaParam<Long> {
        protected final long value;

        public MetaLong(long value) {
            this.value = value;
        }

        @Override
        public Long get() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MetaLong longMeta = (MetaLong)o;
            return this.value == longMeta.value;
        }

        public int hashCode() {
            return (int)(this.value ^ this.value >>> 32);
        }
    }

    @ProtoTypeId(value=1133)
    @Experimental
    public static class MetaEntryVersion
    implements Writable<EntryVersion> {
        private final EntryVersion entryVersion;

        public MetaEntryVersion(EntryVersion entryVersion) {
            this.entryVersion = entryVersion;
        }

        @ProtoFactory
        MetaEntryVersion(NumericVersion numericVersion, SimpleClusteredVersion clusteredVersion) {
            this.entryVersion = numericVersion != null ? numericVersion : clusteredVersion;
        }

        @ProtoField(value=1)
        NumericVersion getNumericVersion() {
            return this.entryVersion instanceof NumericVersion ? (NumericVersion)this.entryVersion : null;
        }

        @ProtoField(value=2)
        SimpleClusteredVersion getClusteredVersion() {
            return this.entryVersion instanceof SimpleClusteredVersion ? (SimpleClusteredVersion)this.entryVersion : null;
        }

        @Override
        public EntryVersion get() {
            return this.entryVersion;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MetaEntryVersion that = (MetaEntryVersion)o;
            return this.entryVersion.equals(that.entryVersion);
        }

        public int hashCode() {
            return this.entryVersion.hashCode();
        }

        public String toString() {
            return "MetaEntryVersion=" + String.valueOf(this.entryVersion);
        }
    }

    @Experimental
    public static final class MetaLastUsed
    extends MetaLong {
        public MetaLastUsed(long lastUsed) {
            super(lastUsed);
        }

        public String toString() {
            return "MetaLastUsed=" + this.value;
        }
    }

    @ProtoTypeId(value=1135)
    @Experimental
    public static final class MetaMaxIdle
    extends MetaLong
    implements Writable<Long> {
        private static final MetaMaxIdle DEFAULT = new MetaMaxIdle(-1L);

        @ProtoFactory
        public MetaMaxIdle(long maxIdle) {
            super(maxIdle);
        }

        @ProtoField(value=1)
        long getMaxIdle() {
            return this.value;
        }

        public String toString() {
            return "MetaMaxIdle=" + this.value;
        }

        public static MetaMaxIdle defaultValue() {
            return DEFAULT;
        }
    }

    @Experimental
    public static final class MetaCreated
    extends MetaLong {
        public MetaCreated(long created) {
            super(created);
        }

        public String toString() {
            return "MetaCreated=" + this.value;
        }
    }

    @ProtoTypeId(value=1134)
    @Experimental
    public static final class MetaLifespan
    extends MetaLong
    implements Writable<Long> {
        private static final MetaLifespan DEFAULT = new MetaLifespan(-1L);

        @ProtoFactory
        public MetaLifespan(long lifespan) {
            super(lifespan);
        }

        @ProtoField(value=1)
        long getLifespan() {
            return this.value;
        }

        public String toString() {
            return "MetaLifespan=" + this.value;
        }

        public static MetaLifespan defaultValue() {
            return DEFAULT;
        }
    }

    @Experimental
    public static interface Writable<T>
    extends MetaParam<T> {
    }

    @Experimental
    public static interface Lookup {
        public <T extends MetaParam> Optional<T> findMetaParam(Class<T> var1);
    }
}

