/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.filter;

import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.filter.KeyValueFilter;
import org.infinispan.marshall.protostream.impl.MarshallableArray;
import org.infinispan.metadata.Metadata;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=1065)
@Scope(value=Scopes.NONE)
public class CompositeKeyValueFilter<K, V>
implements KeyValueFilter<K, V> {
    private final MarshallableArray<KeyValueFilter<? super K, ? super V>> filters;

    public CompositeKeyValueFilter(KeyValueFilter<? super K, ? super V> ... filters) {
        this.filters = MarshallableArray.create(filters);
    }

    @ProtoFactory
    CompositeKeyValueFilter(MarshallableArray<KeyValueFilter<? super K, ? super V>> filters) {
        this.filters = filters;
    }

    @ProtoField(value=1)
    MarshallableArray<KeyValueFilter<? super K, ? super V>> getFilters() {
        return this.filters;
    }

    @Override
    public boolean accept(K key, V value, Metadata metadata) {
        for (KeyValueFilter<K, V> keyValueFilter : MarshallableArray.unwrap(this.filters)) {
            if (keyValueFilter.accept(key, value, metadata)) continue;
            return false;
        }
        return true;
    }

    @Inject
    protected void injectDependencies(ComponentRegistry cr) {
        for (KeyValueFilter<? super K, ? super V> f : MarshallableArray.unwrap(this.filters)) {
            cr.wireDependencies(f);
        }
    }
}

