/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;
import net.jcip.annotations.Immutable;
import org.infinispan.commons.util.Immutables;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.impl.AbstractConsistentHash;
import org.infinispan.distribution.ch.impl.OwnershipStatistics;
import org.infinispan.globalstate.ScopedPersistentState;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.infinispan.topology.PersistentUUID;

@Immutable
@ProtoTypeId(value=1069)
public class DefaultConsistentHash
extends AbstractConsistentHash {
    private static final String STATE_NUM_OWNERS = "numOwners";
    private static final String STATE_SEGMENT_OWNER = "segmentOwner.%d.%d";
    private static final String STATE_SEGMENT_OWNERS = "segmentOwners";
    private static final String STATE_SEGMENT_OWNER_COUNT = "segmentOwner.%d.num";
    private final int numOwners;
    private final transient int hashCode;
    private final List<Address>[] segmentOwners;

    public DefaultConsistentHash(int numOwners, int numSegments, List<Address> members, Map<Address, Float> capacityFactors, List<Address>[] segmentOwners) {
        super(numSegments, members, capacityFactors);
        if (numOwners < 1) {
            throw new IllegalArgumentException("The number of owners must be strictly positive");
        }
        this.numOwners = numOwners;
        this.segmentOwners = new List[numSegments];
        for (int s = 0; s < numSegments; ++s) {
            if (segmentOwners[s] == null || segmentOwners[s].isEmpty()) {
                throw new IllegalArgumentException("Segment owner list cannot be null or empty");
            }
            this.segmentOwners[s] = List.copyOf(segmentOwners[s]);
        }
        this.hashCode = this.hashCodeInternal();
    }

    DefaultConsistentHash(ScopedPersistentState state) {
        super(state);
        this.numOwners = Integer.parseInt(state.getProperty(STATE_NUM_OWNERS));
        int numSegments = DefaultConsistentHash.parseNumSegments(state);
        this.segmentOwners = new List[numSegments];
        for (int i = 0; i < this.segmentOwners.length; ++i) {
            int segmentOwnerCount = Integer.parseInt(state.getProperty(String.format(STATE_SEGMENT_OWNER_COUNT, i)));
            this.segmentOwners[i] = new ArrayList<Address>();
            for (int j = 0; j < segmentOwnerCount; ++j) {
                PersistentUUID uuid = PersistentUUID.fromString(state.getProperty(String.format(STATE_SEGMENT_OWNER, i, j)));
                this.segmentOwners[i].add(uuid);
            }
        }
        this.hashCode = this.hashCodeInternal();
    }

    @ProtoFactory
    DefaultConsistentHash(List<JGroupsAddress> jGroupsMembers, List<Float> capacityFactorsList, int numOwners, List<Integer> segmentOwners) {
        super(segmentOwners.size(), jGroupsMembers, capacityFactorsList);
        if (numOwners < 1) {
            throw new IllegalArgumentException("The number of owners must be strictly positive");
        }
        this.numOwners = numOwners;
        int segmentOwnersLength = segmentOwners.get(0);
        this.segmentOwners = new List[segmentOwnersLength];
        int idx = 0;
        int marshalledArrIdx = 1;
        while (marshalledArrIdx < segmentOwners.size()) {
            int size = segmentOwners.get(marshalledArrIdx++);
            Object[] owners = new Address[size];
            for (int j = 0; j < size; ++j) {
                int ownerIndex = segmentOwners.get(marshalledArrIdx++);
                owners[j] = (Address)this.members.get(ownerIndex);
            }
            this.segmentOwners[idx++] = Immutables.immutableListWrap((Object[])owners);
        }
        for (int i = 0; i < segmentOwnersLength; ++i) {
            if (this.segmentOwners[i] != null && !this.segmentOwners[i].isEmpty()) continue;
            throw new IllegalArgumentException("Segment owner list cannot be null or empty");
        }
        this.hashCode = this.hashCodeInternal();
    }

    @ProtoField(value=1)
    List<JGroupsAddress> getJGroupsMembers() {
        return this.members;
    }

    @ProtoField(number=2, name="capacityFactors")
    List<Float> getCapacityFactorsList() {
        return this.capacityFactors;
    }

    @ProtoField(value=3)
    public int getNumOwners() {
        return this.numOwners;
    }

    @ProtoField(value=4)
    List<Integer> getSegmentOwners() {
        ArrayList<Integer> ownersList = new ArrayList<Integer>((this.segmentOwners.length + 1) * this.segmentOwners[0].size() + 1);
        ownersList.add(this.segmentOwners.length);
        HashMap<Address, Integer> memberIndexes = DefaultConsistentHash.getMemberIndexMap(this.members);
        for (List<Address> owners : this.segmentOwners) {
            ownersList.add(owners.size());
            for (Address owner : owners) {
                ownersList.add(memberIndexes.get(owner));
            }
        }
        return ownersList;
    }

    @Override
    public int getNumSegments() {
        return this.segmentOwners.length;
    }

    @Override
    public Set<Integer> getSegmentsForOwner(Address owner) {
        if (owner == null) {
            throw new IllegalArgumentException("owner cannot be null");
        }
        if (!this.members.contains(owner)) {
            return IntSets.immutableEmptySet();
        }
        IntSet segments = IntSets.mutableEmptySet((int)this.segmentOwners.length);
        for (int segment = 0; segment < this.segmentOwners.length; ++segment) {
            if (!this.segmentOwners[segment].contains(owner)) continue;
            segments.set(segment);
        }
        return segments;
    }

    @Override
    public Set<Integer> getPrimarySegmentsForOwner(Address owner) {
        if (owner == null) {
            throw new IllegalArgumentException("owner cannot be null");
        }
        if (!this.members.contains(owner)) {
            return IntSets.immutableEmptySet();
        }
        IntSet segments = IntSets.mutableEmptySet((int)this.segmentOwners.length);
        for (int segment = 0; segment < this.segmentOwners.length; ++segment) {
            if (!owner.equals(this.segmentOwners[segment].get(0))) continue;
            segments.set(segment);
        }
        return segments;
    }

    @Override
    public List<Address> locateOwnersForSegment(int segmentId) {
        return this.segmentOwners[segmentId];
    }

    @Override
    public Address locatePrimaryOwnerForSegment(int segmentId) {
        return this.segmentOwners[segmentId].get(0);
    }

    @Override
    public boolean isSegmentLocalToNode(Address nodeAddress, int segmentId) {
        return this.segmentOwners[segmentId].contains(nodeAddress);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int hashCodeInternal() {
        int result = this.numOwners;
        result = 31 * result + this.members.hashCode();
        result = 31 * result + Arrays.hashCode(this.segmentOwners);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultConsistentHash that = (DefaultConsistentHash)o;
        if (this.numOwners != that.numOwners) {
            return false;
        }
        if (this.segmentOwners.length != that.segmentOwners.length) {
            return false;
        }
        if (!this.members.equals(that.members)) {
            return false;
        }
        for (int i = 0; i < this.segmentOwners.length; ++i) {
            if (this.segmentOwners[i].equals(that.segmentOwners[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        OwnershipStatistics stats = new OwnershipStatistics(this, this.members);
        StringBuilder sb = new StringBuilder("DefaultConsistentHash{");
        sb.append("ns=").append(this.segmentOwners.length);
        sb.append(", owners = (").append(this.members.size()).append(")[");
        boolean first = true;
        for (Address a : this.members) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            int primaryOwned = stats.getPrimaryOwned(a);
            int owned = stats.getOwned(a);
            sb.append(a).append(": ").append(primaryOwned).append('+').append(owned - primaryOwned);
        }
        sb.append("]}");
        return sb.toString();
    }

    @Override
    public String getRoutingTableAsString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.segmentOwners.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(i).append(':');
            for (int j = 0; j < this.segmentOwners[i].size(); ++j) {
                sb.append(' ').append(this.members.indexOf(this.segmentOwners[i].get(j)));
            }
        }
        return sb.toString();
    }

    public DefaultConsistentHash union(DefaultConsistentHash dch2) {
        this.checkSameHashAndSegments(dch2);
        if (this.numOwners != dch2.getNumOwners()) {
            throw new IllegalArgumentException("The consistent hash objects must have the same number of owners");
        }
        ArrayList<Address> unionMembers = new ArrayList<Address>(this.members);
        DefaultConsistentHash.mergeLists(unionMembers, dch2.getMembers());
        List[] unionSegmentOwners = new List[this.segmentOwners.length];
        for (int i = 0; i < this.segmentOwners.length; ++i) {
            unionSegmentOwners[i] = new ArrayList<Address>(this.locateOwnersForSegment(i));
            DefaultConsistentHash.mergeLists(unionSegmentOwners[i], dch2.locateOwnersForSegment(i));
        }
        Map<Address, Float> unionCapacityFactors = this.unionCapacityFactors(dch2);
        return new DefaultConsistentHash(this.numOwners, unionSegmentOwners.length, unionMembers, unionCapacityFactors, unionSegmentOwners);
    }

    public String prettyPrintOwnership() {
        StringBuilder sb = new StringBuilder();
        for (Address member : this.getMembers()) {
            sb.append("\n").append(member).append(":");
            for (int segment = 0; segment < this.segmentOwners.length; ++segment) {
                int index = this.segmentOwners[segment].indexOf(member);
                if (index < 0) continue;
                sb.append(' ').append(segment);
                if (index != 0) continue;
                sb.append('\'');
            }
        }
        return sb.toString();
    }

    @Override
    public void toScopedState(ScopedPersistentState state) {
        super.toScopedState(state);
        state.setProperty(STATE_NUM_OWNERS, this.numOwners);
        state.setProperty(STATE_SEGMENT_OWNERS, this.segmentOwners.length);
        for (int i = 0; i < this.segmentOwners.length; ++i) {
            List<Address> segmentOwnerAddresses = this.segmentOwners[i];
            state.setProperty(String.format(STATE_SEGMENT_OWNER_COUNT, i), segmentOwnerAddresses.size());
            for (int j = 0; j < segmentOwnerAddresses.size(); ++j) {
                state.setProperty(String.format(STATE_SEGMENT_OWNER, i, j), segmentOwnerAddresses.get(j).toString());
            }
        }
    }

    @Override
    public ConsistentHash remapAddresses(UnaryOperator<Address> remapper) {
        List<Address> remappedMembers = this.remapMembers(remapper, false);
        if (remappedMembers == null) {
            return null;
        }
        Map<Address, Float> remappedCapacityFactors = this.remapCapacityFactors(remapper, false);
        List<Address>[] remappedSegmentOwners = this.remapSegmentOwners(remapper, false);
        return new DefaultConsistentHash(this.numOwners, this.segmentOwners.length, remappedMembers, remappedCapacityFactors, remappedSegmentOwners);
    }

    @Override
    public ConsistentHash remapAddressRemoveMissing(UnaryOperator<Address> remapper) {
        List<Address> remappedMembers = this.remapMembers(remapper, true);
        if (remappedMembers == null) {
            return null;
        }
        Map<Address, Float> remappedCapacityFactors = this.remapCapacityFactors(remapper, true);
        List<Address>[] remappedSegmentOwners = this.remapSegmentOwners(remapper, true);
        return new DefaultConsistentHash(this.numOwners, this.segmentOwners.length, remappedMembers, remappedCapacityFactors, remappedSegmentOwners);
    }

    private List<Address>[] remapSegmentOwners(UnaryOperator<Address> remapper, boolean allowMissing) {
        List[] remappedSegmentOwners = new List[this.segmentOwners.length];
        for (int i = 0; i < this.segmentOwners.length; ++i) {
            ArrayList<Address> remappedOwners = new ArrayList<Address>(this.segmentOwners[i].size());
            for (Address address : this.segmentOwners[i]) {
                Address a = (Address)remapper.apply(address);
                if (a == null) {
                    if (allowMissing) continue;
                    return null;
                }
                remappedOwners.add(a);
            }
            remappedSegmentOwners[i] = remappedOwners;
        }
        return remappedSegmentOwners;
    }
}

