/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.globalstate.ScopedPersistentState;
import org.infinispan.remoting.transport.Address;
import org.infinispan.topology.PersistentUUID;

public abstract class AbstractConsistentHash
implements ConsistentHash {
    protected static final String STATE_CAPACITY_FACTOR = "capacityFactor.%d";
    protected static final String STATE_CAPACITY_FACTORS = "capacityFactors";
    protected static final String STATE_NUM_SEGMENTS = "numSegments";
    protected final List<Address> members;
    protected final List<Float> capacityFactors;

    protected AbstractConsistentHash(int numSegments, List<Address> members, Map<Address, Float> capacityFactors) {
        if (numSegments < 1) {
            throw new IllegalArgumentException("The number of segments must be strictly positive");
        }
        this.members = new ArrayList<Address>(members);
        if (capacityFactors == null) {
            this.capacityFactors = null;
        } else {
            this.capacityFactors = new ArrayList<Float>(members.size());
            for (Address member : members) {
                this.capacityFactors.add(capacityFactors.get(member));
            }
        }
    }

    protected AbstractConsistentHash(int numSegments, List<Address> members, List<Float> capacityFactors) {
        if (numSegments < 1) {
            throw new IllegalArgumentException("The number of segments must be strictly positive");
        }
        this.members = members;
        this.capacityFactors = capacityFactors;
    }

    protected AbstractConsistentHash(ScopedPersistentState state) {
        this(AbstractConsistentHash.parseNumSegments(state), AbstractConsistentHash.parseMembers(state), AbstractConsistentHash.parseCapacityFactors(state));
    }

    protected static int parseNumSegments(ScopedPersistentState state) {
        return state.getIntProperty(STATE_NUM_SEGMENTS);
    }

    protected static List<Address> parseMembers(ScopedPersistentState state) {
        int numMembers = Integer.parseInt(state.getProperty("members"));
        ArrayList<Address> members = new ArrayList<Address>(numMembers);
        for (int i = 0; i < numMembers; ++i) {
            PersistentUUID uuid = PersistentUUID.fromString(state.getProperty(String.format("member.%d", i)));
            members.add(uuid);
        }
        return members;
    }

    protected static List<Float> parseCapacityFactors(ScopedPersistentState state) {
        int numCapacityFactors = Integer.parseInt(state.getProperty(STATE_CAPACITY_FACTORS));
        ArrayList<Float> capacityFactors = new ArrayList<Float>(numCapacityFactors);
        for (int i = 0; i < numCapacityFactors; ++i) {
            capacityFactors.add(Float.valueOf(Float.parseFloat(state.getProperty(String.format(STATE_CAPACITY_FACTOR, i)))));
        }
        return capacityFactors;
    }

    @Override
    public void toScopedState(ScopedPersistentState state) {
        int i;
        state.setProperty("consistentHash", this.getClass().getName());
        state.setProperty(STATE_NUM_SEGMENTS, this.getNumSegments());
        state.setProperty("members", this.members.size());
        for (i = 0; i < this.members.size(); ++i) {
            state.setProperty(String.format("member.%d", i), this.members.get(i).toString());
        }
        state.setProperty(STATE_CAPACITY_FACTORS, this.capacityFactors.size());
        for (i = 0; i < this.capacityFactors.size(); ++i) {
            state.setProperty(String.format(STATE_CAPACITY_FACTOR, i), this.capacityFactors.get(i).floatValue());
        }
    }

    @Override
    public List<Address> getMembers() {
        return this.members;
    }

    protected static void mergeLists(List<Address> dest, List<Address> src) {
        for (Address node : src) {
            if (dest.contains(node)) continue;
            dest.add(node);
        }
    }

    public static HashMap<Address, Integer> getMemberIndexMap(List<Address> members) {
        HashMap<Address, Integer> memberIndexes = new HashMap<Address, Integer>(members.size());
        for (int i = 0; i < members.size(); ++i) {
            memberIndexes.put(members.get(i), i);
        }
        return memberIndexes;
    }

    @Override
    public Map<Address, Float> getCapacityFactors() {
        if (this.capacityFactors == null) {
            return null;
        }
        HashMap<Address, Float> capacityFactorsMap = new HashMap<Address, Float>(this.members.size());
        for (int i = 0; i < this.members.size(); ++i) {
            capacityFactorsMap.put(this.members.get(i), this.capacityFactors.get(i));
        }
        return capacityFactorsMap;
    }

    protected Map<Address, Float> unionCapacityFactors(AbstractConsistentHash ch2) {
        HashMap<Address, Float> unionCapacityFactors = null;
        if (this.capacityFactors != null || ch2.capacityFactors != null) {
            unionCapacityFactors = new HashMap<Address, Float>();
            if (this.capacityFactors != null) {
                unionCapacityFactors.putAll(this.getCapacityFactors());
            } else {
                for (Address node : this.members) {
                    unionCapacityFactors.put(node, Float.valueOf(1.0f));
                }
            }
            if (ch2.capacityFactors != null) {
                unionCapacityFactors.putAll(ch2.getCapacityFactors());
            } else {
                for (Address node : ch2.members) {
                    unionCapacityFactors.put(node, Float.valueOf(1.0f));
                }
            }
        }
        return unionCapacityFactors;
    }

    protected void checkSameHashAndSegments(AbstractConsistentHash dch2) {
        int numSegments = this.getNumSegments();
        if (numSegments != dch2.getNumSegments()) {
            throw new IllegalArgumentException("The consistent hash objects must have the same number of segments");
        }
    }

    protected Map<Address, Float> remapCapacityFactors(UnaryOperator<Address> remapper, boolean allowMissing) {
        HashMap<Address, Float> remappedCapacityFactors = null;
        if (this.capacityFactors != null) {
            remappedCapacityFactors = new HashMap<Address, Float>(this.members.size());
            for (int i = 0; i < this.members.size(); ++i) {
                Address a = (Address)remapper.apply(this.members.get(i));
                if (a == null) {
                    if (allowMissing) continue;
                    return null;
                }
                remappedCapacityFactors.put(a, this.capacityFactors.get(i));
            }
        }
        return remappedCapacityFactors;
    }

    protected List<Address> remapMembers(UnaryOperator<Address> remapper, boolean allowMissing) {
        ArrayList<Address> remappedMembers = new ArrayList<Address>(this.members.size());
        Iterator<Address> i = this.members.iterator();
        while (i.hasNext()) {
            Address a = (Address)remapper.apply(i.next());
            if (a == null) {
                if (allowMissing) continue;
                return null;
            }
            remappedMembers.add(a);
        }
        return remappedMembers;
    }
}

