/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries.metadata;

import org.infinispan.container.entries.ExpiryHelper;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.metadata.MetadataAware;
import org.infinispan.container.entries.metadata.MetadataMortalCacheValue;
import org.infinispan.container.entries.metadata.MetadataTransientMortalCacheEntry;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.PrivateMetadata;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=1132)
public class MetadataTransientMortalCacheValue
extends MetadataMortalCacheValue
implements MetadataAware {
    long lastUsed;

    public MetadataTransientMortalCacheValue(Object value, Metadata metadata, long created, long lastUsed) {
        this(value, null, metadata, created, lastUsed);
    }

    protected MetadataTransientMortalCacheValue(Object value, PrivateMetadata internalMetadata, Metadata metadata, long created, long lastUsed) {
        super(value, internalMetadata, metadata, created);
        this.lastUsed = lastUsed;
    }

    @ProtoFactory
    MetadataTransientMortalCacheValue(MarshallableObject<?> wrappedValue, PrivateMetadata internalMetadata, MarshallableObject<Metadata> wrappedMetadata, long created, long lastUsed) {
        super(wrappedValue, internalMetadata, wrappedMetadata, created);
        this.lastUsed = lastUsed;
    }

    @Override
    @ProtoField(value=5)
    public long getLastUsed() {
        return this.lastUsed;
    }

    @Override
    public InternalCacheEntry<?, ?> toInternalCacheEntry(Object key) {
        return new MetadataTransientMortalCacheEntry((Object)((MarshallableObject)key), this.value, this.internalMetadata, this.metadata, this.lastUsed, this.created);
    }

    @Override
    public long getMaxIdle() {
        return this.metadata.maxIdle();
    }

    @Override
    public boolean isExpired(long now) {
        return ExpiryHelper.isExpiredTransientMortal(this.metadata.maxIdle(), this.lastUsed, this.metadata.lifespan(), this.created, now);
    }

    @Override
    public boolean isMaxIdleExpirable() {
        return true;
    }

    @Override
    public long getExpiryTime() {
        long muet;
        long lifespan = this.metadata.lifespan();
        long lset = lifespan > -1L ? this.created + lifespan : -1L;
        long maxIdle = this.metadata.maxIdle();
        long l = muet = maxIdle > -1L ? this.lastUsed + maxIdle : -1L;
        if (lset == -1L) {
            return muet;
        }
        if (muet == -1L) {
            return lset;
        }
        return Math.min(lset, muet);
    }

    @Override
    protected void appendFieldsToString(StringBuilder builder) {
        super.appendFieldsToString(builder);
        builder.append(", lastUsed=").append(this.lastUsed);
    }
}

