/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries.metadata;

import org.infinispan.container.entries.ExpiryHelper;
import org.infinispan.container.entries.ImmortalCacheValue;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.metadata.MetadataAware;
import org.infinispan.container.entries.metadata.MetadataTransientCacheEntry;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.PrivateMetadata;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=1130)
public class MetadataTransientCacheValue
extends ImmortalCacheValue
implements MetadataAware {
    Metadata metadata;
    long lastUsed;

    public MetadataTransientCacheValue(Object value, Metadata metadata, long lastUsed) {
        this(value, null, metadata, lastUsed);
    }

    protected MetadataTransientCacheValue(Object value, PrivateMetadata internalMetadata, Metadata metadata, long lastUsed) {
        super(value, internalMetadata);
        this.metadata = metadata;
        this.lastUsed = lastUsed;
    }

    @ProtoFactory
    protected MetadataTransientCacheValue(MarshallableObject<?> wrappedValue, PrivateMetadata internalMetadata, MarshallableObject<Metadata> wrappedMetadata, long lastUsed) {
        super(wrappedValue, internalMetadata);
        this.metadata = MarshallableObject.unwrap(wrappedMetadata);
        this.lastUsed = lastUsed;
    }

    @ProtoField(number=4, name="metadata")
    MarshallableObject<Metadata> getWrappedMetadata() {
        return MarshallableObject.create(this.metadata);
    }

    @Override
    @ProtoField(value=5)
    public final long getLastUsed() {
        return this.lastUsed;
    }

    @Override
    public InternalCacheEntry<?, ?> toInternalCacheEntry(Object key) {
        return new MetadataTransientCacheEntry(key, this.value, this.internalMetadata, this.metadata, this.lastUsed);
    }

    @Override
    public long getMaxIdle() {
        return this.metadata.maxIdle();
    }

    @Override
    public final boolean isExpired(long now) {
        return ExpiryHelper.isExpiredTransient(this.metadata.maxIdle(), this.lastUsed, now);
    }

    @Override
    public boolean canExpire() {
        return true;
    }

    @Override
    public boolean isMaxIdleExpirable() {
        return true;
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public long getExpiryTime() {
        long maxIdle = this.metadata.maxIdle();
        return maxIdle > -1L ? this.lastUsed + maxIdle : -1L;
    }

    @Override
    protected void appendFieldsToString(StringBuilder builder) {
        super.appendFieldsToString(builder);
        builder.append(", metadata=").append(this.metadata);
        builder.append(", lastUsed=").append(this.lastUsed);
    }
}

