/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.util.Objects;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.MetadataAwareCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.write.AbstractDataWriteCommand;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commons.util.Util;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.PrivateMetadata;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.util.ByteString;

@ProtoTypeId(value=27)
public class PutKeyValueCommand
extends AbstractDataWriteCommand
implements MetadataAwareCommand {
    private Object value;
    private boolean putIfAbsent;
    private boolean returnEntry;
    private Metadata metadata;
    private ValueMatcher valueMatcher;
    private PrivateMetadata internalMetadata;
    private transient boolean successful = true;

    public PutKeyValueCommand(ByteString cacheName, Object key, Object value, boolean putIfAbsent, boolean returnEntry, Metadata metadata, int segment, long flagsBitSet, CommandInvocationId commandInvocationId) {
        super(cacheName, key, segment, flagsBitSet, commandInvocationId);
        this.value = value;
        this.putIfAbsent = putIfAbsent;
        this.returnEntry = returnEntry;
        this.valueMatcher = putIfAbsent ? ValueMatcher.MATCH_EXPECTED : ValueMatcher.MATCH_ALWAYS;
        this.metadata = metadata;
    }

    @ProtoFactory
    PutKeyValueCommand(ByteString cacheName, MarshallableObject<?> wrappedKey, long flagsWithoutRemote, int topologyId, int segment, CommandInvocationId commandInvocationId, MarshallableObject<?> wrappedValue, MarshallableObject<Metadata> wrappedMetadata, ValueMatcher valueMatcher, boolean putIfAbsent, PrivateMetadata internalMetadata, boolean returnEntryNecessary) {
        super(cacheName, wrappedKey, flagsWithoutRemote, topologyId, segment, commandInvocationId);
        this.value = MarshallableObject.unwrap(wrappedValue);
        this.metadata = MarshallableObject.unwrap(wrappedMetadata);
        this.valueMatcher = valueMatcher;
        this.putIfAbsent = putIfAbsent;
        this.internalMetadata = internalMetadata;
        this.returnEntry = returnEntryNecessary;
    }

    @ProtoField(number=7, name="value")
    MarshallableObject<?> getWrappedValue() {
        return MarshallableObject.create(this.value);
    }

    @ProtoField(number=8, name="metadata")
    MarshallableObject<Metadata> getWrappedMetadata() {
        return MarshallableObject.create(this.metadata);
    }

    @Override
    @ProtoField(value=9)
    public ValueMatcher getValueMatcher() {
        return this.valueMatcher;
    }

    @ProtoField(value=10)
    public boolean isPutIfAbsent() {
        return this.putIfAbsent;
    }

    @Override
    @ProtoField(value=11)
    public PrivateMetadata getInternalMetadata() {
        return this.internalMetadata;
    }

    @ProtoField(number=12, name="returnEntry")
    public boolean isReturnEntryNecessary() {
        return this.returnEntry;
    }

    @Override
    public void setInternalMetadata(PrivateMetadata internalMetadata) {
        this.internalMetadata = internalMetadata;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitPutKeyValueCommand(ctx, this);
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        if (this.isConditional() || !this.hasAnyFlag(FlagBitSets.IGNORE_RETURN_VALUES)) {
            return VisitableCommand.LoadType.PRIMARY;
        }
        return VisitableCommand.LoadType.DONT_LOAD;
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public void setPutIfAbsent(boolean putIfAbsent) {
        this.putIfAbsent = putIfAbsent;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PutKeyValueCommand that = (PutKeyValueCommand)o;
        return this.putIfAbsent == that.putIfAbsent && Objects.equals(this.value, that.value) && Objects.equals(this.metadata, that.metadata);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.putIfAbsent ? 1 : 0);
        result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "PutKeyValueCommand{key=" + Util.toStr((Object)this.key) + ", value=" + Util.toStr((Object)this.value) + ", flags=" + this.printFlags() + ", commandInvocationId=" + CommandInvocationId.show(this.commandInvocationId) + ", putIfAbsent=" + this.putIfAbsent + ", returnEntry=" + this.returnEntry + ", valueMatcher=" + (Object)((Object)this.valueMatcher) + ", metadata=" + this.metadata + ", internalMetadata=" + this.internalMetadata + ", successful=" + this.successful + ", topologyId=" + this.getTopologyId() + ", segment=" + this.segment + "}";
    }

    @Override
    public boolean isSuccessful() {
        return this.successful;
    }

    @Override
    public boolean isConditional() {
        return this.putIfAbsent;
    }

    @Override
    public void setValueMatcher(ValueMatcher valueMatcher) {
        this.valueMatcher = valueMatcher;
    }

    @Override
    public void fail() {
        this.successful = false;
    }

    @Override
    public boolean isReturnValueExpected() {
        return this.isConditional() || super.isReturnValueExpected();
    }
}

