/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.util.Objects;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.MetadataAwareCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.write.AbstractDataWriteCommand;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.PrivateMetadata;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.util.ByteString;
import org.infinispan.xsite.spi.SiteEntry;

@ProtoTypeId(value=1101)
public class IracPutKeyValueCommand
extends AbstractDataWriteCommand
implements MetadataAwareCommand {
    private Object value;
    private Metadata metadata;
    private PrivateMetadata privateMetadata;
    private transient boolean successful = true;
    private boolean expiration;

    public IracPutKeyValueCommand(ByteString cacheName, Object key, int segment, CommandInvocationId commandInvocationId, Object value, Metadata metadata, PrivateMetadata privateMetadata) {
        super(cacheName, key, segment, FlagBitSets.IRAC_UPDATE, commandInvocationId);
        assert (privateMetadata != null);
        this.value = value;
        this.metadata = metadata;
        this.privateMetadata = privateMetadata;
    }

    @ProtoFactory
    IracPutKeyValueCommand(ByteString cacheName, MarshallableObject<?> wrappedKey, long flagsWithoutRemote, int topologyId, int segment, CommandInvocationId commandInvocationId, MarshallableObject<Object> wrappedValue, MarshallableObject<Metadata> wrappedMetadata, boolean expiration, PrivateMetadata internalMetadata) {
        super(cacheName, wrappedKey, FlagBitSets.IRAC_UPDATE, topologyId, segment, commandInvocationId);
        this.value = MarshallableObject.unwrap(wrappedValue);
        this.metadata = MarshallableObject.unwrap(wrappedMetadata);
        this.expiration = expiration;
        this.privateMetadata = internalMetadata;
    }

    @ProtoField(value=7)
    MarshallableObject<Object> getWrappedValue() {
        return MarshallableObject.create(this.value);
    }

    @ProtoField(value=8)
    MarshallableObject<Metadata> getWrappedMetadata() {
        return MarshallableObject.create(this.metadata);
    }

    @ProtoField(value=9)
    boolean getExpiration() {
        return this.expiration;
    }

    @Override
    @ProtoField(value=10)
    public PrivateMetadata getInternalMetadata() {
        return this.privateMetadata;
    }

    @Override
    public void setInternalMetadata(PrivateMetadata internalMetadata) {
        this.privateMetadata = internalMetadata;
    }

    @Override
    public PrivateMetadata getInternalMetadata(Object key) {
        assert (Objects.equals(this.key, key));
        return this.getInternalMetadata();
    }

    @Override
    public void setInternalMetadata(Object key, PrivateMetadata internalMetadata) {
        assert (Objects.equals(this.key, key));
        this.setInternalMetadata(internalMetadata);
    }

    @Override
    public boolean isSuccessful() {
        return this.successful;
    }

    @Override
    public boolean isConditional() {
        return false;
    }

    @Override
    public ValueMatcher getValueMatcher() {
        return ValueMatcher.MATCH_ALWAYS;
    }

    @Override
    public void setValueMatcher(ValueMatcher valueMatcher) {
    }

    @Override
    public void fail() {
        this.successful = false;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitIracPutKeyValueCommand(ctx, this);
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        return VisitableCommand.LoadType.PRIMARY;
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isRemove() {
        return this.value == null;
    }

    public SiteEntry<Object> createSiteEntry(String site) {
        return new SiteEntry<Object>(site, this.value, this.metadata);
    }

    public void updateCommand(SiteEntry<Object> siteEntry) {
        this.value = siteEntry.getValue();
        this.setMetadata(siteEntry.getMetadata());
    }

    public boolean isExpiration() {
        return this.expiration;
    }

    public void setExpiration(boolean expiration) {
        this.expiration = expiration;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IracPutKeyValueCommand that = (IracPutKeyValueCommand)o;
        return Objects.equals(this.value, that.value) && Objects.equals(this.metadata, that.metadata) && Objects.equals(this.privateMetadata, that.privateMetadata);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.value, this.metadata, this.privateMetadata);
    }

    @Override
    public String toString() {
        return "IracPutKeyValueCommand{key=" + String.valueOf(this.key) + ", value=" + String.valueOf(this.value) + ", metadata=" + String.valueOf(this.metadata) + ", privateMetadata=" + String.valueOf(this.privateMetadata) + ", successful=" + this.successful + ", commandInvocationId=" + String.valueOf(this.commandInvocationId) + "}";
    }
}

