/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.triangle;

import java.util.function.BiFunction;
import java.util.function.Function;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.triangle.BackupWriteCommand;
import org.infinispan.commands.write.AbstractDataWriteCommand;
import org.infinispan.commands.write.ComputeCommand;
import org.infinispan.commands.write.ComputeIfAbsentCommand;
import org.infinispan.commands.write.IracPutKeyValueCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.RemoveExpiredCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.PrivateMetadata;
import org.infinispan.protostream.annotations.Proto;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoName;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.util.ByteString;

@ProtoTypeId(value=1180)
public class SingleKeyBackupWriteCommand
extends BackupWriteCommand {
    final Operation operation;
    final Object key;
    final Object valueOrFunction;
    final Metadata metadata;
    final PrivateMetadata internalMetadata;

    public static SingleKeyBackupWriteCommand create(ByteString cacheName, PutKeyValueCommand command, long sequence, int segmentId) {
        return new SingleKeyBackupWriteCommand(cacheName, command, sequence, segmentId, Operation.WRITE, command.getKey(), command.getValue(), command.getMetadata(), command.getInternalMetadata());
    }

    public static SingleKeyBackupWriteCommand create(ByteString cacheName, RemoveCommand command, long sequence, int segmentId) {
        boolean removeExpired = command instanceof RemoveExpiredCommand;
        Operation operation = removeExpired ? Operation.REMOVE_EXPIRED : Operation.REMOVE;
        Object value = removeExpired ? command.getValue() : null;
        return new SingleKeyBackupWriteCommand(cacheName, command, sequence, segmentId, operation, command.getKey(), value, null, command.getInternalMetadata());
    }

    public static SingleKeyBackupWriteCommand create(ByteString cacheName, ReplaceCommand command, long sequence, int segmentId) {
        return new SingleKeyBackupWriteCommand(cacheName, command, sequence, segmentId, Operation.REPLACE, command.getKey(), command.getNewValue(), command.getMetadata(), command.getInternalMetadata());
    }

    public static SingleKeyBackupWriteCommand create(ByteString cacheName, ComputeIfAbsentCommand command, long sequence, int segmentId) {
        return new SingleKeyBackupWriteCommand(cacheName, command, sequence, segmentId, Operation.COMPUTE_IF_ABSENT, command.getKey(), command.getMappingFunction(), command.getMetadata(), command.getInternalMetadata());
    }

    public static SingleKeyBackupWriteCommand create(ByteString cacheName, ComputeCommand command, long sequence, int segmentId) {
        Operation operation = command.isComputeIfPresent() ? Operation.COMPUTE_IF_PRESENT : Operation.COMPUTE;
        return new SingleKeyBackupWriteCommand(cacheName, command, sequence, segmentId, operation, command.getKey(), command.getRemappingBiFunction(), command.getMetadata(), command.getInternalMetadata());
    }

    public static SingleKeyBackupWriteCommand create(ByteString cacheName, IracPutKeyValueCommand command, long sequence, int segmentId) {
        return new SingleKeyBackupWriteCommand(cacheName, command, sequence, segmentId, Operation.WRITE, command.getKey(), command.getValue(), command.getMetadata(), command.getInternalMetadata());
    }

    private SingleKeyBackupWriteCommand(ByteString cacheName, WriteCommand command, long sequence, int segmentId, Operation operation, Object key, Object valueOrFunction, Metadata metadata, PrivateMetadata internalMetadata) {
        super(cacheName, command, sequence, segmentId);
        this.operation = operation;
        this.key = key;
        this.valueOrFunction = valueOrFunction;
        this.metadata = metadata;
        this.internalMetadata = internalMetadata;
    }

    @ProtoFactory
    SingleKeyBackupWriteCommand(ByteString cacheName, CommandInvocationId commandInvocationId, int topologyId, long flags, long sequence, int segmentId, Operation operation, MarshallableObject<?> key, MarshallableObject<?> valueOrFunction, MarshallableObject<Metadata> metadata, PrivateMetadata internalMetadata) {
        super(cacheName, commandInvocationId, topologyId, flags, sequence, segmentId);
        this.operation = operation;
        this.key = MarshallableObject.unwrap(key);
        this.valueOrFunction = MarshallableObject.unwrap(valueOrFunction);
        this.metadata = MarshallableObject.unwrap(metadata);
        this.internalMetadata = internalMetadata;
    }

    @ProtoField(value=7)
    Operation getOperation() {
        return this.operation;
    }

    @ProtoField(value=8)
    MarshallableObject<?> getKey() {
        return MarshallableObject.create(this.key);
    }

    @ProtoField(value=9)
    MarshallableObject<?> getValueOrFunction() {
        return MarshallableObject.create(this.valueOrFunction);
    }

    @ProtoField(value=10)
    MarshallableObject<Metadata> getMetadata() {
        return MarshallableObject.create(this.metadata);
    }

    @ProtoField(value=11)
    PrivateMetadata getInternalMetadata() {
        return this.internalMetadata;
    }

    @Override
    public String toString() {
        return "SingleKeyBackupWriteCommand{" + this.toStringFields() + "}";
    }

    @Override
    WriteCommand createWriteCommand() {
        AbstractDataWriteCommand command = switch (this.operation.ordinal()) {
            case 1 -> new RemoveCommand(this.cacheName, this.key, null, false, this.segmentId, this.getFlags(), this.getCommandInvocationId());
            case 0 -> EnumUtil.containsAny((long)this.getFlags(), (long)FlagBitSets.IRAC_UPDATE) ? new IracPutKeyValueCommand(this.cacheName, this.key, this.segmentId, this.getCommandInvocationId(), this.valueOrFunction, this.metadata, this.internalMetadata) : new PutKeyValueCommand(this.cacheName, this.key, this.valueOrFunction, false, false, this.metadata, this.segmentId, this.getFlags(), this.getCommandInvocationId());
            case 4 -> new ComputeCommand(this.cacheName, this.key, (BiFunction)this.valueOrFunction, false, this.segmentId, this.getFlags(), this.getCommandInvocationId(), this.metadata);
            case 3 -> new ReplaceCommand(this.cacheName, this.key, null, this.valueOrFunction, false, this.metadata, this.segmentId, this.getFlags(), this.getCommandInvocationId());
            case 2 -> new RemoveExpiredCommand(this.cacheName, this.key, this.valueOrFunction, null, false, this.segmentId, this.getFlags(), this.getCommandInvocationId());
            case 5 -> new ComputeCommand(this.cacheName, this.key, (BiFunction)this.valueOrFunction, true, this.segmentId, this.getFlags(), this.getCommandInvocationId(), this.metadata);
            case 6 -> new ComputeIfAbsentCommand(this.cacheName, this.key, (Function)this.valueOrFunction, this.segmentId, this.getFlags(), this.getCommandInvocationId(), this.metadata);
            default -> throw new IllegalStateException("Unknown operation " + String.valueOf((Object)this.operation));
        };
        command.setInternalMetadata(this.internalMetadata);
        return command;
    }

    @Override
    String toStringFields() {
        return super.toStringFields() + ", operation=" + String.valueOf((Object)this.operation) + ", key=" + String.valueOf(this.key) + ", valueOrFunction=" + String.valueOf(this.valueOrFunction) + ", metadata=" + String.valueOf(this.metadata) + ", internalMetadata=" + String.valueOf(this.internalMetadata);
    }

    @Proto
    @ProtoName(value="SingleKeyBackupOperation")
    @ProtoTypeId(value=1181)
    public static enum Operation {
        WRITE,
        REMOVE,
        REMOVE_EXPIRED,
        REPLACE,
        COMPUTE,
        COMPUTE_IF_PRESENT,
        COMPUTE_IF_ABSENT;

    }
}

