/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.triangle;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.triangle.BackupWriteCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.marshall.protostream.impl.MarshallableMap;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.PrivateMetadata;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.util.ByteString;
import org.infinispan.util.TriangleFunctionsUtil;

@ProtoTypeId(value=1152)
public class PutMapBackupWriteCommand
extends BackupWriteCommand {
    private Map<Object, Object> map;
    private Metadata metadata;
    private Map<Object, PrivateMetadata> internalMetadataMap;

    public PutMapBackupWriteCommand(ByteString cacheName, PutMapCommand command, long sequence, int segmentId, Collection<Object> keys) {
        super(cacheName, command, sequence, segmentId);
        this.map = TriangleFunctionsUtil.filterEntries(command.getMap(), keys);
        this.metadata = command.getMetadata();
        this.internalMetadataMap = new HashMap<Object, PrivateMetadata>();
        for (Object key : this.map.keySet()) {
            this.internalMetadataMap.put(key, command.getInternalMetadata(key));
        }
    }

    @ProtoFactory
    PutMapBackupWriteCommand(ByteString cacheName, CommandInvocationId commandInvocationId, int topologyId, long flags, long sequence, int segmentId, MarshallableMap<Object, Object> map, MarshallableObject<Metadata> metadata, MarshallableMap<Object, PrivateMetadata> internalMetadata) {
        super(cacheName, commandInvocationId, topologyId, flags, sequence, segmentId);
        this.map = MarshallableMap.unwrap(map);
        this.metadata = MarshallableObject.unwrap(metadata);
        this.internalMetadataMap = MarshallableMap.unwrap(internalMetadata);
    }

    @ProtoField(value=7)
    MarshallableMap<Object, Object> getMap() {
        return MarshallableMap.create(this.map);
    }

    @ProtoField(value=8)
    MarshallableObject<Metadata> getMetadata() {
        return MarshallableObject.create(this.metadata);
    }

    @ProtoField(value=9)
    MarshallableMap<Object, PrivateMetadata> getInternalMetadata() {
        return MarshallableMap.create(this.internalMetadataMap);
    }

    @Override
    public String toString() {
        return "PutMapBackupWriteCommand{" + this.toStringFields() + "}";
    }

    @Override
    WriteCommand createWriteCommand() {
        PutMapCommand cmd = new PutMapCommand(this.cacheName, this.map, this.metadata, this.getFlags(), this.getCommandInvocationId());
        cmd.setForwarded(true);
        this.internalMetadataMap.forEach(cmd::setInternalMetadata);
        return cmd;
    }

    @Override
    String toStringFields() {
        return super.toStringFields() + ", map=" + String.valueOf(this.map) + ", metadata=" + String.valueOf(this.metadata) + ", internalMetadata=" + String.valueOf(this.internalMetadataMap);
    }
}

