/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.triangle;

import java.util.concurrent.CompletionStage;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextFactory;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.util.ByteString;

public abstract class BackupWriteCommand
extends BaseRpcCommand {
    @ProtoField(value=2)
    final CommandInvocationId commandInvocationId;
    @ProtoField(value=3)
    final int topologyId;
    @ProtoField(value=4)
    final long flags;
    @ProtoField(value=5)
    final long sequence;
    @ProtoField(value=6)
    final int segmentId;

    protected BackupWriteCommand(ByteString cacheName, WriteCommand command, long sequence, int segmentId) {
        super(cacheName);
        this.commandInvocationId = command.getCommandInvocationId();
        this.topologyId = command.getTopologyId();
        this.flags = command.getFlagsBitSet();
        this.sequence = sequence;
        this.segmentId = segmentId;
    }

    protected BackupWriteCommand(ByteString cacheName, CommandInvocationId commandInvocationId, int topologyId, long flags, long sequence, int segmentId) {
        super(cacheName);
        this.commandInvocationId = commandInvocationId;
        this.topologyId = topologyId;
        this.flags = flags;
        this.sequence = sequence;
        this.segmentId = segmentId;
    }

    @Override
    public final CompletionStage<?> invokeAsync(ComponentRegistry componentRegistry) {
        WriteCommand command = this.createWriteCommand();
        if (command == null) {
            return CompletableFutures.completedNull();
        }
        command.init(componentRegistry);
        command.setFlagsBitSet(this.flags);
        command.addFlags(FlagBitSets.SKIP_LOCKING | FlagBitSets.BACKUP_WRITE);
        command.setValueMatcher(ValueMatcher.MATCH_ALWAYS);
        command.setTopologyId(this.topologyId);
        InvocationContextFactory invocationContextFactory = componentRegistry.getInvocationContextFactory().running();
        InvocationContext invocationContext = invocationContextFactory.createRemoteInvocationContextForCommand(command, this.getOrigin());
        AsyncInterceptorChain interceptorChain = componentRegistry.getInterceptorChain().running();
        return interceptorChain.invokeAsync(invocationContext, command);
    }

    @Override
    public final boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public final boolean canBlock() {
        return true;
    }

    public final long getSequence() {
        return this.sequence;
    }

    public final CommandInvocationId getCommandInvocationId() {
        return this.commandInvocationId;
    }

    public final int getTopologyId() {
        return this.topologyId;
    }

    public final long getFlags() {
        return this.flags;
    }

    public final int getSegmentId() {
        return this.segmentId;
    }

    abstract WriteCommand createWriteCommand();

    String toStringFields() {
        return "cacheName=" + String.valueOf(this.cacheName) + ", segment=" + this.segmentId + ", sequence=" + this.sequence + ", commandInvocationId=" + String.valueOf(this.commandInvocationId) + ", topologyId=" + this.topologyId + ", flags=" + this.flags;
    }
}

