/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.topology;

import java.util.List;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.topology.AbstractCacheControlCommand;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.protostream.WrappedMessage;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.infinispan.topology.CacheTopology;
import org.infinispan.topology.PersistentUUID;

@ProtoTypeId(value=1213)
public class TopologyUpdateStableCommand
extends AbstractCacheControlCommand {
    final List<Address> actualMembers;
    @ProtoField(value=1)
    final String cacheName;
    @ProtoField(value=2)
    final List<PersistentUUID> persistentUUIDs;
    @ProtoField(value=3)
    final int rebalanceId;
    @ProtoField(value=4)
    final int topologyId;
    @ProtoField(value=5)
    final int viewId;
    @ProtoField(value=6)
    final WrappedMessage currentCH;
    @ProtoField(value=7)
    final WrappedMessage pendingCH;
    @ProtoField(value=8)
    final boolean topologyRestored;

    @ProtoField(value=9)
    List<JGroupsAddress> getActualMembers() {
        return this.actualMembers;
    }

    @ProtoFactory
    TopologyUpdateStableCommand(String cacheName, List<PersistentUUID> persistentUUIDs, int rebalanceId, int topologyId, int viewId, WrappedMessage currentCH, WrappedMessage pendingCH, List<JGroupsAddress> actualMembers, boolean topologyRestored) {
        this.currentCH = currentCH;
        this.pendingCH = pendingCH;
        this.cacheName = cacheName;
        this.actualMembers = actualMembers;
        this.persistentUUIDs = persistentUUIDs;
        this.rebalanceId = rebalanceId;
        this.topologyId = topologyId;
        this.viewId = viewId;
        this.topologyRestored = topologyRestored;
    }

    public TopologyUpdateStableCommand(String cacheName, Address origin, CacheTopology cacheTopology, int viewId) {
        super(origin);
        this.cacheName = cacheName;
        this.topologyId = cacheTopology.getTopologyId();
        this.rebalanceId = cacheTopology.getRebalanceId();
        this.currentCH = new WrappedMessage((Object)cacheTopology.getCurrentCH());
        this.pendingCH = new WrappedMessage((Object)cacheTopology.getPendingCH());
        this.actualMembers = cacheTopology.getActualMembers();
        this.persistentUUIDs = cacheTopology.getMembersPersistentUUIDs();
        this.viewId = viewId;
        this.topologyRestored = cacheTopology.wasTopologyRestoredFromState();
    }

    @Override
    public CompletionStage<?> invokeAsync(GlobalComponentRegistry gcr) throws Throwable {
        CacheTopology topology = new CacheTopology(this.topologyId, this.rebalanceId, this.topologyRestored, this.getCurrentCH(), this.getPendingCH(), CacheTopology.Phase.NO_REBALANCE, this.actualMembers, this.persistentUUIDs);
        return gcr.getLocalTopologyManager().handleStableTopologyUpdate(this.cacheName, topology, this.origin, this.viewId);
    }

    public ConsistentHash getCurrentCH() {
        return (ConsistentHash)this.currentCH.getValue();
    }

    public ConsistentHash getPendingCH() {
        return (ConsistentHash)this.pendingCH.getValue();
    }

    public int getTopologyId() {
        return this.topologyId;
    }

    public String toString() {
        return "TopologyUpdateStableCommand{cacheName='" + this.cacheName + "', origin=" + String.valueOf(this.origin) + ", currentCH=" + String.valueOf(this.getCurrentCH()) + ", pendingCH=" + String.valueOf(this.getPendingCH()) + ", actualMembers=" + String.valueOf(this.actualMembers) + ", persistentUUIDs=" + String.valueOf(this.persistentUUIDs) + ", rebalanceId=" + this.rebalanceId + ", topologyId=" + this.topologyId + ", viewId=" + this.viewId + "}";
    }
}

