/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.remote;

import java.util.Objects;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.SegmentSpecificCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.remote.BaseClusteredReadCommand;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.configuration.cache.TransactionConfiguration;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextFactory;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.ByteString;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@ProtoTypeId(value=1061)
public class ClusteredGetCommand
extends BaseClusteredReadCommand
implements SegmentSpecificCommand {
    private static final Log log = LogFactory.getLog(ClusteredGetCommand.class);
    private final Object key;
    private final Integer segment;
    private boolean isWrite;

    public ClusteredGetCommand(Object key, ByteString cacheName, Integer segment, long flags) {
        super(cacheName, -1, flags);
        this.key = key;
        this.isWrite = false;
        if (segment != null && segment < 0) {
            throw new IllegalArgumentException("Segment must 0 or greater!");
        }
        this.segment = segment;
        this.flags = flags;
    }

    @ProtoFactory
    ClusteredGetCommand(ByteString cacheName, int topologyId, long flagsWithoutRemote, MarshallableObject<?> wrappedKey, Integer boxedSegment, boolean isWrite) {
        this(MarshallableObject.unwrap(wrappedKey), cacheName, boxedSegment, flagsWithoutRemote);
        this.topologyId = topologyId;
        this.isWrite = isWrite;
    }

    @ProtoField(number=4, name="key")
    MarshallableObject<?> getWrappedKey() {
        return MarshallableObject.create(this.key);
    }

    @Override
    public int getSegment() {
        return this.segment;
    }

    @ProtoField(number=5, name="segment")
    Integer getBoxedSegment() {
        return this.segment;
    }

    @ProtoField(value=6)
    boolean getIsWrite() {
        return this.isWrite;
    }

    @Override
    public CompletionStage<?> invokeAsync(ComponentRegistry componentRegistry) throws Throwable {
        TransactionConfiguration transactionConfiguration;
        long flagBitSet = EnumUtil.bitSetOf((Enum)Flag.SKIP_REMOTE_LOOKUP);
        int segmentToUse = this.segment != null ? this.segment.intValue() : componentRegistry.getComponent(KeyPartitioner.class).getSegment(this.key);
        if (this.isWrite && (transactionConfiguration = componentRegistry.getConfiguration().transaction()).transactionMode() == TransactionMode.TRANSACTIONAL && transactionConfiguration.lockingMode() == LockingMode.PESSIMISTIC) {
            flagBitSet = EnumUtil.mergeBitSets((long)flagBitSet, (long)FlagBitSets.ALREADY_HAS_LOCK);
        }
        GetCacheEntryCommand command = componentRegistry.getCommandsFactory().buildGetCacheEntryCommand(this.key, segmentToUse, EnumUtil.mergeBitSets((long)flagBitSet, (long)this.flags));
        command.setTopologyId(this.topologyId);
        InvocationContextFactory icf = componentRegistry.getInvocationContextFactory().running();
        InvocationContext invocationContext = icf.createRemoteInvocationContextForCommand(command, this.getOrigin());
        AsyncInterceptorChain invoker = componentRegistry.getInterceptorChain().running();
        return invoker.invokeAsync(invocationContext, command).thenApply(rv -> {
            if (log.isTraceEnabled()) {
                log.tracef("Return value for key=%s is %s", this.key, rv);
            }
            if (rv instanceof MVCCEntry) {
                MVCCEntry mvccEntry = (MVCCEntry)rv;
                InternalCacheValue icv = componentRegistry.getInternalEntryFactory().wired().createValue(mvccEntry);
                icv.setInternalMetadata(mvccEntry.getInternalMetadata());
                return icv;
            }
            if (rv instanceof InternalCacheEntry) {
                InternalCacheEntry internalCacheEntry = (InternalCacheEntry)rv;
                return internalCacheEntry.toInternalCacheValue();
            }
            return rv;
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusteredGetCommand that = (ClusteredGetCommand)o;
        return Objects.equals(this.key, that.key);
    }

    public int hashCode() {
        return Objects.hashCode(this.key);
    }

    @Override
    public String toString() {
        return "ClusteredGetCommand{key=" + String.valueOf(this.key) + ", flags=" + EnumUtil.prettyPrintBitSet((long)this.flags, Flag.class) + ", topologyId=" + this.topologyId + "}";
    }

    public boolean isWrite() {
        return this.isWrite;
    }

    public void setWrite(boolean write) {
        this.isWrite = write;
    }

    public Object getKey() {
        return this.key;
    }
}

