/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.remote;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.responses.SuccessfulCollectionResponse;
import org.infinispan.remoting.responses.ValidResponse;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.remoting.transport.ValidSingleResponseCollector;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.ByteString;

@ProtoTypeId(value=1054)
public class CheckTransactionRpcCommand
implements CacheRpcCommand {
    private static final ResponseCollectorImpl INSTANCE = new ResponseCollectorImpl();
    @ProtoField(value=1)
    final ByteString cacheName;
    @ProtoField(value=2)
    final Collection<GlobalTransaction> gtxToCheck;

    public static ResponseCollector<Collection<GlobalTransaction>> responseCollector() {
        return INSTANCE;
    }

    @ProtoFactory
    public CheckTransactionRpcCommand(ByteString cacheName, Collection<GlobalTransaction> gtxToCheck) {
        this.cacheName = cacheName;
        this.gtxToCheck = gtxToCheck;
    }

    @Override
    public ByteString getCacheName() {
        return this.cacheName;
    }

    @Override
    public CompletionStage<?> invokeAsync(ComponentRegistry componentRegistry) {
        TransactionTable txTable = componentRegistry.getTransactionTable();
        this.gtxToCheck.removeIf(txTable::containsLocalTx);
        return CompletableFuture.completedFuture(this.gtxToCheck);
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public Address getOrigin() {
        return null;
    }

    @Override
    public void setOrigin(Address origin) {
    }

    public String toString() {
        return "CheckTransactionRpcCommand{cacheName=" + String.valueOf(this.cacheName) + ", gtxToCheck=" + String.valueOf(this.gtxToCheck) + "}";
    }

    private static class ResponseCollectorImpl
    extends ValidSingleResponseCollector<Collection<GlobalTransaction>> {
        private ResponseCollectorImpl() {
        }

        @Override
        protected Collection<GlobalTransaction> withValidResponse(Address sender, ValidResponse response) {
            if (response instanceof SuccessfulCollectionResponse) {
                SuccessfulCollectionResponse rsp = (SuccessfulCollectionResponse)response;
                return rsp.getResponseValue();
            }
            return Collections.emptyList();
        }

        @Override
        protected Collection<GlobalTransaction> targetNotFound(Address sender) {
            return Collections.emptyList();
        }

        @Override
        protected Collection<GlobalTransaction> withException(Address sender, Exception exception) {
            return Collections.emptyList();
        }
    }
}

