/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.irac;

import java.util.Collection;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.irac.BaseIracCommand;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.container.versioning.irac.IracTombstoneInfo;
import org.infinispan.container.versioning.irac.IracTombstoneManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.util.ByteString;

@ProtoTypeId(value=1114)
public class IracTombstoneStateResponseCommand
extends BaseIracCommand {
    @ProtoField(value=2)
    final Collection<IracTombstoneInfo> state;

    @ProtoFactory
    public IracTombstoneStateResponseCommand(ByteString cacheName, Collection<IracTombstoneInfo> state) {
        super(cacheName);
        this.state = state;
    }

    public CompletionStage<Void> invokeAsync(ComponentRegistry registry) {
        IracTombstoneManager tombstoneManager = registry.getIracTombstoneManager().running();
        for (IracTombstoneInfo data : this.state) {
            tombstoneManager.storeTombstoneIfAbsent(data);
        }
        return CompletableFutures.completedNull();
    }

    public String toString() {
        return "IracTombstoneStateResponseCommand{cacheName=" + String.valueOf(this.cacheName) + ", state=" + String.valueOf(this.state) + "}";
    }
}

