/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.irac;

import java.util.Collection;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.irac.BaseIracCommand;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.ByteString;
import org.infinispan.xsite.irac.IracManagerKeyInfo;

@ProtoTypeId(value=1100)
public class IracPrimaryPendingKeyCheckCommand
extends BaseIracCommand {
    public static final byte COMMAND_ID = 15;
    private Address origin;
    @ProtoField(value=2)
    final Collection<IracManagerKeyInfo> keys;

    @ProtoFactory
    public IracPrimaryPendingKeyCheckCommand(ByteString cacheName, Collection<IracManagerKeyInfo> keys) {
        super(cacheName);
        this.keys = keys;
    }

    public CompletionStage<Void> invokeAsync(ComponentRegistry registry) {
        registry.getIracManager().running().checkStaleKeys(this.origin, this.keys);
        return CompletableFutures.completedNull();
    }

    @Override
    public byte getCommandId() {
        return 15;
    }

    @Override
    public Address getOrigin() {
        return this.origin;
    }

    @Override
    public void setOrigin(Address origin) {
        this.origin = origin;
    }

    public String toString() {
        return "IracTombstonePrimaryCheckCommand{cacheName=" + String.valueOf(this.cacheName) + ", keys=" + String.valueOf(this.keys) + "}";
    }
}

