/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.functional;

import java.util.function.Function;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.functional.functions.InjectableComponent;
import org.infinispan.commands.read.AbstractDataCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.encoding.DataConversion;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.impl.EntryViews;
import org.infinispan.functional.impl.Params;
import org.infinispan.functional.impl.StatsEnvelope;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.util.ByteString;

@ProtoTypeId(value=1154)
public class ReadOnlyKeyCommand<K, V, R>
extends AbstractDataCommand {
    protected Function<EntryView.ReadEntryView<K, V>, R> f;
    protected Params params;
    protected DataConversion keyDataConversion;
    protected DataConversion valueDataConversion;

    public ReadOnlyKeyCommand(ByteString cacheName, Object key, Function<EntryView.ReadEntryView<K, V>, R> f, int segment, Params params, DataConversion keyDataConversion, DataConversion valueDataConversion) {
        super(cacheName, key, segment, params.toFlagsBitSet());
        this.f = f;
        this.params = params;
        this.keyDataConversion = keyDataConversion;
        this.valueDataConversion = valueDataConversion;
    }

    @ProtoFactory
    ReadOnlyKeyCommand(ByteString cacheName, MarshallableObject<?> wrappedKey, long flagsWithoutRemote, int topologyId, int segment, MarshallableObject<Function<EntryView.ReadEntryView<K, V>, R>> wrappedFunction, Params params, DataConversion keyDataConversion, DataConversion valueDataConversion) {
        super(cacheName, wrappedKey, flagsWithoutRemote, topologyId, segment);
        this.f = MarshallableObject.unwrap(wrappedFunction);
        this.params = params;
        this.keyDataConversion = keyDataConversion;
        this.valueDataConversion = valueDataConversion;
    }

    @ProtoField(value=6)
    MarshallableObject<Function<EntryView.ReadEntryView<K, V>, R>> getWrappedFunction() {
        return MarshallableObject.create(this.f);
    }

    @ProtoField(value=7)
    public Params getParams() {
        return this.params;
    }

    @ProtoField(value=8)
    public DataConversion getKeyDataConversion() {
        return this.keyDataConversion;
    }

    @ProtoField(value=9)
    public DataConversion getValueDataConversion() {
        return this.valueDataConversion;
    }

    @Override
    public void init(ComponentRegistry componentRegistry) {
        componentRegistry.wireDependencies(this.keyDataConversion);
        componentRegistry.wireDependencies(this.valueDataConversion);
        if (this.f instanceof InjectableComponent) {
            ((InjectableComponent)((Object)this.f)).inject(componentRegistry);
        }
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitReadOnlyKeyCommand(ctx, this);
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        return VisitableCommand.LoadType.OWNER;
    }

    public Object performOnLostData() {
        return StatsEnvelope.create(this.f.apply(EntryViews.noValue(this.key, this.keyDataConversion)), true);
    }

    @Override
    public String toString() {
        return "ReadOnlyKeyCommand{, key=" + String.valueOf(this.key) + ", f=" + this.f.getClass().getName() + ", keyDataConversion=" + String.valueOf(this.keyDataConversion) + ", valueDataConversion=" + String.valueOf(this.valueDataConversion) + "}";
    }

    public Function<EntryView.ReadEntryView<K, V>, R> getFunction() {
        return this.f;
    }
}

