/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextFactory;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.util.concurrent.locks.RemoteLockCommand;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public interface VisitableCommand
extends CacheRpcCommand {
    public static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());

    default public void init(ComponentRegistry registry) {
    }

    @Override
    default public CompletionStage<?> invokeAsync(ComponentRegistry registry) throws Throwable {
        this.init(registry);
        InvocationContextFactory icf = registry.getInvocationContextFactory().running();
        InvocationContext ctx = icf.createRemoteInvocationContextForCommand(this, this.getOrigin());
        VisitableCommand visitableCommand = this;
        if (visitableCommand instanceof RemoteLockCommand) {
            RemoteLockCommand remoteLockCmd = (RemoteLockCommand)((Object)visitableCommand);
            ctx.setLockOwner(remoteLockCmd.getKeyLockOwner());
        }
        if (log.isTraceEnabled()) {
            log.tracef("Invoking command %s, with originLocal flag set to %b", this, ctx.isOriginLocal());
        }
        return registry.getInterceptorChain().running().invokeAsync(ctx, this);
    }

    public Object acceptVisitor(InvocationContext var1, Visitor var2) throws Throwable;

    public LoadType loadType();

    public static enum LoadType {
        DONT_LOAD,
        PRIMARY,
        OWNER;

    }
}

